/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpHeaderViewer;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HttpTestCaseDetailPage
extends AbstractDetailPage
implements ModifyListener,
IWriteAccessChangeListener,
SelectionListener {
    public static final int COLUMNS_IN_LAYOUT = 2;
    private CCombo methodCombo;
    private StyledText httpVersionText;
    private StyledText hostText;
    private StyledText portText;
    private StyledText absolutePathText;
    private StyledText bodyText;
    private HttpHeaderViewer headerViewer;
    private CCombo m_thinkTimeCo;
    private RequestHelper requestHelper = new RequestHelper();
    private Button m_sslButton;

    public void dispose() {
        if (this.context != null && this.getEditorForm() != null && this.getEditorForm().getBaseEditorExtension() != null) {
            this.getEditorForm().getBaseEditorExtension().removeListener((IWriteAccessChangeListener)this);
        }
        this.headerViewer.dispose();
        this.requestHelper.dispose();
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context) {
        this.context = context;
        this.getEditorForm().getBaseEditorExtension().addListener((IWriteAccessChangeListener)this);
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.HTTP_Version_Label);
        this.httpVersionText = widgetFactory.createStyledText(composite, 65540, this.stripAmps(ToolsUiPluginResourceBundle.HTTP_Version_Label));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.httpVersionText.setLayoutData((Object)gd);
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.RQ_METH_TEXT);
        this.methodCombo = widgetFactory.createCCombo(composite, 0x800000);
        this.methodCombo.setLayoutData((Object)this.getFullRowLayoutData());
        this.methodCombo.setItems(HttpConstants.SUPPORTED_REQUEST_METHODS);
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.HOST_TEXT);
        this.hostText = widgetFactory.createStyledText(composite, 65540, this.stripAmps(ToolsUiPluginResourceBundle.HOST_TEXT));
        this.hostText.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.PORT_TEXT);
        this.portText = widgetFactory.createStyledText(composite, 65540, this.stripAmps(ToolsUiPluginResourceBundle.PORT_TEXT));
        this.portText.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.THINK_TIME);
        this.m_thinkTimeCo = widgetFactory.createCCombo(composite, 0x800000);
        this.m_thinkTimeCo.setLayoutData((Object)this.getFullRowLayoutData());
        this.m_thinkTimeCo.setItems(new String[]{ToolsUiPluginResourceBundle.THNK_TIME_DEF, ToolsUiPluginResourceBundle.THNK_TIME_QRY});
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.ABS_PATH_TEXT);
        this.absolutePathText = widgetFactory.createStyledText(composite, 65540, this.stripAmps(ToolsUiPluginResourceBundle.ABS_PATH_TEXT));
        this.absolutePathText.setLayoutData((Object)this.getFullRowLayoutData());
        this.m_sslButton = widgetFactory.createButton(composite, ToolsUiPluginResourceBundle.SSL_LABEL, 32);
        this.m_sslButton.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.BODY_TEXT);
        this.bodyText = widgetFactory.createStyledText(composite, 66306, this.stripAmps(ToolsUiPluginResourceBundle.BODY_TEXT));
        GridData gridData = this.getFullRowLayoutData();
        gridData.heightHint = 4 * this.hostText.getLineHeight();
        this.bodyText.setLayoutData((Object)gridData);
        this.headerViewer = new HttpHeaderViewer();
        this.headerViewer.createControl(composite, widgetFactory);
        this.headerViewer.setReadOnly(this.isReadOnly());
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.requestHelper.dispose();
        this.methodCombo.removeModifyListener((ModifyListener)this);
        this.httpVersionText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.removeModifyListener((ModifyListener)this);
        this.hostText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.removeModifyListener((ModifyListener)this);
        this.absolutePathText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.removeModifyListener((ModifyListener)this);
        this.bodyText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.removeModifyListener((ModifyListener)this);
        this.portText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.portText.removeModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.removeModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.removeSelectionListener((SelectionListener)this);
        this.m_sslButton.removeSelectionListener((SelectionListener)this);
        this.httpVersionText.setText("");
        this.hostText.setText("");
        this.bodyText.setText("");
        this.portText.setText("");
        this.absolutePathText.setText("");
        this.methodCombo.setText("");
        this.m_thinkTimeCo.setText("");
        this.m_sslButton.setSelection(false);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof ITestCase) {
            this.methodCombo.setEnabled(!this.isReadOnly());
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(true);
            this.bodyText.setEditable(true);
            this.absolutePathText.setEditable(true);
            this.portText.setEditable(true);
            this.m_thinkTimeCo.setEnabled(!this.isReadOnly());
            this.requestHelper.setTestCase((ITestCase)object);
            this.httpVersionText.setText("1.1");
            this.absolutePathText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(3)));
            this.bodyText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(4)));
            this.hostText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(1)));
            this.portText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(2)));
            this.methodCombo.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(5)));
            String attr = this.requestHelper.getAttribute(7);
            if (attr == null || attr.charAt(0) == '-') {
                this.m_thinkTimeCo.setText("");
                this.m_thinkTimeCo.setSelection(new Point(1, 1));
                this.m_thinkTimeCo.select(1);
            } else {
                this.m_thinkTimeCo.setText(attr);
            }
            this.m_sslButton.setSelection("true".equalsIgnoreCase(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(12))));
            this.headerViewer.setEnabled(true);
            this.headerViewer.setInput(this.requestHelper);
        } else {
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(false);
            this.bodyText.setEditable(false);
            this.absolutePathText.setEditable(false);
            this.methodCombo.setEnabled(false);
            this.portText.setEditable(false);
            this.m_thinkTimeCo.setEnabled(false);
            this.m_sslButton.setEnabled(false);
            this.headerViewer.setEnabled(false);
        }
        this.methodCombo.addModifyListener((ModifyListener)this);
        this.httpVersionText.addVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.addModifyListener((ModifyListener)this);
        this.hostText.addVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.addModifyListener((ModifyListener)this);
        this.absolutePathText.addVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.addModifyListener((ModifyListener)this);
        this.bodyText.addVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.addModifyListener((ModifyListener)this);
        this.portText.addVerifyKeyListener((VerifyKeyListener)this);
        this.portText.addModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.addModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.addSelectionListener((SelectionListener)this);
        this.m_sslButton.addSelectionListener((SelectionListener)this);
    }

    public Object getInput() {
        return this.requestHelper.getTestCase();
    }

    public void verifyKey(VerifyEvent event) {
        super.verifyKey(event);
        if (event.widget == this.portText) {
            UIUtil.integerStyledTextVerifyKey((VerifyEvent)event);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.absolutePathText) {
            this.requestHelper.setAttribute(3, this.absolutePathText.getText());
        } else if (e.widget == this.bodyText) {
            this.requestHelper.setAttribute(4, this.bodyText.getText());
        } else if (e.widget == this.hostText) {
            this.requestHelper.setAttribute(1, this.hostText.getText());
        } else if (e.widget == this.portText) {
            this.requestHelper.setAttribute(2, this.portText.getText());
        } else if (e.widget == this.methodCombo) {
            this.requestHelper.setAttribute(5, this.methodCombo.getText());
        } else if (e.widget == this.m_thinkTimeCo) {
            try {
                Long.parseLong(this.m_thinkTimeCo.getText());
                this.requestHelper.setAttribute(7, this.m_thinkTimeCo.getText());
                this.m_thinkTimeCo.setForeground(null);
            }
            catch (Exception exception) {
                this.m_thinkTimeCo.setForeground(new Color((Device)this.m_thinkTimeCo.getShell().getDisplay(), 255, 0, 0));
            }
        }
        if (this.requestHelper.isDirty()) {
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    public void writeAccessChanged(IFile file, boolean isReadOnly) {
        this.methodCombo.setEnabled(!isReadOnly);
        this.headerViewer.setReadOnly(isReadOnly);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.m_thinkTimeCo) {
            String text = null;
            switch (this.m_thinkTimeCo.getSelectionIndex()) {
                case -1: {
                    text = this.m_thinkTimeCo.getText();
                    break;
                }
                case 0: {
                    text = HttpPreferenceUtil.getInstance().getDefaultThinkTime();
                    this.m_thinkTimeCo.setText(text);
                    break;
                }
                case 1: {
                    text = "-1";
                }
            }
            this.requestHelper.setAttribute(7, text);
            this.m_thinkTimeCo.setForeground(null);
        } else if (e.widget == this.m_sslButton) {
            if (this.m_sslButton.getSelection()) {
                this.requestHelper.setAttribute(12, "true");
            } else {
                this.requestHelper.setAttribute(12, "false");
            }
        }
        if (this.requestHelper.isDirty()) {
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    protected GridData getFullRowLayoutData() {
        GridData gd = GridDataUtil.createHorizontalFill();
        gd.horizontalSpan = 2;
        return gd;
    }

    private String stripAmps(String str) {
        return str.replaceAll("&", "");
    }
}

