/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class UserSection
extends EditorSection
implements ModifyListener {
    private StyledText usersText;
    private CFGInstance instance;

    public UserSection(EditorForm editorForm) {
        super(editorForm);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = factory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        factory.createLabel(composite, ToolsUiPluginResourceBundle.UserSection_USERS);
        this.usersText = widgetFactory.createStyledText(composite, 65540, this.stripAmps(ToolsUiPluginResourceBundle.UserSection_USERS));
        this.usersText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.usersText.setEditable(false);
        this.usersText.addVerifyKeyListener((VerifyKeyListener)this);
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof TPFTestSuite && ((TPFTestSuite)object).getInstances().size() > 0) {
            this.instance = (CFGInstance)((TPFTestSuite)object).getInstances().get(0);
            this.adjustTexts();
            this.usersText.setEditable(true);
        } else {
            this.instance = null;
            this.usersText.setText("");
            this.usersText.setEditable(false);
        }
    }

    protected void adjustTexts() {
        this.usersText.removeModifyListener((ModifyListener)this);
        this.usersText.setText(Integer.toString(Math.max(1, this.instance.getMaxCount())));
        this.usersText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.instance;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.instance == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.instance);
    }

    public void selectReveal(ISelection selection) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.usersText && this.instance != null) {
            try {
                int value = Integer.parseInt(this.usersText.getText());
                if (value > 0) {
                    this.instance.setMaxCount(value);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private String stripAmps(String str) {
        return str.replaceAll("&", "");
    }
}

