/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.actions;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.util.JavaUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenTestMethodAction
extends BaseSelectionListenerAction {
    private ITestCase testCase = null;

    public OpenTestMethodAction() {
        super(UiPluginResourceBundle.ACT_OPEN);
        this.setToolTipText(UiPluginResourceBundle.ACT_TEST_METHOD_OPEN_TIP);
    }

    public void run() {
        IMethod method = JavaUtil.findMethod((ITestCase)this.testCase);
        if (method != null) {
            try {
                IEditorPart part = JavaUI.openInEditor((IJavaElement)method);
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)method);
            }
            catch (Exception e) {
                ToolsUiPlugin.logError(e);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof ITestCase) {
            this.testCase = (ITestCase)firstElement;
            if (JavaUtil.findMethod((ITestCase)this.testCase) != null) {
                return true;
            }
        }
        this.testCase = null;
        return false;
    }
}

