/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;

public abstract class JavaParentElementProxyNode
extends JavaElementProxyNode {
    protected JavaElementProxyNode[] children;

    protected JavaParentElementProxyNode(IJavaElement element, Object parent, IJavaElementDelta delta) {
        super(element, parent);
        List c = delta != null ? this.computeChildren(delta) : this.computeChildren();
        this.setChildren(c);
    }

    protected JavaParentElementProxyNode(IJavaElement element, Object parent, boolean delayChildrenComputation) {
        super(element, parent);
        if (!delayChildrenComputation) {
            this.setChildren(this.computeChildren());
        }
    }

    protected abstract JavaElementProxyNode createChildProxy(IJavaElement var1, IJavaElementDelta var2);

    protected void disposeChildProxy(JavaElementProxyNode child) {
        child.dispose();
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    protected final void setChildren(List _children) {
        this.children = _children.toArray(new JavaElementProxyNode[_children.size()]);
    }

    protected List computeChildren() {
        if (this.getJavaElement() instanceof IParent) {
            try {
                IJavaElement[] elements = ((IParent)this.getJavaElement()).getChildren();
                ArrayList<JavaElementProxyNode> _children = new ArrayList<JavaElementProxyNode>(elements.length);
                int i = 0;
                while (i < elements.length) {
                    JavaElementProxyNode proxy = this.createChildProxy(elements[i], null);
                    if (proxy != null) {
                        _children.add(proxy);
                    }
                    ++i;
                }
                return _children;
            }
            catch (JavaModelException javaModelException) {
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected List computeChildren(IJavaElementDelta delta) {
        if (this.getJavaElement() instanceof IParent) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            ArrayList<JavaElementProxyNode> _children = new ArrayList<JavaElementProxyNode>(children.length);
            int i = 0;
            while (i < children.length) {
                JavaElementProxyNode proxy;
                int kind = children[i].getKind();
                if ((kind == 1 || kind == 4) && (proxy = this.createChildProxy(children[i].getElement(), children[i])) != null) {
                    _children.add(proxy);
                }
                ++i;
            }
            return _children;
        }
        return Collections.EMPTY_LIST;
    }

    public IProxyNode elementChanged(IJavaElementDelta delta) {
        JavaParentElementProxyNode lowestChanged = null;
        IJavaElementDelta[] deltas = delta.getAffectedChildren();
        int i = 0;
        while (i < deltas.length) {
            IJavaElementDelta childDelta = deltas[i];
            IJavaElement childElement = childDelta.getElement();
            JavaParentElementProxyNode lowestChild = null;
            switch (childDelta.getKind()) {
                case 1: {
                    JavaElementProxyNode proxy = this.createChildProxy(childElement, childDelta);
                    if (proxy == null) break;
                    this.addChildProxy(proxy);
                    lowestChild = this;
                    break;
                }
                case 2: {
                    JavaElementProxyNode proxy = this.getChildProxy(childElement);
                    if (proxy == null) break;
                    this.removeChildProxy(proxy);
                    lowestChild = this;
                    break;
                }
                case 4: {
                    JavaElementProxyNode proxy = this.getChildProxy(childElement);
                    if (proxy != null) {
                        lowestChild = this.childChanged(childDelta, proxy);
                        break;
                    }
                    proxy = this.createChildProxy(childElement, childDelta);
                    if (proxy == null) break;
                    this.addChildProxy(proxy);
                    lowestChild = this;
                }
            }
            if (lowestChild != null) {
                lowestChanged = lowestChanged == null ? lowestChild : this;
            }
            ++i;
        }
        return lowestChanged;
    }

    protected final JavaElementProxyNode getChildProxy(IJavaElement element) {
        int i = 0;
        while (i < this.children.length) {
            if (element.equals(this.children[i].getJavaElement())) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    protected final void replaceChildProxy(JavaElementProxyNode oldProxy, JavaElementProxyNode newProxy) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == oldProxy) {
                this.children[i] = newProxy;
                break;
            }
            ++i;
        }
    }

    protected final boolean addChildProxy(JavaElementProxyNode proxy) {
        if (proxy == null) {
            return false;
        }
        JavaElementProxyNode[] newChildren = new JavaElementProxyNode[this.children.length + 1];
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getCorrespondingResource().equals((Object)proxy.getCorrespondingResource())) {
                if (!this.children[i].equals(proxy)) {
                    this.children[i] = proxy;
                }
                return false;
            }
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[this.children.length] = proxy;
        this.children = newChildren;
        return true;
    }

    protected void removeChildProxy(JavaElementProxyNode proxy) {
        JavaElementProxyNode[] newChildren = new JavaElementProxyNode[this.children.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != proxy) {
                newChildren[j++] = this.children[i];
            }
            ++i;
        }
        this.children = newChildren;
        this.disposeChildProxy(proxy);
    }

    protected IProxyNode childChanged(IJavaElementDelta delta, JavaElementProxyNode child) {
        IProxyNode lowestChild = child.elementChanged(delta);
        if (lowestChild != null && child.getChildren().length == 0) {
            this.removeChildProxy(child);
            lowestChild = this;
        }
        return lowestChild;
    }

    public void dispose() {
        int i = 0;
        while (i < this.children.length) {
            this.disposeChildProxy(this.children[i]);
            ++i;
        }
    }
}

