/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaElementProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaParentElementProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitProvider;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitSourceFolderProxyNode;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class RegularJUnitProviderProxyNode
extends JavaParentElementProxyNode
implements ITypeProviderProxyNode {
    private String name;
    private String imageKey;
    private RegularJUnitProvider provider;

    public RegularJUnitProviderProxyNode(RegularJUnitProvider provider, IJavaProject project, String type, Object parent) {
        super((IJavaElement)project, parent, true);
        this.provider = provider;
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        this.name = TestNavigator.getTypeProviderManager().getNameFor(type);
        this.imageKey = TestNavigator.getTypeProviderManager().getImageKeyFor(type);
        if (this.name == null || this.name.trim().length() == 0) {
            this.name = descriptor != null ? descriptor.getName() : "[Invalid Descriptor]";
        }
        this.setChildren(this.computeChildren());
    }

    protected JavaElementProxyNode createChildProxy(IJavaElement childElement, IJavaElementDelta delta) {
        if (childElement instanceof IPackageFragmentRoot) {
            return RegularJUnitSourceFolderProxyNode.create((IPackageFragmentRoot)childElement, this, delta);
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return (IJavaProject)this.getJavaElement();
    }

    public Image getImage() {
        if (this.imageKey == null || this.imageKey.length() == 0) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return UiPlugin.getInstance().getImageRegistry().get(this.imageKey);
    }

    public String getText() {
        return this.name;
    }

    public IProxyNode elementChanged(IJavaElementDelta delta) {
        if (delta.getKind() == 4) {
            IJavaElementDelta[] deltas = delta.getAffectedChildren();
            RegularJUnitProviderProxyNode lowestChanged = null;
            int i = 0;
            while (i < deltas.length) {
                RegularJUnitProviderProxyNode lowestChild = null;
                IJavaElementDelta childDelta = deltas[i];
                IJavaElement elem = childDelta.getElement();
                if (elem.getElementType() == 3) {
                    if (childDelta.getKind() == 1 || childDelta.getKind() == 4 && (childDelta.getFlags() & 0x40) > 0) {
                        lowestChild = this.packageFragmentRootAdded((IPackageFragmentRoot)elem, childDelta);
                    } else if (childDelta.getKind() == 2 || childDelta.getKind() == 4 && (childDelta.getFlags() & 0x80) > 0) {
                        lowestChild = this.packageFragmentRootRemoved((IPackageFragmentRoot)elem);
                    } else if (childDelta.getKind() == 4 && (childDelta.getFlags() & 8) > 0) {
                        lowestChild = this.packageFragmentRootChanged((IPackageFragmentRoot)elem, childDelta);
                    }
                }
                if (lowestChild != null) {
                    lowestChanged = lowestChanged == null ? lowestChild : this;
                }
                ++i;
            }
            return lowestChanged;
        }
        return null;
    }

    private IProxyNode packageFragmentRootAdded(IPackageFragmentRoot root, IJavaElementDelta delta) {
        RegularJUnitSourceFolderProxyNode proxy = RegularJUnitSourceFolderProxyNode.create(root, this, delta);
        if (proxy != null) {
            this.addChildProxy(proxy);
            return this;
        }
        return null;
    }

    private IProxyNode packageFragmentRootRemoved(IPackageFragmentRoot root) {
        JavaElementProxyNode proxy = this.getChildProxy((IJavaElement)root);
        if (proxy != null) {
            this.removeChildProxy(proxy);
            return this;
        }
        return null;
    }

    private IProxyNode packageFragmentRootChanged(IPackageFragmentRoot root, IJavaElementDelta delta) {
        JavaElementProxyNode proxy = this.getChildProxy((IJavaElement)root);
        if (proxy != null) {
            IProxyNode lowestChanged = proxy.elementChanged(delta);
            if (proxy.getChildren().length == 0) {
                this.removeChildProxy(proxy);
                return this;
            }
            return lowestChanged;
        }
        proxy = RegularJUnitSourceFolderProxyNode.create(root, this, delta);
        if (proxy != null) {
            this.addChildProxy(proxy);
            return this;
        }
        return null;
    }

    protected RegularJUnitProvider getProvider() {
        return this.provider;
    }
}

