/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.preferences.JUnitTestSuiteFactoryOptions;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaElementProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitFileProxyFactory;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitTestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class RegularJUnitTestSuiteProxyNode
extends JavaElementProxyNode
implements ITestSuiteProxyNode,
IPersistableProxyNode {
    private IProxyNode[] children;

    RegularJUnitTestSuiteProxyNode(ICompilationUnit cu, Object parent) {
        super((IJavaElement)cu, parent);
        this.computeChildren();
    }

    RegularJUnitTestSuiteProxyNode(IMemento memento, ICompilationUnit cu, Object parent) {
        super((IJavaElement)cu, parent);
        IMemento[] children = memento.getChildren("testCase");
        this.children = new IProxyNode[children.length];
        int i = 0;
        while (i < children.length) {
            this.children[i] = new RegularJUnitTestCaseProxyNode(children[i], this);
            ++i;
        }
    }

    public boolean isDetached() {
        try {
            return JUnitModelUpdater.findTestSuiteFile((IFile)((IFile)this.getCompilationUnit().getResource())) == null;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    void computeChildren() {
        TPFTestSuite testSuite = this.getTestSuite();
        if (testSuite == null) {
            this.children = new IProxyNode[0];
            return;
        }
        ArrayList<RegularJUnitTestCaseProxyNode> _children = new ArrayList<RegularJUnitTestCaseProxyNode>(testSuite.getITestCases().size());
        for (ITestCase tc : testSuite.getITestCases()) {
            RegularJUnitTestCaseProxyNode proxy = new RegularJUnitTestCaseProxyNode(tc, this);
            _children.add(proxy);
        }
        this.children = _children.toArray(new IProxyNode[_children.size()]);
    }

    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getJavaElement();
    }

    public TPFTestSuite getTestSuite() {
        TPFTestSuite ts = JUnitModelUpdater.findTestSuite((IType)this.getCompilationUnit().findPrimaryType(), (ResourceSet)new ResourceSetImpl());
        if (ts == null) {
            try {
                ts = (TPFTestSuite)JUnitTestSuiteFacade.createTestSuite((ICompilationUnit)this.getCompilationUnit(), (String)this.getType());
            }
            catch (CoreException e) {
                ToolsUiPlugin.logError(e);
                ts = null;
            }
        }
        return ts;
    }

    public String getType() {
        return JUnitTestSuiteFactoryOptions.getDefaultJUnitTestSuiteType((ICompilationUnit)this.getCompilationUnit());
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
    }

    public IProxyNode elementChanged(IJavaElementDelta delta) {
        return null;
    }

    public String getFactoryID() {
        return RegularJUnitFileProxyFactory.ID;
    }

    public boolean saveState(IMemento memento) {
        int i = 0;
        while (i < this.children.length) {
            IMemento child = memento.createChild("testCase");
            ((RegularJUnitTestCaseProxyNode)this.children[i]).saveState(child);
            ++i;
        }
        return true;
    }

    public void dispose() {
    }

    public String getIdentifier() {
        return ".";
    }
}

