/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.JUnitScriptsSelectionPage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JUnitImportWizard
extends Wizard
implements IImportWizard {
    private JUnitScriptsSelectionPage page1;
    private IStructuredSelection selection;

    public JUnitImportWizard() {
        this.setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor("java_importjunit_wiz.gif"));
        this.setWindowTitle(ToolsUiPluginResourceBundle.JUnitImportWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.page1.saveDialogSettings();
        final List junitScripts = this.page1.getSelectedElements();
        final String type = this.page1.getSelectedType();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("", junitScripts.size());
                        for (Object object : junitScripts) {
                            if (object instanceof ICompilationUnit) {
                                ICompilationUnit cu = (ICompilationUnit)object;
                                JUnitImportWizard.this.generateTest(type, cu, new SubProgressMonitor(monitor, 1, 4));
                                String testSuiteName = cu.getElementName();
                                testSuiteName = testSuiteName.substring(0, testSuiteName.indexOf(46));
                                TestUIUtil.openEditor((IFile)((IFile)cu.getCorrespondingResource()).getParent().getFile((IPath)new Path(String.valueOf(testSuiteName) + "." + "testsuite")), (String)"org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart");
                                continue;
                            }
                            ToolsUiPlugin.logError("Returned element of JUnit scripts selection page should be a Compilation Unit");
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            ToolsUiPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected void generateTest(String type, ICompilationUnit cu, SubProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)ToolsUiPluginResourceBundle.GENERATING_LABEL, (Object[])new Object[]{cu.getElementName()}), 1);
        try {
            try {
                JUnitTestSuiteFacade.createTestSuite((ICompilationUnit)cu, (String)type, (boolean)false);
            }
            catch (CoreException e) {
                UiPlugin.logError((Throwable)e);
                monitor.worked(1);
                monitor.done();
            }
        }
        finally {
            monitor.worked(1);
            monitor.done();
        }
    }

    public void init(IWorkbench wb, IStructuredSelection sel) {
        this.selection = sel;
    }

    public void addPages() {
        this.page1 = this.createJUnitScriptsSelectionPage();
        this.page1.init(this.selection);
        this.addPage((IWizardPage)this.page1);
    }

    protected JUnitScriptsSelectionPage createJUnitScriptsSelectionPage() {
        return new JUnitScriptsSelectionPage();
    }

    public boolean canFinish() {
        return super.canFinish();
    }
}

