/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry;
import org.eclipse.hyades.test.tools.core.internal.java.preferences.JUnitTestSuiteFactoryOptions;
import org.eclipse.hyades.test.tools.core.java.IJUnitTestSuiteFactory;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.JUnitTestSuiteFactoriesProvider;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.JUnitWorkspaceContentProvider;
import org.eclipse.hyades.ui.util.TreeSelector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JUnitScriptsSelectionPage
extends WizardPage
implements ICheckStateListener {
    private static final String DS_TYPE = "type";
    private TreeSelector selector;
    private ComboViewer testFactoryList;
    private JUnitWorkspaceContentProvider contentProvider;
    protected List initialSelection;

    public JUnitScriptsSelectionPage() {
        super("JUnitScriptSelectionPage");
        this.setTitle(ToolsUiPluginResourceBundle.JUnitImportWizard_title);
        this.setDescription(ToolsUiPluginResourceBundle.JUnitScriptsSelectionPage_prompt);
        this.selector = null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        gl.verticalSpacing = 20;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(JavaMessages.JUNIT_IMPORT_WIZARD_DESTINATION_TYPE);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.testFactoryList = new ComboViewer(composite, 12);
        JUnitTestSuiteFactoriesProvider provider = new JUnitTestSuiteFactoriesProvider();
        this.testFactoryList.setLabelProvider((IBaseLabelProvider)provider);
        this.testFactoryList.setContentProvider((IContentProvider)provider);
        this.testFactoryList.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.testFactoryList.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.testFactoryList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IJUnitTestSuiteFactory factory = JUnitScriptsSelectionPage.this.getTestSuiteFactory();
                if (factory != null) {
                    List checkedElements;
                    JUnitScriptsSelectionPage.this.contentProvider.setJUnitTestSuiteFactory(factory);
                    if (JUnitScriptsSelectionPage.this.initialSelection != null) {
                        checkedElements = JUnitScriptsSelectionPage.this.initialSelection;
                        JUnitScriptsSelectionPage.this.initialSelection = null;
                    } else {
                        checkedElements = JUnitScriptsSelectionPage.this.selector.getSelectedElements();
                    }
                    IJavaModel javaWorkspace = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    JUnitScriptsSelectionPage.this.selector.setInput(null);
                    JUnitScriptsSelectionPage.this.selector.setInput((Object)javaWorkspace);
                    JUnitScriptsSelectionPage.this.selector.setInitialCheckedElements(checkedElements);
                    JUnitScriptsSelectionPage.this.setPageComplete(true);
                    JUnitScriptsSelectionPage.this.setErrorMessage(null);
                } else {
                    JUnitScriptsSelectionPage.this.selector.setInput(null);
                    JUnitScriptsSelectionPage.this.setPageComplete(false);
                    JUnitScriptsSelectionPage.this.setErrorMessage(JavaMessages.JUNIT_IMPORT_WIZARD_INTERNAL_ERROR);
                }
            }
        });
        IJavaModel javaWorkspace = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        this.contentProvider = new JUnitWorkspaceContentProvider();
        this.selector = new TreeSelector(composite, (Object)javaWorkspace, (ITreeContentProvider)this.contentProvider, (ILabelProvider)javaLabelProvider, 2048);
        this.contentProvider.setRunnableContext((IRunnableContext)this.getContainer());
        this.selector.getTreeViewer().addCheckStateListener((ICheckStateListener)this);
        this.selector.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.readDialogSettings();
        this.setPageComplete(!this.testFactoryList.getSelection().isEmpty());
        this.setControl((Control)composite);
    }

    protected void init(IStructuredSelection selection) {
        Iterator it = selection.iterator();
        this.initialSelection = new ArrayList(selection.size());
        while (it.hasNext()) {
            ICompilationUnit cu;
            Object o = it.next();
            if (!(o instanceof IAdaptable) || (cu = (ICompilationUnit)((IAdaptable)o).getAdapter(ICompilationUnit.class)) == null) continue;
            this.initialSelection.add(cu);
        }
    }

    private static IJavaProject findEnclosingProject(List compilationUnits) {
        IJavaProject project = null;
        for (ICompilationUnit cu : compilationUnits) {
            IJavaProject jp = cu.getJavaProject();
            if (project == null) {
                project = jp;
                continue;
            }
            if (project.equals(jp)) continue;
            return null;
        }
        return project;
    }

    protected IJUnitTestSuiteFactory getTestSuiteFactory() {
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr;
        ISelection selection = this.testFactoryList.getSelection();
        if (selection instanceof IStructuredSelection && (descr = (JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)((IStructuredSelection)selection).getFirstElement()) != null) {
            return descr.getFactory();
        }
        return null;
    }

    public String getSelectedType() {
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr;
        ISelection selection = this.testFactoryList.getSelection();
        if (selection instanceof IStructuredSelection && (descr = (JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)((IStructuredSelection)selection).getFirstElement()) != null) {
            return descr.getType();
        }
        return null;
    }

    public void setSelectedType(String type) {
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr = JUnitExtensionsRegistry.getInstance().getDescriptor(type);
        if (descr != null) {
            this.testFactoryList.setSelection((ISelection)new StructuredSelection((Object)descr));
        } else {
            this.testFactoryList.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public List getSelectedElements() {
        return this.selector.getSelectedElements(ICompilationUnit.class);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.setPageComplete(this.selector.getSelectedElements().size() != 0);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings pluginSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = pluginSettings.getSection(JUnitScriptsSelectionPage.class.getName());
        if (settings == null) {
            settings = pluginSettings.addNewSection(JUnitScriptsSelectionPage.class.getName());
        }
        return settings;
    }

    protected void readDialogSettings() {
        Object o;
        IJavaProject project = JUnitScriptsSelectionPage.findEnclosingProject(this.initialSelection);
        String type = null;
        if (project != null) {
            type = JUnitTestSuiteFactoryOptions.getDefaultJUnitTestSuiteType((IJavaProject)project);
        }
        if (type == null) {
            IDialogSettings settings = this.getDialogSettings();
            type = settings.get(DS_TYPE);
        }
        if (type != null) {
            this.setSelectedType(type);
        }
        if (this.getSelectedType() == null && (o = this.testFactoryList.getElementAt(0)) != null) {
            this.testFactoryList.setSelection((ISelection)new StructuredSelection(o));
        }
    }

    void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(DS_TYPE, this.getSelectedType());
    }
}

