/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.TestJavaImages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.SourcePage;
import org.eclipse.hyades.test.ui.wizard.JavaTestLocationPage;
import org.eclipse.hyades.test.ui.wizard.TestSuiteNewWizard2;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;

public class JUnitTestSuiteNewWizard
extends TestSuiteNewWizard2 {
    private SourcePage sourcePage;

    public JUnitTestSuiteNewWizard() {
        this.setWindowTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_SUITE_PG_TTL);
        this.setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor("java_newjunit_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("JUnitTestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("JUnitTestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.test.java.junit.testSuite";
    }

    public void addPages() {
        this.sourcePage.setTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_SUITE_PG_TTL);
        this.addPage((IWizardPage)this.sourcePage);
        super.addPages();
        this.getLocationPage().setTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_SUITE_PG_TTL);
        this.getLocationPage().setDescription(ToolsUiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_LOC_DSC);
        this.getAttributeWizardPage().setTitle(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_SUITE_PG_TTL);
        this.getAttributeWizardPage().setDescription(ToolsUiPluginResourceBundle.WIZ_NEW_JUNIT_TST_SUITE_PG_ATT_DSC);
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.adjustSeletion();
        this.initLocationPage(structuredSelection);
        this.initSourcePage(structuredSelection, this.getLocationPage());
        this.setAttributeWizardPage(new AttributeWizardPage("nameDescription"));
    }

    protected void initLocationPage(IStructuredSelection structuredSelection) {
        JavaTestLocationPage locationPage = new JavaTestLocationPage("location", structuredSelection);
        this.setLocationPage((LocationPage)locationPage);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            locationPage.setFileExtension(fileExtension);
            locationPage.setFileName("");
        }
    }

    protected void initSourcePage(IStructuredSelection structuredSelection, LocationPage locationPage) {
        SourcePage sourcePage_ = new SourcePage();
        this.setSourcePage(sourcePage_);
        sourcePage_.setWizard((IWizard)this);
        sourcePage_.init(structuredSelection, locationPage);
    }

    protected void adjustTestSuite(ITestSuite testSuite) {
        IResource resource;
        String qualifiedName = this.sourcePage.getQualifiedTypeName();
        testSuite.getImplementor().setResource(qualifiedName);
        try {
            resource = this.sourcePage.getPackageFragmentRoot().getCorrespondingResource();
        }
        catch (JavaModelException e) {
            resource = null;
            ToolsUiPlugin.logError(e);
        }
        if (resource != null) {
            testSuite.getImplementor().setLocation(resource.getFullPath().toString());
        }
        if (!this.sourcePage.isModelBehavior()) {
            JUnitModelUpdater.setImplementorBlock((IImplementor)testSuite.getImplementor(), null);
        }
        try {
            this.generateCode(testSuite, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            ToolsUiPlugin.logError(e);
        }
    }

    protected SourcePage getSourcePage() {
        return this.sourcePage;
    }

    protected JUnitGenerator createGenerator(ITestSuite testSuite) {
        return new JUnitGenerator(testSuite, (IProjectDependencyUpdater)new AutomaticDependencyUpdater(), this.getSourcePage().getSuperClass());
    }

    private void generateCode(ITestSuite testSuite, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 4);
        try {
            JUnitGenerator generator = this.createGenerator(testSuite);
            RefactoringStatus status = generator.checkAllConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (status.hasFatalError()) {
                throw new IllegalStateException("Refactor conditions not met");
            }
            Change change = generator.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            change.perform((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    protected void setSourcePage(SourcePage page) {
        this.sourcePage = page;
    }
}

