/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.extensions;

import java.util.MissingResourceException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ExtensionsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.test.ui.extensions";
    private static ExtensionsPlugin plugin;

    public ExtensionsPlugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.savePluginPreferences();
    }

    public static ExtensionsPlugin getDefault() {
        return plugin;
    }

    public static String getString(String key) {
        try {
            return Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID)).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(4, PLUGIN_ID, 0, throwable.toString(), throwable);
        plugin.getLog().log((IStatus)status);
    }

    public static void logError(String text) {
        ExtensionsPlugin.logError(new Throwable(text));
    }

    public static void logInfo(String text) {
        Status status = new Status(1, PLUGIN_ID, 0, text, new Throwable(text));
        plugin.getLog().log((IStatus)status);
    }

    public static String getPreference(String key) {
        return ExtensionsPlugin.getDefault().getPreferenceStore().getString(key);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("bugzillaSubmitURL", "https://bugs.eclipse.org/bugs/enter_bug.cgi");
        store.setDefault("bugzillaSearchURL", "https://bugs.eclipse.org/bugs/query.cgi");
        store.setDefault("bugzillaOpenURL", "https://bugs.eclipse.org/bugs/show_bug.cgi?id=");
    }
}

