/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.recorder.IRecorderListenerFullFeedback;
import org.eclipse.hyades.internal.execution.recorder.ui.CopyAction;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.NewGenericRecordingAction;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.StopRecordingAction;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.ITestgenListener;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class RecorderControlView
extends ViewPart
implements ITestgenListener,
IRecorderListenerFullFeedback {
    private Text kBytesReceived;
    private Text recStatus;
    private List statusList;
    public static RecorderControlView instance = null;
    private Clipboard clipboard = null;
    private CopyAction copyAction = null;
    public static final String ID = "org.eclipse.hyades.execution.recorder.ui.views.RecorderControlView";
    public static final String STARTGROUP = "start";

    public void createPartControl(final Composite grandParent) {
        FontMetrics fm = new GC((Drawable)grandParent).getFontMetrics();
        int heightHint = fm.getHeight() + fm.getAscent() + fm.getDescent();
        int widthHint = fm.getAverageCharWidth() * 50;
        Composite parent = new Composite(grandParent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".recv0001");
        RecorderUIUtility.assignGridLayout(parent, 1, false);
        Canvas bytesReceivedCanvas = new Canvas(parent, 0);
        bytesReceivedCanvas.setLayoutData((Object)new GridData(768));
        RowLayout layout = new RowLayout(256);
        layout.pack = true;
        layout.wrap = true;
        layout.spacing = 0;
        bytesReceivedCanvas.setLayout((Layout)layout);
        Canvas recvCanvas = new Canvas((Composite)bytesReceivedCanvas, 0);
        recvCanvas.setLayout((Layout)new GridLayout(2, false));
        recvCanvas.setLayoutData((Object)new RowData(widthHint, heightHint));
        Label bytesReceivedLabel = RecorderUIUtility.createLabel((Composite)recvCanvas, UiPluginResourceBundle.RecorderControlView_KBYTES_RECEIVED_CONTROL_LABEL, null);
        bytesReceivedLabel.setLayoutData((Object)new GridData(128));
        this.kBytesReceived = new Text((Composite)recvCanvas, 2056);
        this.kBytesReceived.setLayoutData((Object)new GridData(768));
        Canvas statusCanvas = new Canvas((Composite)bytesReceivedCanvas, 0);
        statusCanvas.setLayout((Layout)new GridLayout(2, false));
        statusCanvas.setLayoutData((Object)new RowData(widthHint, heightHint));
        Label statusLabel = RecorderUIUtility.createLabel((Composite)statusCanvas, UiPluginResourceBundle.RecorderControlView_STATUS_LABEL, null);
        statusLabel.setLayoutData((Object)new GridData(128));
        this.recStatus = new Text((Composite)statusCanvas, 2056);
        this.recStatus.setText(TestCorePluginResourceBundle.RecorderClient_STATUS_STOPPED);
        this.recStatus.setLayoutData((Object)new GridData(768));
        this.statusList = new List(parent, 2826);
        this.statusList.setLayoutData((Object)new GridData(1808));
        this.clipboard = new Clipboard(grandParent.getDisplay());
        this.copyAction = new CopyAction(this.clipboard);
        this.copyAction.setEnabled(false);
        this.statusList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RecorderControlView.this.setSelectedLines();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.statusList.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Menu menu = new Menu((Decorations)grandParent.getShell(), 8);
                MenuItem copyItem = new MenuItem(menu, 8);
                copyItem.setText(UiPluginResourceBundle.command_Copy);
                copyItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        RecorderControlView.this.setSelectedLines();
                        RecorderControlView.this.copyAction.run();
                    }
                });
                menu.setLocation(event.x, event.y);
                MenuItem selectAllItem = new MenuItem(menu, 8);
                selectAllItem.setText(UiPluginResourceBundle.command_SelectAll);
                selectAllItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        RecorderControlView.this.statusList.selectAll();
                        RecorderControlView.this.setSelectedLines();
                        RecorderControlView.this.copyAction.setEnabled(true);
                    }
                });
                if (RecorderControlView.this.statusList.getSelection().length == 0) {
                    RecorderControlView.this.copyAction.setEnabled(false);
                    copyItem.setEnabled(false);
                }
                menu.setVisible(true);
            }
        });
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        ToolBarManager toolbarManager = (ToolBarManager)this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IContributionItem)new GroupMarker(STARTGROUP));
        toolbarManager.add((IAction)new NewGenericRecordingAction());
        toolbarManager.add((IAction)new StopRecordingAction());
    }

    private void setSelectedLines() {
        if (this.statusList != null && this.copyAction != null) {
            String[] statusLines = this.statusList.getSelection();
            this.copyAction.setSelectedStatusItems(statusLines);
            this.copyAction.setEnabled(statusLines.length > 0);
        }
    }

    public void reset() {
        this.statusList.removeAll();
        this.kBytesReceived.setText("0");
    }

    public static RecorderControlView getInstance() {
        if (instance == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        instance = (RecorderControlView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(RecorderControlView.ID);
                    }
                    catch (Exception e) {
                        UiPlugin.logError(e);
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)UiPluginResourceBundle.RecorderControlView_UNABLE_TO_CREATE_RECORDER_CONTROL_VIEW_ERROR_MSG, (IStatus)new Status(2, "org.eclipse.hyades.test.ui", 566, e.toString(), null));
                    }
                }
            });
        }
        return instance;
    }

    public void addMessage(String message) {
        this.addMessage(message, false);
    }

    public void addMessage(final String message, boolean bSync) {
        Runnable a = new Runnable(){

            public void run() {
                if (!RecorderControlView.this.statusList.isDisposed()) {
                    IWorkbenchPartSite workbenchPartSite;
                    if (instance != null && (workbenchPartSite = instance.getSite()) != null) {
                        workbenchPartSite.getPage().activate((IWorkbenchPart)instance);
                    }
                    RecorderControlView.this.statusList.add(message);
                    RecorderControlView.this.statusList.setSelection(RecorderControlView.this.statusList.getItems().length - 1);
                }
            }
        };
        if (bSync) {
            Display.getDefault().syncExec(a);
        } else {
            Display.getDefault().asyncExec(a);
        }
    }

    public void setKBytesReceived(final int receivedKBytes) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!RecorderControlView.this.kBytesReceived.isDisposed()) {
                    RecorderControlView.this.kBytesReceived.setText(String.valueOf(receivedKBytes));
                }
            }
        });
    }

    public void setStatus(String status) {
        this.recStatus.setText(status);
    }

    public void setFocus() {
        if (this.statusList != null) {
            this.statusList.setFocus();
        }
        this.setSelectedLines();
    }

    public void dispose() {
        super.dispose();
        instance = null;
    }

    public List getStatusList() {
        return this.statusList;
    }

    public void notifyEnd(boolean bSuccess) {
        if (bSuccess) {
            this.addMessage(TestCorePluginResourceBundle.RecorderClient_TEST_GENERATION_COMPLETE);
        } else {
            this.addMessage(TestCorePluginResourceBundle.RecorderClient_TEST_GENERATION_ERRORS);
        }
    }

    public void updateRecorderActive(boolean active) {
    }

    public void controlMessage(String key, String msg) {
        if (key.equals("org.eclipse.hyades.test.core.kb_received")) {
            try {
                this.setKBytesReceived(Integer.parseInt(msg));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (key.equals("org.eclipse.hyades.test.core.controlviewmessage")) {
            this.addMessage(msg);
        }
    }

    public void updateStatus(final String str) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!RecorderControlView.this.recStatus.isDisposed()) {
                    RecorderControlView.this.recStatus.setText(str);
                }
            }
        });
    }
}

