/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class RecorderWizard
extends HyadesNewWizard
implements INewWizard,
IRunnableWithProgress,
IRecorderWizard {
    protected IProgressMonitor monitor = null;

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.monitor = monitor;
        this.run();
    }

    public abstract void run();

    public void saveSettings() {
        IWizardPage[] wizPages = this.getPages();
        int i = 0;
        while (i < wizPages.length) {
            ITestGenWizardPage wizPage = (ITestGenWizardPage)wizPages[i];
            wizPage.saveSettings();
            ++i;
        }
    }

    public boolean performFinish() {
        this.saveSettings();
        if (!this.verifyRecorderData()) {
            return false;
        }
        RecorderControlView.getInstance().reset();
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean createObject(IFile arg0) throws Exception {
        return true;
    }

    protected boolean verifyRecorderData() {
        return true;
    }

    public void registerListeners() {
    }

    public void runTestGen(Recorder recorder) {
        String scriptGenID = recorder.getScriptgenID();
        if (scriptGenID == null || scriptGenID.equals("-1")) {
            return;
        }
        String scriptGenName = TestGeneratorFactory.getInstance().getGeneratorName(scriptGenID);
        String recordingPath = recorder.getRecordingPath();
        RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", String.valueOf(TestCorePluginResourceBundle.RecorderClient_Test_generation_started_with_generator___4) + " " + scriptGenName);
        IFile traceFile = recordingPath.endsWith(".rec") ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(recordingPath) + "model")) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(recordingPath));
        if (traceFile.exists()) {
            RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", String.valueOf(TestCorePluginResourceBundle.RecorderClient_TEST_TO_BE_GENERATED) + " " + recorder.getTestPath());
            TestgenUIWrapper wrapper = new TestgenUIWrapper(scriptGenID, traceFile, recorder.getTestPath());
            wrapper.addListener(RecorderControlView.getInstance());
            wrapper.launchGenerator();
        } else {
            RecorderFactory.getInstance().controlMessage(recorder, "org.eclipse.hyades.test.core.controlviewmessage", TestCorePluginResourceBundle.RecorderClient_UNABLE_TO_GENERATE_NO_TRACE_FILE);
        }
    }
}

