/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class TestgenUIUtility {
    public static void layoutCompositelInFormLayout(Control composite, int pixelsToTop, int verticalSpanPixels, int leftPercentWidth, int rightPercentWidth, int leftBorder, int bottomBorder, int topBorder, int rightBorder) throws TestGenUIException {
        if (!FormLayout.class.isInstance(composite.getParent().getLayout())) {
            Object[] layoutName = new String[]{"org.eclipse.swt.layout.FormLayout"};
            String errorMessage = NLS.bind((String)UiPluginResourceBundle.TestgenUIUtility_INCORRECT_LAYOUT_MESSAGE_FORMAT_STRING, (Object[])layoutName);
            throw new TestGenUIException(errorMessage);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(leftPercentWidth, leftBorder);
        formData.right = new FormAttachment(rightPercentWidth, -rightBorder);
        formData.top = new FormAttachment(0, pixelsToTop + topBorder);
        formData.bottom = new FormAttachment(0, pixelsToTop + verticalSpanPixels - bottomBorder);
        composite.setLayoutData((Object)formData);
    }

    public static void layoutControlInFormLayout(Control control, int topBorder, int leftBorder, int bottomBorder, int rightBorder) throws TestGenUIException {
        if (!FormLayout.class.isInstance(control.getParent().getLayout())) {
            Object[] layoutName = new String[]{"org.eclipse.swt.layout.GridLayout"};
            String errorMessage = NLS.bind((String)UiPluginResourceBundle.TestgenUIUtility_INCORRECT_LAYOUT_MESSAGE_FORMAT_STRING, (Object[])layoutName);
            throw new TestGenUIException(errorMessage);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, leftBorder);
        formData.right = new FormAttachment(100, -rightBorder);
        formData.top = new FormAttachment(0, topBorder);
        formData.bottom = new FormAttachment(100, -bottomBorder);
        control.setLayoutData((Object)formData);
    }

    public static void layoutControlInGrid(Control control, int columnSpan, int gridDataOptions) throws TestGenUIException {
        GridData gridData = new GridData(gridDataOptions);
        gridData.horizontalSpan = columnSpan;
        control.setLayoutData((Object)gridData);
    }

    public static void assignFormLayout(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
    }

    public static void assignGridLayout(Composite compsite, int numberColumns) {
        GridLayout gridLayout = new GridLayout(numberColumns, false);
        compsite.setLayout((Layout)gridLayout);
    }

    public static Label createLabel(Composite composite, String labelText, Font font) {
        Label label = new Label(composite, 64);
        label.setText(labelText);
        if (font != null) {
            label.setFont(font);
        }
        return label;
    }

    public static Text createEditControl(Composite composite, String textValue, Font font) {
        Text text = new Text(composite, 2048);
        text.setText(textValue);
        if (font != null) {
            text.setFont(font);
        }
        return text;
    }

    public static TreeViewer createTreeViewer(Composite composite, Font font) {
        TreeViewer tree = new TreeViewer(composite);
        tree.setUseHashlookup(true);
        tree.getControl().setFont(font);
        return tree;
    }

    public static Group createGroup(Composite controlArea, String text) {
        Group recorderHostGroup = new Group(controlArea, 16);
        TestgenUIUtility.assignFormLayout(controlArea);
        recorderHostGroup.setText(text);
        return recorderHostGroup;
    }

    public static Button createButton(Composite parent, String text, int swtOptions) {
        Button button = new Button(parent, swtOptions);
        button.setText(text);
        return button;
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static class TestGenUIException
    extends Exception {
        static final long serialVersionUID = -4778905436899464624L;

        public TestGenUIException() {
        }

        public TestGenUIException(String message) {
            super(message);
        }
    }
}

