/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.internal.testgen.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.core.testgen.ITestgenListener;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.ui.testgen.util.TestgenUtil;

public class TestgenUIWrapper {
    String generatorID = null;
    String generatorName = null;
    IFile recFile = null;
    String outFileName = null;
    boolean bSuccess = false;
    ArrayList listeners;

    public TestgenUIWrapper(String generatorID, IFile selectedRecModelFile, String outputFileName) {
        this.generatorID = generatorID;
        this.generatorName = TestGeneratorFactory.getInstance().getGeneratorName(generatorID);
        this.recFile = selectedRecModelFile;
        this.outFileName = outputFileName;
    }

    public TestgenUIWrapper(String generatorID, String recFilePath, String outputFileName) {
        this.recFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(recFilePath));
        this.generatorID = generatorID;
        this.generatorName = TestGeneratorFactory.getInstance().getGeneratorName(generatorID);
        this.outFileName = outputFileName;
    }

    public synchronized void addListener(ITestgenListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ITestgenListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void launchGenerator() {
        ITestgenListener[] aListeners = null;
        if (this.listeners != null) {
            aListeners = new ITestgenListener[this.listeners.size()];
            int i = 0;
            while (i < this.listeners.size()) {
                aListeners[i] = (ITestgenListener)this.listeners.get(i);
                ++i;
            }
        }
        TestgenUtil.launchGenerator(this.recFile, this.outFileName, this.generatorID, aListeners, this.generatorName);
    }
}

