/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.ui.PlatformUI;

public class TestUIExtension {
    public static final String GENERIC_TEST_SUITE_TYPE = "org.eclipse.hyades.testSuite.generic";
    public static final String GENERIC_TEST_SUITE_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart";
    public static final String GENERIC_TEST_CASE_TYPE = "org.eclipse.hyades.testCase.generic";
    public static final String DEPLOYMENT_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DeploymentEditorPart";
    public static final String EXECUTION_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.forms.editor.TestLogViewer";
    public static final String GENERIC_DATAPOOL_TYPE = "org.eclipse.hyades.datapool.generic";
    public static final String DATAPOOL_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DatapoolEditorPart";
    public static final String GENERIC_ARTIFACT_TYPE = "org.eclipse.hyades.artifact.generic";
    public static final String ARTIFACT_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.ArtifactEditorPart";
    public static final String GENERIC_LOCATION_TYPE = "org.eclipse.hyades.location.generic";
    public static final String LOCATION_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.LocationEditorPart";
    private static IAssociationMappingRegistry testSuiteMappingRegistry;
    private static IAssociationMappingRegistry testCaseMappingRegistry;
    private static IAssociationMappingRegistry deploymentMappingRegistry;
    private static IAssociationMappingRegistry executionMappingRegistry;
    private static IAssociationMappingRegistry datapoolMappingRegistry;
    private static IAssociationMappingRegistry locationMappingRegistry;
    private static IAssociationMappingRegistry artifactMappingRegistry;

    static void dispose() {
        if (testSuiteMappingRegistry != null) {
            testSuiteMappingRegistry.dispose();
        }
        if (testCaseMappingRegistry != null) {
            testCaseMappingRegistry.dispose();
        }
        if (deploymentMappingRegistry != null) {
            deploymentMappingRegistry.dispose();
        }
        if (executionMappingRegistry != null) {
            executionMappingRegistry.dispose();
        }
        if (datapoolMappingRegistry != null) {
            datapoolMappingRegistry.dispose();
        }
        if (locationMappingRegistry != null) {
            locationMappingRegistry.dispose();
        }
        if (artifactMappingRegistry != null) {
            artifactMappingRegistry.dispose();
        }
    }

    public static IAssociationMappingRegistry getTestSuiteMappingRegistry() {
        if (testSuiteMappingRegistry == null) {
            testSuiteMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            testSuiteMappingRegistry.initialize("testsuite", (IAssociationDescriptorFilter)new TestSuiteDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            testSuiteMappingRegistry.retrieveAssociationMapping("typeDescriptions", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("typeValidators", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("generateWizards", UiPlugin.getID());
        }
        return testSuiteMappingRegistry;
    }

    public static IAssociationMappingRegistry getTestCaseMappingRegistry() {
        if (testCaseMappingRegistry == null) {
            testCaseMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            testCaseMappingRegistry.initialize("testcase", (IAssociationDescriptorFilter)new TestCaseDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            testCaseMappingRegistry.retrieveAssociationMapping("newTestCaseWizards", UiPlugin.getID());
            testCaseMappingRegistry.retrieveAssociationMapping("typeDescriptions", HyadesUIPlugin.getID());
            testCaseMappingRegistry.retrieveAssociationMapping("generateWizards", UiPlugin.getID());
        }
        return testCaseMappingRegistry;
    }

    public static IAssociationMappingRegistry getDeploymentMappingRegistry() {
        if (deploymentMappingRegistry == null) {
            deploymentMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            deploymentMappingRegistry.initialize("deploy", (IAssociationDescriptorFilter)new DeploymentDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            deploymentMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return deploymentMappingRegistry;
    }

    public static IAssociationMappingRegistry getExecutionMappingRegistry() {
        if (executionMappingRegistry == null) {
            executionMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            executionMappingRegistry.initialize("execution", (IAssociationDescriptorFilter)new ExecutionDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            executionMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return executionMappingRegistry;
    }

    public static IAssociationMappingRegistry getDatapoolMappingRegistry() {
        if (datapoolMappingRegistry == null) {
            datapoolMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            datapoolMappingRegistry.initialize("datapool", (IAssociationDescriptorFilter)new DatapoolDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            datapoolMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return datapoolMappingRegistry;
    }

    public static IAssociationMappingRegistry getArtifactMappingRegistry() {
        if (artifactMappingRegistry == null) {
            artifactMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            artifactMappingRegistry.initialize("artifact", (IAssociationDescriptorFilter)new ArtifactDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            artifactMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return artifactMappingRegistry;
    }

    public static IAssociationMappingRegistry getLocationMappingRegistry() {
        if (locationMappingRegistry == null) {
            locationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            locationMappingRegistry.initialize("location", (IAssociationDescriptorFilter)new LocationDescriptorFilter(), UiPlugin.getInstance().getPreferenceStore());
            locationMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return locationMappingRegistry;
    }

    public static synchronized void registerTestSuiteType(String type) {
        if (type == null) {
            return;
        }
        IAssociationMapping mapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions");
        if (mapping.getAssociationDescriptors(type).length == 0) {
            IAssociationDescriptor descriptor = mapping.createAssociationDescriptor();
            descriptor.setExtension("testsuite");
            descriptor.addType(type);
        }
    }

    public static synchronized void registerTestCaseType(String type) {
        if (type == null) {
            return;
        }
        IAssociationMapping mapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions");
        if (mapping.getAssociationDescriptors(type).length == 0) {
            IAssociationDescriptor descriptor = mapping.createAssociationDescriptor();
            descriptor.setExtension("testcase");
            descriptor.addType(type);
        }
    }

    private static class ArtifactDescriptorFilter
    implements IAssociationDescriptorFilter {
        private ArtifactDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"artifact".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("editorExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class DatapoolDescriptorFilter
    implements IAssociationDescriptorFilter {
        private DatapoolDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"datapool".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("editorExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class DeploymentDescriptorFilter
    implements IAssociationDescriptorFilter {
        private DeploymentDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"deploy".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("editorExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class ExecutionDescriptorFilter
    implements IAssociationDescriptorFilter {
        private ExecutionDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"execution".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("editorExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class LocationDescriptorFilter
    implements IAssociationDescriptorFilter {
        private LocationDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"location".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("editorExtensions".equals(extensionPoint) && associationDescriptor.getImageDescriptor() == null) {
                associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class TestCaseDescriptorFilter
    implements IAssociationDescriptorFilter {
        private TestCaseDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            boolean isTestCaseWizard = "newTestCaseWizards".equals(associationMapping.getExtensionPoint());
            boolean isTestCaseExtension = "testcase".equals(associationDescriptor.getExtension());
            return isTestCaseExtension || isTestCaseWizard;
        }
    }

    private static class TestSuiteDescriptorFilter
    implements IAssociationDescriptorFilter {
        private TestSuiteDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor) {
            if (!"testsuite".equals(associationDescriptor.getExtension())) {
                return false;
            }
            String extensionPoint = associationMapping.getExtensionPoint();
            if ("typeDescriptions".equals(extensionPoint)) {
                if (associationDescriptor.applyToAllTypes()) {
                    return false;
                }
                if (associationDescriptor.types().length != 1) {
                    return false;
                }
            } else if ("editorExtensions".equals(extensionPoint)) {
                if (associationDescriptor.getImageDescriptor() == null) {
                    associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
                }
            } else if ("typeValidators".equals(extensionPoint) ? associationDescriptor.applyToAllTypes() : "generateWizards".equals(extensionPoint) && associationDescriptor.applyToAllTypes()) {
                return false;
            }
            return true;
        }
    }
}

