/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.adapter.IResourceSetFileAdaptable;
import org.eclipse.hyades.test.ui.adapter.TestAdapterFactory;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCacheMemoryEventHandler;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventHandler;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.test.ui";
    private static UiPlugin instance;
    private ResourceBundle resourceBundle;
    private FormColors formColors;
    private Map editorMappings;
    private static final String HYADES_EDITOR_EXTENSION_ID = "hyadesEditors";
    private static final String HYADES_EDITOR_ID_PREFIX = "org.eclipse.hyades.";
    public static final String EP_TEST_CASE_WIZARD = "newTestCaseWizards";
    public static final String EP_GENERATE_WIZARDS = "generateWizards";
    public static final String TEST_GENERATOR = "default_test_generator";

    public UiPlugin() {
        instance = this;
        this.setEditorMappings();
    }

    public static UiPlugin getInstance() {
        return instance;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public ResourceBundle[] getResourceBundles() {
        if (this.getResourceBundle() != null) {
            return new ResourceBundle[]{this.getResourceBundle()};
        }
        return null;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = UiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key) {
        return UiPlugin.getResourceString(key);
    }

    public static String getString(String key, String argument) {
        return UiPlugin.getString(key, new String[]{argument});
    }

    public static String getString(String key, String[] arguments) {
        return NLS.bind((String)UiPlugin.getString(key), (Object[])arguments);
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public void start(BundleContext context) throws Exception {
        TestCorePlugin.getDefault();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, IResourceSetFileAdaptable.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, IResource.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, LogicalFolder.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, CMNNamedElement.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, TPFExecutionEvent.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, ITypedElementProxyNode.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, Resource.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE, IExtendedProxyNode.class);
        Hashtable<String, String> memoryEventHandlerProperties = new Hashtable<String, String>();
        memoryEventHandlerProperties.put("event.topics", "org/eclipse/equinox/events/MemoryEvent/CRITICAL");
        context.registerService(EventHandler.class.getName(), (Object)new FileProxyNodeCacheMemoryEventHandler(), memoryEventHandlerProperties);
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        TestUIExtension.dispose();
        TestUI.dispose();
        this.savePluginPreferences();
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)TestAdapterFactory.INSTANCE);
        TestAdapterFactory.INSTANCE.dispose();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("testsuite");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("deploy");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("datapool");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("location");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("artifact");
        instance = null;
        super.stop(context);
    }

    public static void logError(Throwable throwable) {
        UiPlugin.logError(throwable.toString(), throwable);
    }

    public static void logError(String text) {
        UiPlugin.logError(new Throwable(text));
    }

    public static void logError(String text, Throwable throwable) {
        Status status = new Status(4, UiPlugin.getID(), 0, text, throwable);
        instance.getLog().log((IStatus)status);
    }

    public static void logInfo(String text) {
        Status status = new Status(1, UiPlugin.getID(), 0, text, new Throwable(text));
        instance.getLog().log((IStatus)status);
    }

    public static void logWarning(String text) {
        Status status = new Status(2, UiPlugin.getID(), 0, text, new Throwable(text));
        instance.getLog().log((IStatus)status);
    }

    public static void logWarning(String text, Throwable throwable) {
        Status status = new Status(2, UiPlugin.getID(), 0, text, throwable);
        instance.getLog().log((IStatus)status);
    }

    public static String getPreference(String key) {
        return UiPlugin.getDefault().getPreferenceStore().getString(key);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("openEditor", "prompt");
        store.setDefault("execFilter", 3);
        store.setDefault("HideLaunchValidationWarning", false);
        store.setDefault("saveInterval", 5000);
        store.setDefault("default_port", "10002");
        store.setDefault("default_host_name", "localhost");
        TestCorePlugin.getDefault().getPluginPreferences().setValue("default_host_name", store.getString("default_host_name"));
        TestCorePlugin.getDefault().getPluginPreferences().setValue("default_port", store.getString("default_port"));
        TestCorePlugin.getDefault().getPluginPreferences().setValue("saveInterval", store.getInt("saveInterval"));
    }

    public String getDefaultGeneratorID() {
        return null;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static UiPlugin getDefault() {
        return instance;
    }

    public Map getEditorMappings() {
        return this.editorMappings;
    }

    protected void setEditorMappings() {
        this.editorMappings = new HashMap();
        IExtension editorExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.hyades.test.ui.hyadesEditors");
        IConfigurationElement[] configurationElements = editorExtension.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            this.editorMappings.put(configurationElements[i].getAttribute("extensions"), HYADES_EDITOR_ID_PREFIX);
            ++i;
        }
    }

    public String getRAServerPort() {
        return TestCorePlugin.getDefault().getPluginPreferences().getString("default_port");
    }

    public String getRAServerHost() {
        return TestCorePlugin.getDefault().getPluginPreferences().getString("default_host_name");
    }

    public static void reportExceptionToUser(final Exception e1, final String consequenceDescription, final String cause, final String dlgTitle) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Status errorStatus = new Status(4, UiPlugin.PLUGIN_ID, 4, cause, (Throwable)e1);
                new ErrorDialog(Display.getDefault().getActiveShell(), dlgTitle, consequenceDescription, (IStatus)errorStatus, 4).open();
            }
        });
    }

    public Image getImage(String imageKey) {
        return this.getImageRegistry().get(imageKey);
    }

    public void putImage(Bundle bundle, String imageKey) {
        ImageDescriptor imageDescriptor;
        if (this.getImageRegistry().get(imageKey) == null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin((Bundle)bundle, (String)imageKey)) != null) {
            UiPlugin.getInstance().getImageRegistry().put(imageKey, imageDescriptor);
        }
    }
}

