/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.adapter.CMNNamedElementPropertySource;
import org.eclipse.hyades.test.ui.adapter.IResourceSetFileAdaptable;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.PropertySourceExtensionManager;
import org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.ui.adapter.IHyadesWorkbenchAdapter;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

public class TestAdapterFactory
implements IAdapterFactory,
IDisposable {
    public static final TestAdapterFactory INSTANCE = new TestAdapterFactory();
    private TestWorkbenchAdapter testWorkbenchAdapter = new TestWorkbenchAdapter();

    protected TestAdapterFactory() {
    }

    public void dispose() {
        this.testWorkbenchAdapter = null;
    }

    public IHyadesWorkbenchAdapter getHyadesWorkbenchAdapter() {
        return this.testWorkbenchAdapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{CMNNamedElement.class, IWorkbenchAdapter.class, TestWorkbenchAdapter.class, IPropertySource.class, IPersistableElement.class, INamedElement.class, IResource.class, IFile.class, Resource.class, IProxyNodeRenamer.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == CMNNamedElement.class) {
            return this.getCMNNamedElement(adaptableObject);
        }
        if (adapterType == TestWorkbenchAdapter.class || adapterType == IWorkbenchAdapter.class) {
            return this.getTestWorkbenchAdapter(adaptableObject);
        }
        if (adapterType == IPropertySource.class) {
            return this.getPropertySource(adaptableObject);
        }
        if (adapterType == INamedElement.class) {
            return this.getNamedElement(adaptableObject);
        }
        if (adapterType == IPersistableElement.class) {
            return this.getPersistableElement(adaptableObject);
        }
        if (adapterType == IFile.class || adapterType == IResource.class) {
            IResource res;
            block12: {
                try {
                    res = this.getResource(adaptableObject);
                    if (res != null) break block12;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (adapterType.isAssignableFrom(res.getClass())) {
                return res;
            }
            return null;
        }
        if (adapterType == IProxyNodeRenamer.class) {
            this.getProxyNodeRenamer(adaptableObject);
        }
        if (adapterType == Resource.class) {
            this.getEMFResource(adaptableObject);
        }
        return null;
    }

    protected CMNNamedElement getCMNNamedElement(Object adaptableObject) {
        EObject[] eObjects;
        ResourceSet resourceSet = null;
        IFile file = null;
        if (adaptableObject instanceof IResourceSetFileAdaptable) {
            IResourceSetFileAdaptable adaptable = (IResourceSetFileAdaptable)adaptableObject;
            resourceSet = adaptable.getResourceSet();
            file = adaptable.getFile();
        } else if (adaptableObject instanceof IFile) {
            file = (IFile)adaptableObject;
        }
        if (file != null && TestUI.isSupportedFileExtension(file.getFileExtension()) && (eObjects = EMFUtil.load((ResourceSet)resourceSet, (IFile)file)).length == 1 && eObjects[0] instanceof CMNNamedElement) {
            return (CMNNamedElement)eObjects[0];
        }
        return null;
    }

    protected IHyadesWorkbenchAdapter getTestWorkbenchAdapter(Object adaptableObject) {
        if (adaptableObject instanceof CMNNamedElement) {
            return this.getHyadesWorkbenchAdapter();
        }
        if (adaptableObject instanceof TPFExecutionEvent) {
            return this.getHyadesWorkbenchAdapter();
        }
        if (adaptableObject instanceof IResource) {
            return this.getHyadesWorkbenchAdapter();
        }
        if (adaptableObject instanceof LogicalFolder) {
            return this.getHyadesWorkbenchAdapter();
        }
        if (adaptableObject instanceof Resource) {
            return this.getHyadesWorkbenchAdapter();
        }
        return null;
    }

    protected IPropertySource getPropertySource(Object adaptableObject) {
        IPropertySource propertySource;
        if (PropertySourceExtensionManager.getInstance().isExtendableObject(adaptableObject) && (propertySource = PropertySourceExtensionManager.getInstance().getPropertySource(adaptableObject)) != null) {
            return propertySource;
        }
        if (adaptableObject instanceof CMNNamedElementProxyNode) {
            return new CMNNamedElementPropertySource((CMNNamedElementProxyNode)adaptableObject);
        }
        if (adaptableObject instanceof CMNNamedElement) {
            return new CMNNamedElementPropertySource((CMNNamedElement)adaptableObject);
        }
        if (adaptableObject instanceof Resource) {
            return (IPropertySource)this.getResource(adaptableObject).getAdapter(IPropertySource.class);
        }
        return null;
    }

    protected IPersistableElement getPersistableElement(Object adaptableObject) {
        if (adaptableObject instanceof CMNNamedElement) {
            return new CMNNamedElementUtil.PersistableElement((CMNNamedElement)adaptableObject);
        }
        if (adaptableObject instanceof Resource) {
            return new ResourceUtil.PersistableElement((Resource)adaptableObject);
        }
        return null;
    }

    protected INamedElement getNamedElement(Object adaptableObject) {
        if (adaptableObject instanceof CMNNamedElement) {
            return new CMNNamedElementUtil.UINamedElement((CMNNamedElement)adaptableObject);
        }
        return null;
    }

    protected IFile getFile(Object adaptableObject) {
        IResource res = this.getResource(adaptableObject);
        return res instanceof IFile ? (IFile)res : null;
    }

    protected IResource getResource(Object adaptableObject) {
        if (adaptableObject instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)((Resource)adaptableObject));
        }
        if (adaptableObject instanceof ITestCaseProxyNode) {
            return null;
        }
        if (adaptableObject instanceof EObject) {
            return EMFUtil.getWorkspaceFile((Resource)((EObject)adaptableObject).eResource());
        }
        if (adaptableObject instanceof IExtendedProxyNode) {
            return ((IExtendedProxyNode)adaptableObject).getCorrespondingResource();
        }
        return null;
    }

    private Resource getEMFResource(Object adaptableObject) {
        if (adaptableObject instanceof FileProxyNode) {
            return EMFUtil.getResource(null, (IFile)((IFile)((FileProxyNode)adaptableObject).getUnderlyingResource()));
        }
        return null;
    }

    private IProxyNodeRenamer getProxyNodeRenamer(Object adaptableObject) {
        if (adaptableObject instanceof CMNNamedElementProxyNode) {
            return (IProxyNodeRenamer)adaptableObject;
        }
        return null;
    }
}

