/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DatapoolTableUtil {
    public static final String TAG_DATA = "data";
    public static final String TAG_RECORD = "record";
    public static final String TAG_VARIABLE = "variable";
    public static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private DatapoolTable dpTable = null;
    private Table table = null;

    public DatapoolTableUtil(DatapoolTable table) {
        this.dpTable = table;
        this.table = (Table)this.dpTable.getViewer().getControl();
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public void insertColumn(TableColumn tableColumn, int insertionIndex) {
        int sourceIndex = this.findColumnIndex(tableColumn);
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell[] newRowData = new IDatapoolCell[this.table.getColumnCount() - 1];
            String[] newRowContext = new String[this.table.getColumnCount()];
            newRowContext[0] = tableItem.getText(0);
            int j = 0;
            while (j < newRowData.length) {
                if (j < insertionIndex) {
                    newRowData[j] = rowData[j];
                    newRowContext[j + 1] = tableItem.getText(j + 1);
                }
                if (j > insertionIndex) {
                    try {
                        newRowData[j] = rowData[j - 1];
                        newRowContext[j] = tableItem.getText(j);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                if (j == insertionIndex) {
                    IDatapoolRecord record = (IDatapoolRecord)tableItem.getData(TAG_RECORD);
                    newRowData[j] = (IDatapoolCell)record.getCell(j);
                }
                ++j;
            }
            tableItem.setData(TAG_DATA, (Object)newRowData);
            tableItem.setText(newRowContext);
            ++i;
        }
        if (sourceIndex >= 0) {
            if (sourceIndex != insertionIndex + 1) {
                this.moveColumn(sourceIndex, insertionIndex + 1);
                TableColumn sourceColumn = this.table.getColumn(sourceIndex);
                TableColumn insertedColumn = this.table.getColumn(insertionIndex + 1);
                sourceColumn.setWidth(100);
                sourceColumn.setResizable(true);
                insertedColumn.setWidth(100);
                insertedColumn.setResizable(true);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void deleteColumn(int columnIndex) {
        TableColumn tableColumn = null;
        if (columnIndex + 1 == this.getColumnCount() || columnIndex == 0) {
            tableColumn = this.table.getColumn(columnIndex);
        } else {
            this.moveColumn(columnIndex, this.getColumnCount() - 1);
            tableColumn = this.table.getColumn(this.getColumnCount() - 1);
        }
        if (tableColumn != null) {
            tableColumn.dispose();
        }
    }

    private int findColumnIndex(TableColumn column) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            if (this.table.getColumn(i).equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void swapColumn(int sourceColumnIndex, int targetColumnIndex) {
        TableColumn sourceColumn = this.table.getColumn(sourceColumnIndex);
        String sourceName = sourceColumn.getText();
        IDatapoolVariable sourceVariable = (IDatapoolVariable)sourceColumn.getData(TAG_VARIABLE);
        Image sourceImage = sourceColumn.getImage();
        TableColumn targetColumn = this.table.getColumn(targetColumnIndex);
        String targetName = targetColumn.getText();
        IDatapoolVariable targetVariable = (IDatapoolVariable)targetColumn.getData(TAG_VARIABLE);
        Image targetImage = targetColumn.getImage();
        sourceColumn.setText(targetName);
        sourceColumn.setData(TAG_VARIABLE, (Object)targetVariable);
        sourceColumn.setImage(targetImage);
        targetColumn.setText(sourceName);
        targetColumn.setData(TAG_VARIABLE, (Object)sourceVariable);
        targetColumn.setImage(sourceImage);
        int i = 0;
        while (i < this.table.getItemCount()) {
            IDatapoolCell targetCell;
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            String[] newRowContext = new String[this.table.getColumnCount()];
            newRowContext[0] = tableItem.getText(0);
            int j = 0;
            while (j < rowData.length) {
                newRowContext[j + 1] = tableItem.getText(j + 1);
                ++j;
            }
            newRowContext[sourceColumnIndex] = tableItem.getText(targetColumnIndex);
            newRowContext[targetColumnIndex] = tableItem.getText(sourceColumnIndex);
            IDatapoolCell sourceCell = rowData[sourceColumnIndex - 1];
            rowData[sourceColumnIndex - 1] = targetCell = rowData[targetColumnIndex - 1];
            rowData[targetColumnIndex - 1] = sourceCell;
            tableItem.setData(TAG_DATA, (Object)rowData);
            tableItem.setText(newRowContext);
            ++i;
        }
    }

    public void moveColumn(int sourceColumnIndex, int targetColumnIndex) {
        int numToSwap = 0;
        numToSwap = sourceColumnIndex < targetColumnIndex ? targetColumnIndex - sourceColumnIndex : sourceColumnIndex - targetColumnIndex;
        TableColumn sourceColumn = this.table.getColumn(sourceColumnIndex);
        String sourceName = sourceColumn.getText();
        IDatapoolVariable sourceVariable = (IDatapoolVariable)sourceColumn.getData(TAG_VARIABLE);
        Image sourceImage = sourceColumn.getImage();
        int i = 0;
        while (i < numToSwap) {
            TableColumn shiftColumn = null;
            TableColumn targetColumn = null;
            if (sourceColumnIndex < targetColumnIndex) {
                shiftColumn = this.table.getColumn(sourceColumnIndex + i + 1);
                targetColumn = this.table.getColumn(sourceColumnIndex + i);
            } else {
                shiftColumn = this.table.getColumn(sourceColumnIndex - i - 1);
                targetColumn = this.table.getColumn(sourceColumnIndex - i);
            }
            String shiftName = shiftColumn.getText();
            IDatapoolVariable shiftVariable = (IDatapoolVariable)shiftColumn.getData(TAG_VARIABLE);
            Image shiftImage = shiftColumn.getImage();
            targetColumn.setText(shiftName);
            targetColumn.setData(TAG_VARIABLE, (Object)shiftVariable);
            targetColumn.setImage(shiftImage);
            ++i;
        }
        TableColumn targetColumn = this.table.getColumn(targetColumnIndex);
        targetColumn.setText(sourceName);
        targetColumn.setData(TAG_VARIABLE, (Object)sourceVariable);
        targetColumn.setImage(sourceImage);
        int i2 = 0;
        while (i2 < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(i2);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell sourceCell = rowData[sourceColumnIndex - 1];
            String sourceText = tableItem.getText(sourceColumnIndex);
            int j = 0;
            while (j < numToSwap) {
                String shiftText;
                IDatapoolCell shiftCell;
                if (sourceColumnIndex < targetColumnIndex) {
                    shiftCell = rowData[sourceColumnIndex + j];
                    shiftText = tableItem.getText(sourceColumnIndex + j + 1);
                    rowData[sourceColumnIndex + j - 1] = shiftCell;
                    tableItem.setText(sourceColumnIndex + j, shiftText);
                } else {
                    shiftCell = rowData[sourceColumnIndex - j - 2];
                    shiftText = tableItem.getText(sourceColumnIndex - j - 1);
                    rowData[sourceColumnIndex - j - 1] = shiftCell;
                    tableItem.setText(sourceColumnIndex - j, shiftText);
                }
                ++j;
            }
            tableItem.setText(targetColumnIndex, sourceText);
            rowData[targetColumnIndex - 1] = sourceCell;
            tableItem.setData(TAG_DATA, (Object)rowData);
            ++i2;
        }
    }

    public void swapRow(int sourceRowIndex, int targetRowIndex) {
        TableItem sourceItem = this.table.getItem(sourceRowIndex);
        String[] sourceRowContext = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < this.table.getColumnCount()) {
            sourceRowContext[i] = sourceItem.getText(i);
            ++i;
        }
        IDatapoolCell[] sourceRowData = (IDatapoolCell[])sourceItem.getData(TAG_DATA);
        IDatapoolRecord sourceRecord = (IDatapoolRecord)sourceItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass sourceEquivalenceClass = (IDatapoolEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);
        TableItem targetItem = this.table.getItem(targetRowIndex);
        String[] targetRowContext = new String[this.table.getColumnCount()];
        int i2 = 0;
        while (i2 < this.table.getColumnCount()) {
            targetRowContext[i2] = targetItem.getText(i2);
            ++i2;
        }
        IDatapoolCell[] targetRowData = (IDatapoolCell[])targetItem.getData(TAG_DATA);
        IDatapoolRecord targetRecord = (IDatapoolRecord)targetItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass targetEquivalenceClass = (IDatapoolEquivalenceClass)targetItem.getData(TAG_EQUIVALENCE_CLASS);
        sourceItem.setText(targetRowContext);
        sourceItem.setData(TAG_DATA, (Object)targetRowData);
        sourceItem.setData(TAG_RECORD, (Object)targetRecord);
        sourceItem.setData(TAG_EQUIVALENCE_CLASS, (Object)targetEquivalenceClass);
        targetItem.setText(sourceRowContext);
        targetItem.setData(TAG_DATA, (Object)sourceRowData);
        targetItem.setData(TAG_RECORD, (Object)sourceRecord);
        targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)sourceEquivalenceClass);
    }

    public void moveRow(int sourceRowIndex, int targetRowIndex) {
        int numToSwap = 0;
        numToSwap = sourceRowIndex < targetRowIndex ? targetRowIndex - sourceRowIndex : sourceRowIndex - targetRowIndex;
        TableItem sourceItem = this.table.getItem(sourceRowIndex);
        String[] sourceRowContext = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < this.table.getColumnCount()) {
            sourceRowContext[i] = sourceItem.getText(i);
            ++i;
        }
        IDatapoolCell[] sourceRowData = (IDatapoolCell[])sourceItem.getData(TAG_DATA);
        IDatapoolRecord sourceRecord = (IDatapoolRecord)sourceItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass sourceEquivalenceClass = (IDatapoolEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);
        int i2 = 0;
        while (i2 < numToSwap) {
            TableItem shiftItem = null;
            TableItem targetItem = null;
            if (sourceRowIndex < targetRowIndex) {
                shiftItem = this.table.getItem(sourceRowIndex + i2 + 1);
                targetItem = this.table.getItem(sourceRowIndex + i2);
            } else {
                shiftItem = this.table.getItem(sourceRowIndex - i2 - 1);
                targetItem = this.table.getItem(sourceRowIndex - i2);
            }
            String[] shiftRowContext = new String[this.table.getColumnCount()];
            int j = 0;
            while (j < this.table.getColumnCount()) {
                shiftRowContext[j] = shiftItem.getText(j);
                ++j;
            }
            IDatapoolCell[] shiftRowData = (IDatapoolCell[])shiftItem.getData(TAG_DATA);
            IDatapoolRecord shiftRecord = (IDatapoolRecord)shiftItem.getData(TAG_RECORD);
            IDatapoolEquivalenceClass shiftEquivalenceClass = (IDatapoolEquivalenceClass)shiftItem.getData(TAG_EQUIVALENCE_CLASS);
            targetItem.setText(shiftRowContext);
            targetItem.setData(TAG_DATA, (Object)shiftRowData);
            targetItem.setData(TAG_RECORD, (Object)shiftRecord);
            targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)shiftEquivalenceClass);
            ++i2;
        }
        TableItem targetItem = this.table.getItem(targetRowIndex);
        targetItem.setText(sourceRowContext);
        targetItem.setData(TAG_DATA, (Object)sourceRowData);
        targetItem.setData(TAG_RECORD, (Object)sourceRecord);
        targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)sourceEquivalenceClass);
    }
}

