/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolChangeKeyDialog
extends DatapoolBaseDialog {
    private IDatapool datapool = null;
    private boolean isChangeMode = false;
    private String oldKey = null;
    private String newKey = null;
    private String confirmKey = null;
    private Label errorLabel = null;

    public DatapoolChangeKeyDialog(Shell parentShell, IDatapool datapool, boolean isChangeMode) {
        super(parentShell);
        this.datapool = datapool;
        this.isChangeMode = isChangeMode;
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public String getNewKey() {
        return this.newKey;
    }

    public String getConfirmKey() {
        return this.confirmKey;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isChangeMode) {
            this.getShell().setText(UiPluginResourceBundle.DatapoolDialog_MODIFYPASSWORDDIALOGTITLE);
        } else {
            this.getShell().setText(UiPluginResourceBundle.DatapoolDialog_ASSIGNKEYDIALOGTITLE);
        }
        GridData gridData = GridDataUtil.createFill();
        gridData.minimumWidth = 300;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parentComposite.setLayoutData((Object)gridData);
        parentComposite.setLayout((Layout)gridLayout);
        if (this.isChangeMode) {
            Label oldKeyLabel = new Label(parentComposite, 0);
            oldKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_OLDKEY);
            final Text oldKeyText = new Text(parentComposite, 0x400804);
            oldKeyText.setLayoutData((Object)new GridData(768));
            oldKeyText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DatapoolChangeKeyDialog.this.oldKey = oldKeyText.getText();
                    DatapoolChangeKeyDialog.this.enableOK();
                }
            });
        }
        Label newKeyLabel = new Label(parentComposite, 0);
        newKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEY);
        final Text newKeyText = new Text(parentComposite, 0x400804);
        newKeyText.setLayoutData((Object)new GridData(768));
        newKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolChangeKeyDialog.this.newKey = newKeyText.getText();
                DatapoolChangeKeyDialog.this.enableOK();
            }
        });
        Label confirmKeyLabel = new Label(parentComposite, 0);
        confirmKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_CONFIRMNEWKEY);
        final Text confirmKeyText = new Text(parentComposite, 0x400804);
        confirmKeyText.setLayoutData((Object)new GridData(768));
        confirmKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolChangeKeyDialog.this.confirmKey = confirmKeyText.getText();
                DatapoolChangeKeyDialog.this.enableOK();
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(parentComposite, 0);
        this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYNOTCONFIRMMES);
        this.errorLabel.setLayoutData((Object)gridData);
        this.errorLabel.setForeground(Display.getDefault().getSystemColor(3));
        this.errorLabel.setVisible(false);
        parentComposite.pack();
        return parentComposite;
    }

    private void enableOK() {
        boolean enableOK = true;
        if (this.isChangeMode && (this.oldKey == null || this.oldKey.equals("") || !DatapoolEncryptManager.isKeyCorrect((IDatapool)this.datapool, (String)this.oldKey))) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_ORIGINKEYERRORMES);
        } else if (this.newKey == null || this.newKey.equals("")) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYEMPTYMES);
        } else if (this.confirmKey == null || this.confirmKey.equals("") || !this.newKey.equals(this.getConfirmKey())) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYNOTCONFIRMMES);
        }
        this.errorLabel.setVisible(!enableOK);
        this.getButton(0).setEnabled(enableOK);
    }
}

