/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolChangeKeyDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolInputKeyDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.datapool.util.DatapoolUtilities;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolColumnDialog
extends DatapoolBaseDialog {
    private IDatapool datapool = null;
    private String password = null;
    private IDatapoolVariable selectedVariable = null;
    private IDatapoolVariable previousVariable = null;
    private String name = null;
    private String type = null;
    private String insertionVariableName = null;
    private String insertionVariableID = null;
    private boolean isEncrypted = false;
    private String oldKey = null;
    private String newKey = null;
    private Label errorLabel = null;
    private int defaultNameCounter = 1;
    private static final String TAG_VARIABLES = "variables";

    public DatapoolColumnDialog(Shell parentShell, IDatapool datapool, String password, IDatapoolVariable selectedVariable, IDatapoolVariable previousVariable) {
        super(parentShell);
        this.datapool = datapool;
        this.password = password;
        this.selectedVariable = selectedVariable;
        this.previousVariable = previousVariable;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getType() {
        return this.type == null ? "" : this.type;
    }

    public String getInsertionVariableName() {
        return this.insertionVariableName;
    }

    public String getInsertionVariableID() {
        return this.insertionVariableID;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public String getNewKey() {
        return this.newKey;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.selectedVariable == null) {
            this.enableOK();
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.selectedVariable == null) {
            this.getShell().setText(UiPluginResourceBundle.DATA_COL_DLG_TITLE_INS);
        } else {
            this.getShell().setText(UiPluginResourceBundle.DATA_COL_DLG_TITLE_EDIT);
        }
        GridData gridData = GridDataUtil.createFill();
        gridData.minimumWidth = 300;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parentComposite.setLayoutData((Object)gridData);
        parentComposite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(parentComposite, 0);
        nameLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_NAME);
        final Text nameField = new Text(parentComposite, 2052);
        nameField.setLayoutData((Object)new GridData(768));
        nameField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DatapoolColumnDialog.this.name = nameField.getText();
                DatapoolColumnDialog.this.enableOK();
            }
        });
        Label typeLabel = new Label(parentComposite, 0);
        typeLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_TYPE);
        final Text typeField = new Text(parentComposite, 2052);
        typeField.setLayoutData((Object)new GridData(768));
        typeField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DatapoolColumnDialog.this.type = typeField.getText();
                DatapoolColumnDialog.this.enableOK();
            }
        });
        IDatapoolVariable[] variables = DatapoolUtil.getInstance().getVariables(this.datapool, null);
        if (this.selectedVariable != null) {
            this.name = this.selectedVariable.getName();
            nameField.setText(this.name);
            nameField.selectAll();
            this.type = DatapoolUtil.getInstance().getVariableTypeInfo(this.selectedVariable);
            if (this.type != null) {
                typeField.setText(this.type);
                typeField.setSelection(this.type.length() + 1);
            }
        }
        Label insertionLabel = new Label(parentComposite, 0);
        insertionLabel.setText(UiPluginResourceBundle.DATA_DLG_POSITION);
        if (this.selectedVariable == null) {
            this.name = NLS.bind((String)UiPluginResourceBundle.DATA_VARIABLE_NAME, (Object)NumberFormat.getInstance().format((long)(++this.defaultNameCounter)));
            while (!DatapoolUtilities.getInstance().isVariableNameUnique(this.datapool, this.name, null)) {
                this.name = NLS.bind((String)UiPluginResourceBundle.DATA_VARIABLE_NAME, (Object)NumberFormat.getInstance().format((long)(++this.defaultNameCounter)));
            }
            nameField.setText(this.name);
            nameField.selectAll();
            this.type = IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
            typeField.setText(this.type);
        }
        String[] variableLabels = this.getVariableLabels(variables);
        final Combo insertionVariables = new Combo(parentComposite, 12);
        insertionVariables.setItems(variableLabels);
        insertionVariables.setData(TAG_VARIABLES, (Object)variables);
        insertionVariables.setLayoutData((Object)new GridData(768));
        insertionVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int selectionIndex = insertionVariables.getSelectionIndex();
                if (selectionIndex > 0) {
                    String selectionText = insertionVariables.getItem(selectionIndex);
                    IDatapoolVariable[] variables = (IDatapoolVariable[])insertionVariables.getData(DatapoolColumnDialog.TAG_VARIABLES);
                    String variableName = null;
                    int counter = 0;
                    while (counter < variables.length) {
                        variableName = variables[counter].getName();
                        if (selectionText.endsWith(variableName)) {
                            DatapoolColumnDialog.this.insertionVariableName = variableName;
                            DatapoolColumnDialog.this.insertionVariableID = variables[counter].getId();
                            break;
                        }
                        ++counter;
                    }
                } else {
                    DatapoolColumnDialog.this.insertionVariableName = new String();
                    DatapoolColumnDialog.this.insertionVariableID = new String();
                }
                DatapoolColumnDialog.this.enableOK();
            }
        });
        int previousVariableLastIndex = this.getPreviousVariableLastIndex(variableLabels);
        if (previousVariableLastIndex == -1) {
            insertionVariables.select(0);
            this.insertionVariableName = new String();
            this.insertionVariableID = new String();
        } else {
            insertionVariables.select(previousVariableLastIndex);
            String variableName = null;
            int counter = 0;
            while (counter < variables.length) {
                variableName = variables[counter].getName();
                if (variableLabels[previousVariableLastIndex].endsWith(variableName)) {
                    this.insertionVariableName = variableName;
                    this.insertionVariableID = variables[counter].getId();
                    break;
                }
                ++counter;
            }
        }
        final Button encryptCheckBox = new Button(parentComposite, 32);
        encryptCheckBox.setText(UiPluginResourceBundle.DatapoolDialog_ENCRYPTED);
        final Button changeEncryptionKeyButton = new Button(parentComposite, 0);
        changeEncryptionKeyButton.setText(UiPluginResourceBundle.DatapoolDialog_CHANGEKEY);
        changeEncryptionKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DatapoolChangeKeyDialog datapoolChangeKeyDialog = new DatapoolChangeKeyDialog(DatapoolColumnDialog.this.getShell(), DatapoolColumnDialog.this.datapool, true);
                if (datapoolChangeKeyDialog.open() == 0) {
                    DatapoolColumnDialog.this.oldKey = datapoolChangeKeyDialog.getOldKey();
                    DatapoolColumnDialog.this.newKey = datapoolChangeKeyDialog.getNewKey();
                }
                DatapoolColumnDialog.this.enableOK();
            }
        });
        encryptCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DatapoolColumnDialog.this.isEncrypted = encryptCheckBox.getSelection();
                if (changeEncryptionKeyButton != null && DatapoolEncryptManager.isDatapoolEncrypted((IDatapool)DatapoolColumnDialog.this.datapool)) {
                    changeEncryptionKeyButton.setEnabled(encryptCheckBox.getSelection());
                }
                DatapoolColumnDialog.this.enableOK();
            }
        });
        if (this.selectedVariable instanceof DPLVariable && ((DPLVariable)this.selectedVariable).isEncrypted()) {
            if (DatapoolEncryptManager.isDatapoolEncrypted((IDatapool)this.datapool)) {
                changeEncryptionKeyButton.setEnabled(true);
            }
            encryptCheckBox.setSelection(true);
            this.isEncrypted = true;
        } else {
            changeEncryptionKeyButton.setEnabled(false);
            encryptCheckBox.setSelection(false);
            this.isEncrypted = false;
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(parentComposite, 0);
        this.errorLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_ERROR_NAME_NOT_VALID);
        this.errorLabel.setLayoutData((Object)gridData);
        this.errorLabel.setForeground(Display.getDefault().getSystemColor(3));
        this.errorLabel.setVisible(false);
        parentComposite.pack();
        return parentComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        if (this.password == null && this.oldKey == null) {
            if (DatapoolEncryptManager.isDatapoolEncrypted((IDatapool)this.datapool)) {
                if (this.isEncrypted() || this.selectedVariable instanceof DPLVariable && ((DPLVariable)this.selectedVariable).isEncrypted()) {
                    DatapoolInputKeyDialog datapoolInputKeyDialog = new DatapoolInputKeyDialog(this.getShell(), this.datapool);
                    if (datapoolInputKeyDialog.open() != 0) return;
                    this.newKey = datapoolInputKeyDialog.getKey();
                }
            } else if (this.isEncrypted()) {
                DatapoolChangeKeyDialog datapoolChangeKeyDialog = new DatapoolChangeKeyDialog(this.getShell(), this.datapool, false);
                if (datapoolChangeKeyDialog.open() != 0) return;
                this.newKey = datapoolChangeKeyDialog.getNewKey();
            }
        }
        super.okPressed();
    }

    private void enableOK() {
        boolean enableOK = true;
        if (this.name == null || this.name.length() == 0) {
            enableOK = false;
        } else if (!DatapoolUtilities.getInstance().isVariableNameUnique(this.datapool, this.name, this.selectedVariable)) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE);
        } else if (!DatapoolUtilities.getInstance().isVariableNameValid(this.name)) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_ERROR_NAME_NOT_VALID);
        } else if (this.type != null && this.type.length() > 0 && !DatapoolUtilities.getInstance().isVariableTypeValid(this.type)) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DATA_COL_DLG_ERROR_TYPE_NOT_VALID);
        }
        this.errorLabel.setVisible(!enableOK);
        this.getButton(0).setEnabled(enableOK);
    }

    private String[] getVariableLabels(IDatapoolVariable[] variables) {
        String[] variableLabels = null;
        if (variables != null) {
            ArrayList<String> variableLabelsList = new ArrayList<String>();
            int counter = 0;
            while (counter < variables.length) {
                if (variables[counter] != null) {
                    String variableName = variables[counter].getName();
                    if (this.selectedVariable == null) {
                        if (counter == 0) {
                            variableLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)variableName));
                        }
                        variableLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)variableName));
                    } else if (variables[counter] != this.selectedVariable) {
                        if (variableLabelsList.size() == 0) {
                            variableLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)variableName));
                        }
                        variableLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)variableName));
                    }
                }
                ++counter;
            }
            variableLabels = variableLabelsList.size() == 0 ? new String[]{UiPluginResourceBundle.DATA_DLG_FIRST_VARIABLE} : variableLabelsList.toArray(new String[variableLabelsList.size()]);
        }
        return variableLabels;
    }

    private int getPreviousVariableLastIndex(String[] variableLabels) {
        int index = -1;
        if (variableLabels != null && this.previousVariable != null) {
            String previousVariableName = this.previousVariable.getName();
            int counter = 0;
            while (counter < variableLabels.length) {
                if (variableLabels[counter].endsWith(previousVariableName)) {
                    if (index != -1) {
                        index = counter;
                        break;
                    }
                    index = counter;
                }
                ++counter;
            }
        }
        return index;
    }
}

