/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.util.EncryptionManager;
import org.eclipse.hyades.test.core.launch.extensions.IPassInfoCollector;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolCheck
implements IPassInfoCollector {
    public void execute(DPLDatapool[] dp, Map pass, List isContinue) {
        DialogRun dr = new DialogRun();
        dr.setDp(dp);
        dr.setContinue(isContinue);
        dr.setPass(pass);
        Display.getDefault().syncExec((Runnable)dr);
    }

    private class DatapoolCheckDialog
    extends DatapoolBaseDialog
    implements KeyListener {
        private DPLDatapool[] dp;
        private String title;
        private Label[] name;
        private Text[] pass;
        private boolean[] status;
        private List unCorrectList;
        private Map passed;
        private String testId;

        public DatapoolCheckDialog(Shell parentShell) {
            super(parentShell);
            this.unCorrectList = new ArrayList();
        }

        public DatapoolCheckDialog(Shell parentShell, DPLDatapool[] dp, String title, Map passed, String testId) {
            super(parentShell);
            this.unCorrectList = new ArrayList();
            this.dp = dp;
            this.title = title;
            this.passed = passed;
            this.testId = testId;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.title);
            Composite superComposite = (Composite)super.createDialogArea(parent);
            GridData gridData = GridDataUtil.createFill();
            gridData.minimumWidth = 300;
            superComposite.setLayoutData((Object)gridData);
            superComposite.setLayout((Layout)new GridLayout());
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            Group descriptionGroup = new Group(superComposite, 16);
            descriptionGroup.setText(UiPluginResourceBundle.DatapoolDialog_INPUTPASSHINT);
            descriptionGroup.setLayoutData((Object)gridData);
            descriptionGroup.setLayout((Layout)gridLayout);
            if (this.dp != null && this.dp.length > 0) {
                this.name = new Label[this.dp.length];
                this.pass = new Text[this.dp.length];
                this.status = new boolean[this.dp.length];
                int counter = 0;
                while (counter < this.dp.length) {
                    this.name[counter] = new Label((Composite)descriptionGroup, 0);
                    String datapoolName = this.dp[counter].getName();
                    int splitMarkIndex = datapoolName.indexOf("::");
                    if (splitMarkIndex != -1) {
                        this.name[counter].setText(NLS.bind((String)UiPluginResourceBundle.DatapoolDialog_DATAPOOLNAMELABEL, (Object)datapoolName.substring(0, splitMarkIndex)));
                    } else {
                        this.name[counter].setText(NLS.bind((String)UiPluginResourceBundle.DatapoolDialog_DATAPOOLNAMELABEL, (Object)datapoolName));
                    }
                    this.pass[counter] = new Text((Composite)descriptionGroup, 0x400800);
                    this.pass[counter].setLayoutData((Object)new GridData(768));
                    this.pass[counter].addKeyListener((KeyListener)this);
                    this.status[counter] = false;
                    ++counter;
                }
            }
            superComposite.pack();
            return superComposite;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.getOKButton().setEnabled(false);
            return control;
        }

        public void okPressed() {
            this.enableOK();
        }

        private void enableOK() {
            int i = 0;
            while (i < this.dp.length) {
                try {
                    if (!this.status[i]) {
                        if (this.dp[i].getChallenge().equals(EncryptionManager.EncoderByMd5((String)this.pass[i].getText()))) {
                            if (this.passed.get(this.testId) == null) {
                                this.passed.put(this.testId, new HashMap());
                            }
                            HashMap thm = (HashMap)this.passed.get(this.testId);
                            thm.put(this.dp[i].getName(), this.pass[i].getText());
                            this.pass[i].setEnabled(false);
                            this.status[i] = true;
                            if (this.unCorrectList != null && this.unCorrectList.contains(this.dp[i])) {
                                this.unCorrectList.remove(this.dp[i]);
                            }
                        } else {
                            this.pass[i].setText("");
                            if (!this.unCorrectList.contains(this.dp[i])) {
                                this.unCorrectList.add(this.dp[i]);
                            }
                        }
                    }
                }
                catch (Exception er) {
                    UiPlugin.logError(er);
                }
                ++i;
            }
            if (this.unCorrectList.size() == 0) {
                super.okPressed();
                return;
            }
            StringBuffer toShow = new StringBuffer();
            toShow.append(UiPluginResourceBundle.DatapoolDialog_PASSWORDSHINT);
            int i2 = 0;
            while (i2 < this.unCorrectList.size()) {
                toShow.append(((DPLDatapool)this.unCorrectList.get(i2)).getName().split("::")[0]);
                if (i2 < this.unCorrectList.size() - 1) {
                    toShow.append(",\n");
                }
                ++i2;
            }
            MessageDialog.openError(null, (String)UiPluginResourceBundle.W_ERROR, (String)toShow.toString());
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 13) {
                this.enableOK();
            } else {
                this.getOKButton().setEnabled(true);
            }
        }
    }

    private class DialogRun
    implements Runnable {
        private DPLDatapool[] dp;
        private Map pass;
        private List isContinue;

        private DialogRun() {
        }

        public void setDp(DPLDatapool[] dp) {
            this.dp = dp;
        }

        public void setPass(Map pass) {
            this.pass = pass;
        }

        public void setContinue(List isContinue) {
            this.isContinue = isContinue;
        }

        public void run() {
            String testId = null;
            if (this.isContinue != null && this.isContinue.size() == 1) {
                testId = (String)this.isContinue.get(0);
                this.isContinue.clear();
            }
            DatapoolCheckDialog db = new DatapoolCheckDialog(null, this.dp, UiPluginResourceBundle.DatapoolDialog_INPUTKEYDIALGOTITLE, this.pass, testId);
            db.setBlockOnOpen(true);
            if (db.open() == 0) {
                this.isContinue.add(Boolean.TRUE.toString());
            }
        }
    }
}

