/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.extension;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.Guid;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.editor.extension.resources.EditorExtensionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.editor.EditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorActionBarContributor;

public abstract class BaseEditorExtension
extends EditorExtension
implements ISynchronizedEditorAdapter,
IHyadesEditorExtension {
    private ListenerList writeAccessChangeListeners = new ListenerList();
    private Clipboard clipboard = null;
    private boolean dirty = false;

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.writeAccessChangeListeners.clear();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (ISynchronizedEditorAdapter.class == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected ResourceSet getResourceSet() {
        return ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource().getResourceSet();
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getHyadesEditorPart().getEditorPart().getEditorSite().getShell().getDisplay());
        }
        return this.clipboard;
    }

    public void addListener(IWriteAccessChangeListener listener) {
        this.writeAccessChangeListeners.add((Object)listener);
    }

    public void removeListener(IWriteAccessChangeListener listener) {
        this.writeAccessChangeListeners.remove((Object)listener);
    }

    protected void notifyWriteAccessChangeListeners(IFile file, boolean isReadOnly) {
        if (file == null) {
            return;
        }
        Object[] listeners = this.writeAccessChangeListeners.getListeners();
        int i = 0;
        int maxi = listeners.length;
        while (i < maxi) {
            ((IWriteAccessChangeListener)listeners[i]).writeAccessChanged(file, isReadOnly);
            ++i;
        }
    }

    public synchronized void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
    }

    protected void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected boolean isOkToSave() {
        return true;
    }

    public final void doSave(IProgressMonitor monitor) {
        if (!this.isValidToSave()) {
            return;
        }
        if (this.isOkToSave()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        BaseEditorExtension.this.save(progressMonitor);
                        BaseEditorExtension.this.clearDirty();
                    }
                    catch (OperationCanceledException operationCanceledException) {
                    }
                    catch (Exception e) {
                        BaseEditorExtension.this.handleException(e);
                    }
                }
            };
            IActionBars actionBars = this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
            if (actionBars != null && actionBars.getStatusLineManager() != null) {
                actionBars.getStatusLineManager().setErrorMessage(null);
                actionBars.getStatusLineManager().setMessage(null);
                monitor = actionBars.getStatusLineManager().getProgressMonitor();
                actionBars.getStatusLineManager().setCancelEnabled(false);
            } else if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                ModalContext.run((IRunnableWithProgress)operation, (boolean)false, (IProgressMonitor)monitor, (Display)Display.getCurrent());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void save(IProgressMonitor monitor) throws Exception {
        Resource[] resources = (Resource[])this.getResourceSet().getResources().toArray((Object[])new Resource[this.getResourceSet().getResources().size()]);
        int length = resources.length;
        int counter = 0;
        monitor.beginTask("", length);
        IFileProxyManager fileProxyManager = TestNavigator.getFileProxyManager();
        if (fileProxyManager == null) {
            fileProxyManager = new FileProxyManager();
        }
        int i = 0;
        int maxi = resources.length;
        while (i < maxi) {
            if (resources[i].isModified()) {
                this.logSaveMessage(monitor, resources[i], length, counter++);
                EMFUtil.save((Resource)resources[i]);
                if (resources[i] instanceof IFile) {
                    fileProxyManager.updateProxy((IFile)resources[i], null);
                }
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    private void displayErrorOnSaveValidation(String message) {
        MessageDialog.openError((Shell)this.getHyadesEditorPart().getEditorPart().getSite().getShell(), (String)EditorExtensionMessages._8, (String)message);
    }

    protected boolean isValidToSave() {
        EObject editorEObject = (EObject)this.getHyadesEditorPart().getEditorObject();
        if (editorEObject != null && editorEObject instanceof CMNNamedElement) {
            IFile editorFile;
            IProxyNode proxy;
            CMNNamedElement editorNamedElement = (CMNNamedElement)editorEObject;
            String logicalName = editorNamedElement.getName();
            if (logicalName == null || logicalName.trim().length() == 0) {
                this.displayErrorOnSaveValidation(EditorExtensionMessages.SaveValidationErrorMsg_0);
                return false;
            }
            IFileProxyManager fileProxyManager = TestNavigator.getFileProxyManager();
            if (fileProxyManager == null) {
                fileProxyManager = new FileProxyManager();
            }
            if ((proxy = fileProxyManager.getProxy(editorFile = EMFUtil.getWorkspaceFile((Resource)editorNamedElement.eResource()), null)) != null && proxy instanceof CMNNamedElementProxyNode && (TestUIUtil.IS_WINDOWS_OS ? ((CMNNamedElementProxyNode)proxy).getName().equalsIgnoreCase(logicalName) : ((CMNNamedElementProxyNode)proxy).getName().equals(logicalName))) {
                return true;
            }
            if (!(TestUIUtil.isLogicalNameLengthValid(logicalName) && TestUIUtil.isLogicalNameValid(logicalName) && TestUIUtil.isLogicalNameAvailable(logicalName, editorFile.getParent()))) {
                this.displayErrorOnSaveValidation(EditorExtensionMessages.SaveValidationErrorMsg_3);
                return false;
            }
        }
        return true;
    }

    protected void logSaveMessage(IProgressMonitor monitor, Resource resource, int total, int current) {
        monitor.subTask("");
    }

    protected void handleException(Exception exception) {
        UiPlugin.logError(exception);
        String filePath = EMFUtil.getFilePath((EObject)((EObject)this.getHyadesEditorPart().getEditorObject()));
        UIUtil.openSaveFileErrorDialog((Shell)this.getHyadesEditorPart().getEditorPart().getSite().getShell(), (String)filePath, (Throwable)exception);
    }

    protected boolean reloadEditorObject() {
        Resource resource = ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource();
        resource.unload();
        try {
            resource.load(EMFUtil.RESOURCE_OPTIONS);
        }
        catch (Exception e) {
            UiPlugin.logError(e);
        }
        if (!resource.getContents().isEmpty()) {
            this.getHyadesEditorPart().setEditorObject(resource.getContents().get(0));
        } else {
            this.getHyadesEditorPart().setEditorObject(null);
        }
        return false;
    }

    protected URI getObjectURI(Object object) {
        EObject eObject;
        if (object != null && object instanceof EObject && (eObject = (EObject)object).eResource() != null) {
            return eObject.eResource().getURI().appendFragment(eObject.eResource().getURIFragment(eObject));
        }
        return null;
    }

    public boolean editorFileChanged() {
        return false;
    }

    public boolean editorFileDeleted() {
        return false;
    }

    public boolean editorFileWriteAccessChanged(boolean isReadOnly) {
        this.notifyWriteAccessChangeListeners(EMFUtil.getWorkspaceFile((EObject)((EObject)this.getHyadesEditorPart().getEditorObject())), isReadOnly);
        return false;
    }

    public void handle(List changedFiles, List removedFiles) {
    }

    public boolean reload() {
        Object selection;
        String fragment = null;
        IStructuredSelection structuredSelection = this.getSelection();
        if (structuredSelection.size() == 1 && (selection = structuredSelection.getFirstElement()) instanceof EObject) {
            fragment = ((EObject)selection).eResource().getURIFragment((EObject)selection);
        }
        if (!this.reloadEditorObject()) {
            Object editorObject = this.getHyadesEditorPart().getEditorObject();
            if (editorObject instanceof EObject) {
                Resource res = ((EObject)editorObject).eResource();
                ResourceSet resset = this.getResourceSet();
                Object[] allres = this.getResourceSet().getResources().toArray();
                int i = 0;
                while (i < allres.length) {
                    if (!((Resource)allres[i]).getURI().equals((Object)res.getURI())) {
                        resset.getResources().remove(allres[i]);
                    }
                    ++i;
                }
            }
            this.refreshContent(editorObject);
            if (editorObject instanceof EObject && fragment != null) {
                EObject selection2 = ((EObject)editorObject).eResource().getEObject(fragment);
                structuredSelection = selection2 != null ? new StructuredSelection((Object)selection2) : StructuredSelection.EMPTY;
                this.setSelection(structuredSelection);
            }
            this.dirty = false;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
        return true;
    }

    public boolean doSaveEditorFile(boolean wasDeleted) {
        this.getHyadesEditorPart().getEditorPart().doSave((IProgressMonitor)new NullProgressMonitor());
        return false;
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    private void performSaveAs(IProgressMonitor progressMonitor) {
        block10: {
            boolean isCanceled = false;
            try {
                IPath newFilePath;
                IFile originalFile;
                SaveAsDialog dialog = new SaveAsDialog(this.getHyadesEditorPart().getEditorPart().getEditorSite().getShell());
                IEditorInput editorInput = this.getHyadesEditorPart().getEditorPart().getEditorInput();
                if (editorInput instanceof IFileEditorInput && (originalFile = ((IFileEditorInput)editorInput).getFile()) != null) {
                    dialog.setOriginalFile(originalFile);
                }
                dialog.create();
                if (dialog.open() != 0 || (newFilePath = dialog.getResult()) == null) break block10;
                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
                try {
                    EObject eObject;
                    Resource resource;
                    Object editorObject = this.getHyadesEditorPart().getEditorObject();
                    if (!(editorObject instanceof EObject) || (resource = (eObject = (EObject)editorObject).eResource()) == null || !(eObject instanceof CMNNamedElement)) break block10;
                    CMNNamedElement namedElement = (CMNNamedElement)eObject;
                    URI originalURI = resource.getURI();
                    String originalId = namedElement.getId();
                    String originalName = namedElement.getName();
                    try {
                        namedElement.eSetDeliver(false);
                        resource.setURI(URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)false));
                        namedElement.setId(new Guid().toString());
                        namedElement.setName(newFilePath.removeFileExtension().lastSegment());
                        EMFUtil.save((Resource)resource);
                    }
                    finally {
                        resource.setURI(originalURI);
                        namedElement.setId(originalId);
                        namedElement.setName(originalName);
                        namedElement.eSetDeliver(true);
                    }
                    TestUIUtil.openEditor(newFile, this.getHyadesEditorPart().getEditorPart().getEditorSite().getId());
                    isCanceled = false;
                }
                catch (Exception e) {
                    TestCorePlugin.getDefault().logError((Throwable)e);
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(isCanceled);
                }
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }
}

