/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.actions.CollapseTreeAction;
import org.eclipse.hyades.test.ui.forms.actions.TreeSelectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class ExpandTreeAction
extends TreeSelectionAction {
    private CollapseTreeAction collapseAction;

    public ExpandTreeAction(String text, TreeViewer treeViewer) {
        super(text, treeViewer);
        this.setToolTipText(UiPluginResourceBundle.TestLogViewer_ExpandSelection);
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "expandall.gif"));
        this.setDisabledImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("d", "expandall.gif"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (!selection.isEmpty()) {
            Object element = selection.getFirstElement();
            boolean hasChildren = ((ITreeContentProvider)this.getViewer().getContentProvider()).hasChildren(element);
            if (hasChildren && !this.getViewer().getExpandedState(element)) {
                return true;
            }
        }
        return false;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        if (event.getElement() == ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement()) {
            this.setEnabled(true);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        if (event.getElement() == ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement()) {
            this.setEnabled(false);
        }
    }

    public void setCollapseAction(CollapseTreeAction collapseAction) {
        this.collapseAction = collapseAction;
    }

    public void run() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        if (structuredSelection != null && !structuredSelection.isEmpty()) {
            this.getViewer().expandToLevel(structuredSelection.getFirstElement(), -1);
            this.setEnabled(false);
            if (this.collapseAction != null) {
                this.collapseAction.setEnabled(true);
            }
        }
    }
}

