/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.extensions.IEventAction;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class OpenJavaScriptAction
extends Action
implements IEventAction {
    public static String propNamejavaProject = "javaProjectName";
    public static String propNameJavaClass = "qualifiedJavaClassName";
    public static String propNameLineNumber = "javaClassLineNumber";
    private static boolean isRCP = false;
    private TPFExecutionEvent executionEvent;
    private String javaProject = null;
    private String javaClassName = null;
    private String javaClassLineNumber = null;

    public OpenJavaScriptAction() {
        this.setEnabled(false);
        if (!RegistryReader.isPlatformMode() || !RegistryReader.isWorkspaceMode()) {
            isRCP = true;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.setEnabled(false);
        if (!isRCP && !selection.isEmpty()) {
            this.executionEvent = null;
            this.javaClassLineNumber = null;
            this.javaClassName = null;
            this.javaProject = null;
            boolean checkedProject = false;
            boolean checkedClass = false;
            boolean checkedLine = false;
            Object sel = selection.getFirstElement();
            if (sel instanceof TPFExecutionEvent) {
                this.executionEvent = (TPFExecutionEvent)sel;
                EList properties = ((TPFExecutionEvent)sel).getProperties();
                if (properties != null && !properties.isEmpty()) {
                    for (Object next : properties) {
                        if (!(next instanceof CMNExtendedProperty)) continue;
                        if (propNamejavaProject.equals(((CMNExtendedProperty)next).getName())) {
                            this.javaProject = ((CMNExtendedProperty)next).getValue();
                            checkedProject = true;
                            if (!checkedClass || !checkedLine) continue;
                            break;
                        }
                        if (propNameJavaClass.equals(((CMNExtendedProperty)next).getName())) {
                            this.javaClassName = ((CMNExtendedProperty)next).getValue();
                            checkedClass = true;
                            if (!checkedProject || !checkedLine) continue;
                            break;
                        }
                        if (!propNameLineNumber.equals(((CMNExtendedProperty)next).getName())) continue;
                        this.javaClassLineNumber = ((CMNExtendedProperty)next).getValue();
                        checkedLine = true;
                        if (checkedProject && checkedClass) break;
                    }
                    if (this.javaClassName != null) {
                        this.setEnabled(true);
                    }
                }
            }
        }
    }

    public void run() {
        this.openJavaTypeAtLine(this.javaProject, this.javaClassName, this.javaClassLineNumber);
    }

    public boolean updateButtonStatus() {
        return this.isEnabled();
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IAction)this);
        manager.add((IContributionItem)new Separator());
    }

    private void openJavaTypeAtLine(String javaProject, String qualifiedJavaClassName, String lineNumber) {
        if (isRCP || qualifiedJavaClassName == null) {
            return;
        }
        IJavaProject project = null;
        if (javaProject != null) {
            project = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(javaProject));
        }
        project = this.getJavaProject();
        String cuName = null;
        String className = qualifiedJavaClassName;
        int innerClassSeparater = qualifiedJavaClassName.indexOf(36);
        if (innerClassSeparater > -1) {
            className = qualifiedJavaClassName.substring(0, innerClassSeparater);
        } else if (qualifiedJavaClassName.endsWith(".java")) {
            className = qualifiedJavaClassName.substring(0, qualifiedJavaClassName.length() - 5);
        }
        if (className.indexOf(46) > -1) {
            cuName = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        cuName = String.valueOf(cuName) + ".java";
        int line = 1;
        if (lineNumber != null) {
            line = Integer.parseInt(lineNumber);
        }
        try {
            this.openCompilationUnitAtLine(project, cuName, className, line);
        }
        catch (Exception e) {
            UiPlugin.logError(e);
        }
    }

    private void openCompilationUnitAtLine(IJavaProject javaProject, String cuName, String className, int line) throws CoreException {
        IJavaElement javaElement = org.eclipse.hyades.test.core.util.JavaUtil.findElement((IJavaProject)javaProject, (String)cuName, (String)className);
        if (javaElement != null) {
            JavaUtil.revealJavaElementAtLine((IJavaElement)javaElement, (int)line);
        }
    }

    private IJavaProject getJavaProject() {
        IFile file;
        if (this.executionEvent != null && (file = EMFUtil.getWorkspaceFile((EObject)this.executionEvent)) != null) {
            return JavaCore.create((IProject)file.getProject());
        }
        return null;
    }
}

