/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.actions.VerdictNavigationAction;
import org.eclipse.hyades.test.ui.forms.base.IVerdictTypeSelectionListener;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class VerdictTypesPullDownAction
extends Action
implements IWorkbenchWindowPulldownDelegate2,
IMenuCreator {
    private Menu fCreatedMenu;
    private ITestLogVerdictTraversal verdictCollection;
    private VerdictTypeAction[] verdictTypeActions;
    private StructuredViewer viewer;
    public static final int VERDICT_TYPE_ALL = 4;
    private int verdictType = 4;
    private ListenerList verdictTypeSelectionListeners = new ListenerList();

    public VerdictTypesPullDownAction(ITestLogVerdictTraversal collection, StructuredViewer structuredViewer) {
        this.setMenuCreator(this);
        this.verdictCollection = collection;
        this.viewer = structuredViewer;
        this.setToolTipText(UiPluginResourceBundle.TestLogViewer_SelectNavigationVerdictType);
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdict_obj.gif"));
    }

    public void addVerdictTypeSelectionListener(IVerdictTypeSelectionListener listener) {
        this.verdictTypeSelectionListeners.add((Object)listener);
    }

    public void removeVerdictTypeSelectionListener(IVerdictTypeSelectionListener listener) {
        this.verdictTypeSelectionListeners.remove((Object)listener);
    }

    protected void fireVerdictTypeChanged(int type) {
        Object[] listeners = this.verdictTypeSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IVerdictTypeSelectionListener)listeners[i]).verdictTypeSelected(type);
            ++i;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fCreatedMenu == null) {
            this.fCreatedMenu = new Menu(parent);
            this.fillMenu(this.fCreatedMenu);
        }
        return this.fCreatedMenu;
    }

    private void fillMenu(Menu parent) {
        Action[] actions = this.createVerdictTypeActions(parent);
        int i = 0;
        while (i < actions.length) {
            ActionContributionItem item = new ActionContributionItem((IAction)actions[i]);
            item.fill(parent, -1);
            ++i;
        }
    }

    protected Action[] createVerdictTypeActions(Menu parent) {
        if (this.verdictTypeActions == null) {
            ArrayList<VerdictTypeAction> actions = new ArrayList<VerdictTypeAction>();
            if (this.verdictCollection.getFirst(TPFVerdict.ERROR_LITERAL.getValue()) != null) {
                VerdictTypeAction errorAction = new VerdictTypeAction(TPFVerdict.ERROR_LITERAL.getValue(), TPFVerdict.ERROR_LITERAL.getLabel(), 1);
                errorAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdicterror_obj.gif"));
                actions.add(errorAction);
            }
            if (this.verdictCollection.getFirst(TPFVerdict.FAIL_LITERAL.getValue()) != null) {
                VerdictTypeAction failAction = new VerdictTypeAction(TPFVerdict.FAIL_LITERAL.getValue(), TPFVerdict.FAIL_LITERAL.getLabel(), 1);
                failAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdictfail_obj.gif"));
                actions.add(failAction);
            }
            if (this.verdictCollection.getFirst(TPFVerdict.INCONCLUSIVE_LITERAL.getValue()) != null) {
                VerdictTypeAction inclAction = new VerdictTypeAction(TPFVerdict.INCONCLUSIVE_LITERAL.getValue(), TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), 1);
                inclAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdictinc_obj.gif"));
                actions.add(inclAction);
            }
            if (this.verdictCollection.getFirst(TPFVerdict.PASS_LITERAL.getValue()) != null) {
                VerdictTypeAction passAction = new VerdictTypeAction(TPFVerdict.PASS_LITERAL.getValue(), TPFVerdict.PASS_LITERAL.getLabel(), 1);
                passAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdictpass_obj.gif"));
                actions.add(passAction);
            }
            VerdictTypeAction allVerdictAction = new VerdictTypeAction(4, UiPluginResourceBundle.W_ALL, 1);
            allVerdictAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("eveverdict_obj.gif"));
            this.verdictType = 4;
            actions.add(allVerdictAction);
            this.verdictTypeActions = actions.toArray(new VerdictTypeAction[actions.size()]);
        }
        return this.verdictTypeActions;
    }

    public void dispose() {
        if (this.fCreatedMenu != null && !this.fCreatedMenu.isDisposed()) {
            this.fCreatedMenu.dispose();
            this.fCreatedMenu = null;
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        TPFVerdictEvent event = this.verdictCollection.getFirst(this.getCurrentVerdictType());
        if (event != null) {
            VerdictNavigationAction.revealEvent(event, (TreeViewer)this.getStructuredViewer());
        }
    }

    public void run(IAction action) {
        int newVerdictType = ((VerdictTypeAction)action).getVerdictType();
        if (newVerdictType != this.verdictType) {
            this.selectVerdcitType(newVerdictType);
            this.run();
        }
    }

    public void selectVerdcitType(int verdictType) {
        this.fireVerdictTypeChanged(verdictType);
        int i = 0;
        while (i < this.verdictTypeActions.length) {
            VerdictTypeAction action = this.verdictTypeActions[i];
            if (action.getVerdictType() == verdictType) {
                this.verdictType = verdictType;
                this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("non_ver.gif"));
                this.setImageDescriptor(action.getImageDescriptor());
            }
            ++i;
        }
    }

    public int getCurrentVerdictType() {
        return this.verdictType;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public StructuredViewer getStructuredViewer() {
        return this.viewer;
    }

    public void setStructuredViewer(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    private class VerdictTypeAction
    extends Action {
        private int type;

        public VerdictTypeAction(int verdictType, String text, int style) {
            super(text, style);
            this.type = verdictType;
        }

        public void run() {
            VerdictTypesPullDownAction.this.run((IAction)this);
        }

        public int getVerdictType() {
            return this.type;
        }
    }
}

