/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNDefaultProperty;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.extensions.IPropertyLabelProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRecordRepositoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRepositoryRecordListener;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TestLogExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ExecutionEventDetailsPart
extends AbstractFormPart
implements IDetailsPage,
IHyperlinkListener,
SelectionListener,
IRepositoryRecordListener {
    private FormPage editorPage;
    private Composite parent;
    protected Section commonPropSection;
    protected Section extendedPropSection;
    private IRecordRepositoryProvider[] defectProviders;
    private Text timeText;
    private Hyperlink modelElementLink;
    protected Control messageText;
    private Table propertiesTable;
    private Table attachmentsTable = null;
    private Button attachmentsOpenButton = null;
    private Button attachmentsSaveButton = null;
    private static final String HTML_TAG_START = "<html>";
    private static final String HTML_TAG_END = "</html>";
    private static final String HTML_TAG_ANCHOR_START = "<a ";
    private static final String HTML_ATTR_HREF = " href";
    private static final String HTML_ATTR_TARGET = " target";
    private static final String HTML_ATTR_TARGET_BLANK = "target=\"_blank\" ";
    private static final String HTML_ATTR_TARGET_SELF = "target=\"_self\" ";
    private TPFExecutionEvent executionEvent;

    public ExecutionEventDetailsPart() {
    }

    public ExecutionEventDetailsPart(FormPage page) {
        this.editorPage = page;
    }

    public void initialize(IManagedForm mForm) {
        super.initialize(mForm);
    }

    public void setFormPage(FormPage page) {
        this.editorPage = page;
    }

    public FormPage getFormPage() {
        return this.editorPage;
    }

    public void createContents(Composite parent) {
        EObject input;
        if (parent == this.parent) {
            return;
        }
        if (this.parent == null) {
            this.getManagedForm().addPart((IFormPart)this);
        }
        this.parent = parent;
        this.disposeContent();
        this.commonPropSection = FormsUtil.createSection(this.getManagedForm(), parent, UiPluginResourceBundle.TTL_PROPERTIES, "");
        Composite commonSectionClient = (Composite)this.commonPropSection.getClient();
        this.createCommonContents(commonSectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(commonSectionClient);
        if (this.editorPage.getEditor() instanceof TestLogViewer && (input = ((TestLogViewer)this.editorPage.getEditor()).getEditorObject()) instanceof TPFExecutionResult) {
            try {
                this.defectProviders = this.createDefectSectionFromExtension(((TPFExecutionResult)input).getType(), parent);
            }
            catch (Throwable t) {
                UiPlugin.logError(t);
            }
        }
        this.extendedPropSection = FormsUtil.createSection(this.getManagedForm(), parent, UiPluginResourceBundle.TTL_EXT_PROPERTIES, "");
        Composite extendedSectionClient = (Composite)this.extendedPropSection.getClient();
        this.createExtendedContents(extendedSectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(extendedSectionClient);
    }

    protected void createCommonContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.createModelElementHyperlink(parent, toolkit);
        this.createDetailsContents(parent);
        this.createTimeText(parent, toolkit);
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_TEXT);
        toolkit.paintBordersFor(parent);
    }

    protected IRecordRepositoryProvider[] createDefectSectionFromExtension(String testType, Composite parent) {
        IRecordRepositoryProvider[] providers = new IRecordRepositoryProvider[]{};
        TestLogExtensionsManager.DefectProviderExtension[] extensions = TestLogExtensionsManager.getInstance().getDefectProviderExtensions();
        if (extensions == null || extensions.length == 0) {
            return providers;
        }
        String[] disabledProviders = new String[]{};
        if (testType != null) {
            disabledProviders = TestLogExtensionsManager.getInstance().getDisabledProviders(testType);
        }
        ArrayList<IRecordRepositoryProvider> providerList = new ArrayList<IRecordRepositoryProvider>();
        int i = 0;
        while (i < extensions.length) {
            if (!Arrays.asList(disabledProviders).contains(extensions[i].getType())) {
                IRecordRepositoryProvider provider = extensions[i].getProvider(true);
                provider.createContent(this.getManagedForm(), parent);
                provider.addRecordListener(this);
                providerList.add(provider);
            }
            ++i;
        }
        providers = providerList.toArray(new IRecordRepositoryProvider[providerList.size()]);
        return providers;
    }

    private void createModelElementHyperlink(Composite parent, FormToolkit toolkit) {
        this.modelElementLink = toolkit.createHyperlink(parent, "", 64);
        this.modelElementLink.addHyperlinkListener((IHyperlinkListener)this);
        this.modelElementLink.setLayoutData((Object)new GridData());
        this.modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV);
        this.modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);
    }

    private void createTimeText(Composite parent, FormToolkit toolkit) {
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_TIME);
        this.timeText = toolkit.createText(parent, "", 65540);
        this.timeText.setLayoutData((Object)new GridData(768));
        this.timeText.setEditable(false);
    }

    protected void createDetailsContents(Composite parent) {
    }

    protected void createExtendedContents(Composite parent) {
        this.createPropertiesTable(parent, this.getManagedForm().getToolkit());
        this.createAttachmentTable(parent, this.getManagedForm().getToolkit());
    }

    protected void setMessageText(String text) {
        text = text == null ? "" : text;
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite messageTextParent = (Composite)this.commonPropSection.getClient();
        if (this.isHTMLString(text)) {
            String html = this.parseHTMLString(text);
            if (this.messageText == null || this.messageText.isDisposed() || !(this.messageText instanceof Browser)) {
                if (this.messageText != null) {
                    this.messageText.dispose();
                    this.messageText = null;
                }
                this.messageText = new Browser(messageTextParent, 0);
                this.messageText.setEnabled(true);
                GridData gd = new GridData(4, 4, true, true);
                gd.heightHint = 104;
                this.messageText.setLayoutData((Object)gd);
                this.messageText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                toolkit.adapt((Composite)((Browser)this.messageText));
                toolkit.paintBordersFor(messageTextParent);
            }
            ((Browser)this.messageText).setText(html);
        } else {
            String normalizedText = text.replace('\r', '\n');
            String processedText = TextProcessor.process((String)normalizedText);
            if (this.messageText == null || this.messageText.isDisposed() || !(this.messageText instanceof Text)) {
                if (this.messageText != null) {
                    this.messageText.dispose();
                    this.messageText = null;
                }
                this.messageText = toolkit.createText(messageTextParent, processedText, 576);
                this.messageText.setEnabled(true);
                ((Text)this.messageText).setEditable(false);
                GridData gd = new GridData(768);
                gd.heightHint = 8 * ((Text)this.messageText).getLineHeight();
                this.messageText.setLayoutData((Object)gd);
                toolkit.paintBordersFor(messageTextParent);
            }
            ((Text)this.messageText).setText(processedText);
        }
    }

    protected void createPropertiesTable(Composite parent, FormToolkit toolkit) {
        Composite propParent = toolkit.createComposite(parent);
        propParent.setLayoutData((Object)new GridData(770));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        propParent.setLayout((Layout)layout);
        this.getManagedForm().getToolkit().createLabel(propParent, UiPluginResourceBundle.LBL_PROPERTIES);
        this.propertiesTable = toolkit.createTable(propParent, 4);
        this.propertiesTable.setLinesVisible(true);
        this.propertiesTable.setHeaderVisible(true);
        this.propertiesTable.setLayoutData((Object)new GridData(1808));
        TableColumn nameColumn = new TableColumn(this.propertiesTable, 0);
        nameColumn.setText(UiPluginResourceBundle.Word_Name);
        nameColumn.setMoveable(true);
        nameColumn.setResizable(true);
        nameColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(this.propertiesTable, 0);
        valueColumn.setText(UiPluginResourceBundle.Word_Value);
        valueColumn.setMoveable(true);
        valueColumn.setResizable(true);
        valueColumn.setWidth(100);
        toolkit.paintBordersFor(propParent);
    }

    protected void createAttachmentTable(final Composite parent, FormToolkit toolkit) {
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_ATTACHMENTS);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 2;
        Composite attachmentsComposite = toolkit.createComposite(parent);
        attachmentsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        attachmentsComposite.setLayout((Layout)gridLayout);
        this.attachmentsTable = toolkit.createTable(attachmentsComposite, 772);
        this.attachmentsTable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.attachmentsTable.setHeaderVisible(true);
        this.attachmentsTable.setLinesVisible(true);
        Listener columnSorter = new Listener(){

            public void handleEvent(Event event) {
                TableItem[] rows = ExecutionEventDetailsPart.this.attachmentsTable.getItems();
                TableColumn selectedColumn = (TableColumn)event.widget;
                TableColumn sortColumn = ExecutionEventDetailsPart.this.attachmentsTable.getSortColumn();
                if (selectedColumn.equals(sortColumn)) {
                    List<TableItem> reversedRows = Arrays.asList(rows);
                    Collections.reverse(reversedRows);
                    int currentRowIndex = 0;
                    while (currentRowIndex < reversedRows.size()) {
                        TableItem oldRow = reversedRows.get(currentRowIndex);
                        Object data = oldRow.getData("FILE");
                        Image image = oldRow.getImage();
                        String[] text = new String[ExecutionEventDetailsPart.this.attachmentsTable.getColumnCount()];
                        int counter = 0;
                        while (counter < text.length) {
                            text[counter] = oldRow.getText(counter);
                            ++counter;
                        }
                        oldRow.dispose();
                        TableItem newRow = new TableItem(ExecutionEventDetailsPart.this.attachmentsTable, 16384, currentRowIndex);
                        newRow.setData("FILE", data);
                        newRow.setImage(image);
                        newRow.setText(text);
                        ++currentRowIndex;
                    }
                    if (ExecutionEventDetailsPart.this.attachmentsTable.getSortDirection() == 128) {
                        ExecutionEventDetailsPart.this.attachmentsTable.setSortDirection(1024);
                    } else {
                        ExecutionEventDetailsPart.this.attachmentsTable.setSortDirection(128);
                    }
                } else {
                    int selectedColumnIndex = Arrays.asList(ExecutionEventDetailsPart.this.attachmentsTable.getColumns()).indexOf(selectedColumn);
                    Collator collator = Collator.getInstance();
                    int currentRowIndex = 1;
                    while (currentRowIndex < rows.length) {
                        String currentRowCell = rows[currentRowIndex].getText(selectedColumnIndex);
                        int sampleRowIndex = 0;
                        while (sampleRowIndex < currentRowIndex) {
                            if (collator.compare(currentRowCell, rows[sampleRowIndex].getText(selectedColumnIndex)) < 0) {
                                Object data = rows[currentRowIndex].getData("FILE");
                                Image image = rows[currentRowIndex].getImage();
                                String[] text = new String[ExecutionEventDetailsPart.this.attachmentsTable.getColumnCount()];
                                int counter = 0;
                                while (counter < text.length) {
                                    text[counter] = rows[currentRowIndex].getText(counter);
                                    ++counter;
                                }
                                rows[currentRowIndex].dispose();
                                TableItem row = new TableItem(ExecutionEventDetailsPart.this.attachmentsTable, 16384, sampleRowIndex);
                                row.setData("FILE", data);
                                row.setImage(image);
                                row.setText(text);
                                rows = ExecutionEventDetailsPart.this.attachmentsTable.getItems();
                                break;
                            }
                            ++sampleRowIndex;
                        }
                        ++currentRowIndex;
                    }
                    ExecutionEventDetailsPart.this.attachmentsTable.setSortDirection(128);
                    ExecutionEventDetailsPart.this.attachmentsTable.setSortColumn(selectedColumn);
                }
            }
        };
        final TableColumn attachmentsNameTableColumn = new TableColumn(this.attachmentsTable, 16384);
        attachmentsNameTableColumn.setMoveable(true);
        attachmentsNameTableColumn.setResizable(true);
        attachmentsNameTableColumn.setText(UiPluginResourceBundle.LBL_ATTACHMENTS_NAME);
        attachmentsNameTableColumn.addListener(13, columnSorter);
        final TableColumn attachmentsSizeTableColumn = new TableColumn(this.attachmentsTable, 16384);
        attachmentsSizeTableColumn.setMoveable(true);
        attachmentsSizeTableColumn.setResizable(true);
        attachmentsSizeTableColumn.setText(UiPluginResourceBundle.LBL_ATTACHMENTS_SIZE);
        attachmentsSizeTableColumn.addListener(13, columnSorter);
        final TableColumn attachmentsTypeTableColumn = new TableColumn(this.attachmentsTable, 16384);
        attachmentsTypeTableColumn.setMoveable(true);
        attachmentsTypeTableColumn.setResizable(true);
        attachmentsTypeTableColumn.setText(UiPluginResourceBundle.LBL_ATTACHMENTS_TYPE);
        attachmentsTypeTableColumn.setWidth(100);
        attachmentsTypeTableColumn.addListener(13, columnSorter);
        this.attachmentsTable.setSortDirection(128);
        this.attachmentsTable.setSortColumn(attachmentsNameTableColumn);
        this.attachmentsTable.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                int tableWidth = ((ExecutionEventDetailsPart)ExecutionEventDetailsPart.this).attachmentsTable.getClientArea().width;
                attachmentsNameTableColumn.setWidth((int)((double)tableWidth * 0.5));
                attachmentsSizeTableColumn.setWidth((int)((double)tableWidth * 0.2));
                attachmentsTypeTableColumn.setWidth(tableWidth - (attachmentsNameTableColumn.getWidth() + attachmentsSizeTableColumn.getWidth()));
                ExecutionEventDetailsPart.this.attachmentsTable.removeListener(9, (Listener)this);
            }
        });
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        Composite attachmentsButtonComposite = toolkit.createComposite(attachmentsComposite);
        attachmentsButtonComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        attachmentsButtonComposite.setLayout((Layout)gridLayout);
        this.attachmentsOpenButton = toolkit.createButton(attachmentsButtonComposite, UiPluginResourceBundle.LBL_ATTACHMENTS_OPEN, 8);
        this.attachmentsOpenButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.attachmentsSaveButton = toolkit.createButton(attachmentsButtonComposite, UiPluginResourceBundle.LBL_ATTACHMENTS_SAVE_AS, 8);
        this.attachmentsSaveButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.attachmentsOpenButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ExecutionEventDetailsPart.this.attachmentsTable.getSelectionCount() > 0) {
                    TableItem[] attachmnets = ExecutionEventDetailsPart.this.attachmentsTable.getSelection();
                    int counter = 0;
                    while (counter < attachmnets.length) {
                        Program.launch((String)((File)attachmnets[counter].getData("FILE")).getAbsolutePath());
                        ++counter;
                    }
                    ExecutionEventDetailsPart.this.attachmentsTable.deselect(ExecutionEventDetailsPart.this.attachmentsTable.getSelectionIndices());
                }
                ExecutionEventDetailsPart.this.attachmentsOpenButton.setEnabled(false);
                ExecutionEventDetailsPart.this.attachmentsSaveButton.setEnabled(false);
            }
        });
        this.attachmentsSaveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ExecutionEventDetailsPart.this.attachmentsTable.getSelectionCount() > 0) {
                    TableItem[] attachmnets = ExecutionEventDetailsPart.this.attachmentsTable.getSelection();
                    int counter = 0;
                    while (counter < attachmnets.length) {
                        block28: {
                            FileDialog fileDialog = new FileDialog(parent.getShell(), 73732);
                            fileDialog.setFileName(attachmnets[counter].getText(0));
                            fileDialog.setFilterExtensions(new String[]{"*.*"});
                            fileDialog.setFilterNames(new String[]{UiPluginResourceBundle.ATTACHMENTS_TABLE_GROUP_SAVE_FILE_DIALOG_FILTER_NAMES});
                            File newFile = null;
                            while (fileDialog.open() != null) {
                                newFile = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                                if (!newFile.exists()) break;
                                MessageBox messageBox = new MessageBox(parent.getShell(), 65569);
                                messageBox.setText(UiPluginResourceBundle.W_ERROR);
                                messageBox.setMessage(NLS.bind((String)UiPluginResourceBundle.LBL_ATTACHMENTS_SAVE_NEW_ERR_MSG, (Object[])new String[]{newFile.getName(), newFile.getParentFile().getAbsolutePath()}));
                                messageBox.open();
                            }
                            if (newFile != null) {
                                FileInputStream fileInputStream = null;
                                FileOutputStream fileOutputStream = null;
                                try {
                                    try {
                                        newFile.createNewFile();
                                        fileInputStream = new FileInputStream((File)attachmnets[counter].getData("FILE"));
                                        fileOutputStream = new FileOutputStream(newFile);
                                        byte[] buffer = new byte[1024];
                                        int bufferLength = 0;
                                        while ((bufferLength = fileInputStream.read(buffer)) != -1) {
                                            fileOutputStream.write(buffer, 0, bufferLength);
                                        }
                                    }
                                    catch (Throwable t) {
                                        MessageBox messageBox = new MessageBox(parent.getShell(), 65569);
                                        messageBox.setText(UiPluginResourceBundle.W_ERROR);
                                        messageBox.setMessage(NLS.bind((String)UiPluginResourceBundle.LBL_ATTACHMENTS_SAVE_WRITE_ERR_MSG, (Object[])new String[]{newFile.getName(), newFile.getParentFile().getAbsolutePath(), t.getLocalizedMessage()}));
                                        messageBox.open();
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (fileOutputStream != null) {
                                            try {
                                                fileOutputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block28;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fileInputStream != null) {
                                        try {
                                            fileInputStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (fileOutputStream != null) {
                                        try {
                                            fileOutputStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        ++counter;
                    }
                    ExecutionEventDetailsPart.this.attachmentsTable.deselect(ExecutionEventDetailsPart.this.attachmentsTable.getSelectionIndices());
                }
                ExecutionEventDetailsPart.this.attachmentsOpenButton.setEnabled(false);
                ExecutionEventDetailsPart.this.attachmentsSaveButton.setEnabled(false);
            }
        });
        this.attachmentsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEventDetailsPart.this.attachmentsOpenButton.setEnabled(ExecutionEventDetailsPart.this.attachmentsTable.getSelectionCount() > 0);
                ExecutionEventDetailsPart.this.attachmentsSaveButton.setEnabled(ExecutionEventDetailsPart.this.attachmentsTable.getSelectionCount() > 0);
            }
        });
        toolkit.paintBordersFor(attachmentsButtonComposite);
        toolkit.paintBordersFor(attachmentsComposite);
    }

    public void commit(boolean onSave) {
        if (onSave) {
            super.commit(onSave);
        }
    }

    protected void updateCommonSectionState(Section commonSection) {
        Composite commonSectionClient = (Composite)commonSection.getClient();
        commonSectionClient.getParent().layout(true);
        commonSectionClient.getParent().getParent().layout(true);
    }

    protected void updateExtendedSectionState(Section extendedSection) {
        if (this.propertiesTable.getItemCount() == 0 && this.attachmentsTable.getItemCount() == 0) {
            extendedSection.setExpanded(false);
        } else {
            extendedSection.setExpanded(true);
        }
    }

    public void dispose() {
        this.getManagedForm().removePart((IFormPart)this);
        super.dispose();
        this.disposeContent();
    }

    protected void disposeContent() {
        Composite client;
        if (this.commonPropSection != null && !this.commonPropSection.isDisposed()) {
            client = (Composite)this.commonPropSection.getClient();
            client.dispose();
            this.timeText = null;
            this.messageText = null;
            this.modelElementLink = null;
            this.commonPropSection.dispose();
            this.commonPropSection = null;
        }
        if (this.extendedPropSection != null && !this.extendedPropSection.isDisposed()) {
            client = (Composite)this.extendedPropSection.getClient();
            client.dispose();
            this.propertiesTable = null;
            this.attachmentsTable = null;
            this.extendedPropSection.dispose();
            this.extendedPropSection = null;
        }
        this.executionEvent = null;
    }

    protected TPFExecutionEvent getExecutionEvent() {
        return this.executionEvent;
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    protected void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.executionEvent = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof TPFExecutionEvent) {
            BVRInteractionFragment interactionFragment;
            this.executionEvent = (TPFExecutionEvent)object;
            this.timeText.setText(EventUtil.getTime(this.getExecutionEvent().getTimestamp()));
            String value = this.getExecutionEvent().getText();
            this.setMessageText(value);
            this.modelElementLink.setVisible(true);
            TPFTest test = null;
            if (this.executionEvent.getExecutionHistory() != null && this.executionEvent.getExecutionHistory().getExecutionResult() != null) {
                test = this.executionEvent.getExecutionHistory().getExecutionResult().getTest();
            }
            if ((interactionFragment = this.executionEvent.getInteractionFragment()) != null && interactionFragment.eResource() != null) {
                if (interactionFragment.getName() != null) {
                    this.modelElementLink.setText(interactionFragment.getName());
                    this.modelElementLink.setToolTipText(interactionFragment.getName());
                } else {
                    this.modelElementLink.setText(UiPluginResourceBundle.W_ELEMENT);
                    this.modelElementLink.setToolTipText(UiPluginResourceBundle.W_ELEMENT);
                }
                this.modelElementLink.setData((Object)this.executionEvent);
            } else if (test != null && test.eResource() != null) {
                if (test.getName() != null) {
                    this.modelElementLink.setText(test.getName());
                    this.modelElementLink.setToolTipText(test.getName());
                } else {
                    this.modelElementLink.setText(UiPluginResourceBundle.W_TEST);
                    this.modelElementLink.setToolTipText(UiPluginResourceBundle.W_TEST);
                }
                this.modelElementLink.setData((Object)this.executionEvent.getExecutionHistory().getExecutionResult());
            } else {
                this.modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV);
                this.modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);
                this.modelElementLink.setData(null);
            }
            this.setPropertiesInput(this.executionEvent);
            this.setAttachmentsInput(this.executionEvent);
        } else {
            this.timeText.setText("");
            this.setMessageText("");
            this.modelElementLink.setVisible(false);
        }
        if (this.defectProviders != null) {
            int i = 0;
            while (i < this.defectProviders.length) {
                this.defectProviders[i].setInput(this.executionEvent);
                ++i;
            }
        }
        this.updateCommonSectionState(this.commonPropSection);
        this.updateExtendedSectionState(this.extendedPropSection);
    }

    private void setPropertiesInput(TPFExecutionEvent event) {
        if (this.propertiesTable == null || this.propertiesTable.isDisposed()) {
            return;
        }
        this.propertiesTable.removeAll();
        EList properties = event.getProperties();
        if (properties != null && !properties.isEmpty()) {
            String eventType = event.getEventType();
            for (Object obj : properties) {
                ExecutionHistoryExtensionsManager.Property prop;
                if (!(obj instanceof CMNExtendedProperty)) continue;
                String name = ((CMNExtendedProperty)obj).getName();
                String value = ((CMNExtendedProperty)obj).getValue();
                String string = value = value == null ? "" : value;
                if (eventType != null && name != null && (prop = ExecutionHistoryExtensionsManager.getInstance().getEventProperty(eventType, name)) != null) {
                    if (!prop.isVisible() || value.equals(prop.getVisibleUnless())) continue;
                    IPropertyLabelProvider provider = prop.getProvider();
                    if (provider != null) {
                        name = provider.getName((CMNDefaultProperty)((CMNExtendedProperty)obj)) == null ? name : provider.getName((CMNDefaultProperty)((CMNExtendedProperty)obj));
                        String string2 = value = provider.getValue((CMNDefaultProperty)((CMNExtendedProperty)obj)) == null ? value : provider.getValue((CMNDefaultProperty)((CMNExtendedProperty)obj));
                    }
                    if (prop.getUnit() != null) {
                        value = value.concat(" ").concat(prop.getUnit());
                    }
                }
                TableItem item = new TableItem(this.propertiesTable, 0);
                item.setText(new String[]{name, value});
            }
            this.propertiesTable.update();
            this.getManagedForm().getToolkit().paintBordersFor(this.propertiesTable.getParent());
        }
    }

    protected void setAttachmentsInput(TPFExecutionEvent event) {
        this.attachmentsTable.removeAll();
        this.attachmentsOpenButton.setEnabled(false);
        this.attachmentsSaveButton.setEnabled(false);
        for (CMNAnnotation annotation : event.getAnnotations()) {
            try {
                File file = new File(annotation.getFileAnnotation().toFileString());
                String fileName = file.getName().trim();
                int lastDotIndex = fileName.lastIndexOf(46);
                String fileExtension = "";
                if (lastDotIndex != -1) {
                    fileExtension = fileName.substring(lastDotIndex + 1);
                }
                Program program = Program.findProgram((String)fileExtension);
                ImageData icon = null;
                String programName = null;
                if (program != null) {
                    icon = program.getImageData();
                    programName = program.getName().trim();
                }
                Image image = null;
                String[] cells = new String[3];
                image = icon != null ? new Image((Device)Display.getCurrent(), icon) : TestUIImages.INSTANCE.getImage("file_obj.gif");
                cells[0] = fileName;
                cells[1] = file.length() > 0L ? NumberFormat.getIntegerInstance().format(Math.max(Math.round((double)file.length() / 1024.0), 1L)).concat(" KB") : "0 KB";
                cells[2] = icon != null && programName.trim().length() > 0 ? programName : fileExtension.toUpperCase().concat(" File").trim();
                int newRowIndex = this.attachmentsTable.getItemCount();
                if (newRowIndex > 0 && this.attachmentsTable.getSortDirection() != 0) {
                    int counter;
                    TableItem[] rows = this.attachmentsTable.getItems();
                    int sortColumnIndex = Arrays.asList(this.attachmentsTable.getColumns()).indexOf(this.attachmentsTable.getSortColumn());
                    Collator collator = Collator.getInstance();
                    if (this.attachmentsTable.getSortDirection() == 128) {
                        counter = 0;
                        while (counter < rows.length) {
                            if (collator.compare(cells[sortColumnIndex], rows[counter].getText(sortColumnIndex)) < 0) {
                                newRowIndex = counter;
                                break;
                            }
                            ++counter;
                        }
                    } else {
                        counter = 0;
                        while (counter < rows.length) {
                            if (collator.compare(cells[sortColumnIndex], rows[counter].getText(sortColumnIndex)) > 0) {
                                newRowIndex = counter;
                                break;
                            }
                            ++counter;
                        }
                    }
                }
                TableItem fileTableItem = new TableItem(this.attachmentsTable, 0, newRowIndex);
                fileTableItem.setData("FILE", (Object)file);
                fileTableItem.setImage(image);
                fileTableItem.setText(cells);
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isHTMLString(String text) {
        if (text == null) {
            return false;
        }
        int length = text.length();
        return length > "<html></html>".length() && HTML_TAG_START.compareToIgnoreCase(text.substring(0, HTML_TAG_START.length())) == 0 && HTML_TAG_END.compareToIgnoreCase(text.substring(length - HTML_TAG_END.length(), length)) == 0;
    }

    protected String parseHTMLString(String html) {
        if (!this.isHTMLString(html)) {
            return html;
        }
        int anchorStart = html.indexOf(HTML_TAG_ANCHOR_START);
        while (anchorStart > -1) {
            int anchorEnd = html.indexOf(62, anchorStart);
            int href = html.indexOf(HTML_ATTR_HREF, anchorStart);
            if (href > -1) {
                String anchor = html.substring(anchorStart, anchorEnd);
                if (anchor.indexOf(HTML_ATTR_TARGET) == -1) {
                    int insertIndex = anchorStart + HTML_TAG_ANCHOR_START.length();
                    html = String.valueOf(html.substring(0, insertIndex)) + HTML_ATTR_TARGET_BLANK + html.substring(insertIndex, html.length());
                } else if (anchor.indexOf(HTML_ATTR_TARGET_SELF) > -1) {
                    html = String.valueOf(html.substring(0, anchorStart)) + anchor.replaceAll(HTML_ATTR_TARGET_SELF, HTML_ATTR_TARGET_BLANK) + html.substring(anchorEnd, html.length());
                }
            }
            anchorStart = html.indexOf(HTML_TAG_ANCHOR_START, anchorEnd);
        }
        return html;
    }

    public void setFocus() {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty()) {
            this.setInput(sel.getFirstElement());
        }
    }

    public void linkActivated(HyperlinkEvent e) {
        Object data;
        if (e.widget == this.modelElementLink && (data = this.modelElementLink.getData()) != null) {
            if (data instanceof TPFExecutionEvent) {
                data = ((TPFExecutionEvent)data).getInteractionFragment();
            } else if (data instanceof TPFExecutionResult) {
                data = ((TPFExecutionResult)data).getTest();
            }
            EObject eObject = (EObject)data;
            Resource resource = eObject.eResource();
            IEditorPart editorPart = TestUIUtil.openEditor(resource, null, false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.editorPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IActionBars actionBars = this.editorPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(this.modelElementLink.getText());
        }
    }

    public void linkExited(HyperlinkEvent e) {
        IActionBars actionBars = this.editorPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void recordAdded(TPFRepositoryRecord record) {
        if (this.executionEvent != null && !this.executionEvent.getDefectRecords().contains((Object)record)) {
            this.executionEvent.getDefectRecords().add((Object)record);
            TPFExecutionResult result = this.getRootExecutionResult(this.executionEvent);
            if (result != null && !result.getRecords().contains((Object)record)) {
                result.getRecords().add((Object)record);
            }
            this.markDirty();
        }
    }

    public void recordRemoved(TPFRepositoryRecord record) {
        if (this.executionEvent != null && this.executionEvent.getDefectRecords().contains((Object)record)) {
            this.executionEvent.getDefectRecords().remove((Object)record);
            TPFExecutionResult result = this.getRootExecutionResult(this.executionEvent);
            if (result != null && result.getRecords().contains((Object)record)) {
                result.getRecords().remove((Object)record);
            }
            this.markDirty();
        }
    }

    protected Hyperlink getModelElementLink() {
        return this.modelElementLink;
    }

    private TPFExecutionResult getRootExecutionResult(TPFExecutionEvent event) {
        EObject container = event.eContainer();
        if (container != null) {
            while (container.eContainer() != null) {
                container = container.eContainer();
            }
        }
        if (container instanceof TPFExecutionResult) {
            return (TPFExecutionResult)container;
        }
        return null;
    }
}

