/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionResultDetailsPart
implements IDetailsPage,
IHyperlinkListener {
    protected FormPage formPage;
    protected IManagedForm mForm;
    protected FormToolkit toolkit;
    private Composite testComposite;
    private ImageHyperlink testLink;
    private FormText testType;
    private FormText testFile;
    private FormText hostname;
    private ImageHyperlink deploymentLink;
    private ImageHyperlink locationLink;
    private Text verdictText;
    private Text startText;
    private Text stopText;

    public ExecutionResultDetailsPart() {
    }

    public ExecutionResultDetailsPart(FormPage page) {
        this.formPage = page;
    }

    public void initialize(IManagedForm form) {
        this.mForm = form;
        this.toolkit = form.getToolkit();
    }

    public void setFormPage(FormPage page) {
        this.formPage = page;
    }

    public FormPage getFormPage() {
        return this.formPage;
    }

    public void createContents(Composite parent) {
        this.createCommonPropSection(parent);
        this.mForm.addPart((IFormPart)this);
    }

    protected void createCommonPropSection(Composite parent) {
        Section detailsSection = FormsUtil.createSection(this.mForm, parent, UiPluginResourceBundle.TTL_CMN_PROPS, "");
        Composite client = (Composite)detailsSection.getClient();
        Composite verdictComposite = this.toolkit.createComposite(client);
        verdictComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        verdictComposite.setLayout((Layout)layout);
        Label label = this.toolkit.createLabel(verdictComposite, UiPluginResourceBundle.LBL_VERD);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.verdictText = this.toolkit.createText(verdictComposite, "", 65540);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.verdictText.setLayoutData((Object)gd);
        this.verdictText.setEditable(false);
        label = this.toolkit.createLabel(verdictComposite, UiPluginResourceBundle.LBL_START);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.startText = this.toolkit.createText(verdictComposite, "", 65540);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.startText.setLayoutData((Object)gd);
        this.startText.setEditable(false);
        label = this.toolkit.createLabel(verdictComposite, UiPluginResourceBundle.LBL_STOP);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.stopText = this.toolkit.createText(verdictComposite, "", 65540);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.stopText.setLayoutData((Object)gd);
        this.stopText.setEditable(false);
        this.toolkit.paintBordersFor(verdictComposite);
        this.createTestDetails(client);
        this.toolkit.paintBordersFor(client);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty()) {
            this.setFormInput(sel.getFirstElement());
        }
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.setFormInput(this.formPage.getManagedForm().getInput());
    }

    public void setFocus() {
    }

    protected void createTestDetails(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 10;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.testComposite = this.toolkit.createComposite(parent);
        this.testComposite.setLayoutData((Object)new GridData(768));
        this.testComposite.setLayout((Layout)layout);
        this.testLink = this.toolkit.createImageHyperlink(this.testComposite, 64);
        this.testLink.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        this.testLink.setText(UiPluginResourceBundle.NO_TST_TO_INV);
        this.testLink.addHyperlinkListener((IHyperlinkListener)this);
        this.testLink.setLayoutData((Object)gridData);
        FormText typeLabel = this.toolkit.createFormText(this.testComposite, false);
        typeLabel.setText(UiPluginResourceBundle.L_TYPE, false, false);
        typeLabel.setLayoutData((Object)new GridData());
        this.testType = this.toolkit.createFormText(this.testComposite, false);
        this.testType.setLayoutData((Object)new GridData(768));
        FormText fileLabel = this.toolkit.createFormText(this.testComposite, false);
        fileLabel.setText(UiPluginResourceBundle.L_FILE, false, false);
        fileLabel.setLayoutData((Object)new GridData());
        this.testFile = this.toolkit.createFormText(this.testComposite, false);
        this.testFile.setLayoutData((Object)new GridData(768));
        FormText hostnameLabel = this.toolkit.createFormText(this.testComposite, false);
        hostnameLabel.setText(UiPluginResourceBundle.LBL_HOST_COLON, false, false);
        hostnameLabel.setLayoutData((Object)new GridData());
        this.hostname = this.toolkit.createFormText(this.testComposite, false);
        this.hostname.setText("localhost", false, false);
        this.hostname.setLayoutData((Object)new GridData(768));
        this.toolkit.paintBordersFor(this.testComposite);
    }

    protected void createDeploymentLinks(Composite parent, TPFDeployment deployment, TPFTestSuite test) {
        if (deployment != null && test != null) {
            if (deployment.eResource() != null) {
                if (this.deploymentLink == null || this.deploymentLink.isDisposed()) {
                    this.toolkit.createLabel(parent, UiPluginResourceBundle.L_DEPLOYMENT);
                    this.deploymentLink = this.toolkit.createImageHyperlink(parent, 64);
                    this.deploymentLink.setImage(TestUIImages.INSTANCE.getImage("deployment_obj.gif"));
                    this.deploymentLink.setText(deployment.getName());
                    this.deploymentLink.setToolTipText(UiPluginResourceBundle.TIP_DEPLOYMENT_USED);
                    this.deploymentLink.addHyperlinkListener((IHyperlinkListener)this);
                }
                this.deploymentLink.setData((Object)deployment);
            }
            CFGLocation location = null;
            location = ConfigurationUtil.isDefaultLocation((TPFDeployment)deployment) ? ConfigurationUtil.getDefaultLocation((TPFDeployment)deployment) : ConfigurationUtil.searchLocationWithTestAsset((CFGClass)test, (TPFDeployment)deployment);
            if (location != null && location.eResource() != null) {
                if (this.locationLink == null || this.locationLink.isDisposed()) {
                    this.toolkit.createLabel(parent, UiPluginResourceBundle.L_LOCATION);
                    this.locationLink = this.toolkit.createImageHyperlink(parent, 64);
                    this.locationLink.setImage(TestUIImages.INSTANCE.getImage("location_obj.gif"));
                    this.locationLink.setText(location.getName());
                    this.locationLink.setToolTipText(UiPluginResourceBundle.TIP_LOCATION_USED);
                    this.locationLink.addHyperlinkListener((IHyperlinkListener)this);
                }
                this.locationLink.setData((Object)location);
                if (location instanceof CMNNodeType) {
                    this.hostname.setText(((CMNNodeType)location).getHostname(), false, false);
                }
            }
        }
    }

    public boolean setFormInput(Object input) {
        IStructuredSelection structuredSelection;
        if (input instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)input).size() == 1) {
            input = structuredSelection.getFirstElement();
        }
        boolean doPack = false;
        if (input instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)input;
            TPFTest test = executionResult.getTest();
            doPack = true;
            if (test != null) {
                if (test.eResource() != null) {
                    IWorkbenchAdapter workbenchAdapter;
                    ImageDescriptor imageDescriptor = null;
                    if (test instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)test.getAdapter(IWorkbenchAdapter.class)) != null) {
                        imageDescriptor = workbenchAdapter.getImageDescriptor((Object)test);
                    }
                    if (imageDescriptor == null) {
                        imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                    }
                    this.testLink.setImage(imageDescriptor.createImage());
                    if (test.getName() != null) {
                        this.testLink.setText(test.getName());
                    } else {
                        this.testLink.setText(UiPluginResourceBundle.W_TEST);
                    }
                    this.testLink.setData((Object)executionResult);
                    TPFTestSuite testSuite = null;
                    testSuite = test instanceof TPFTestSuite ? (TPFTestSuite)test : ((TPFTestCase)test).getTestSuite();
                    if (testSuite != null) {
                        String value = testSuite.getType();
                        if (value != null) {
                            IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                            if (descriptor != null && descriptor.getName() != null) {
                                value = descriptor.getName();
                            }
                            this.testType.setText(value, false, false);
                        }
                        this.testFile.setText(EMFUtil.getFilePath((EObject)testSuite), false, false);
                    }
                } else {
                    this.testLink.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
                    this.testLink.setText(UiPluginResourceBundle.NO_TST_TO_INV);
                    this.testLink.setData(null);
                    this.testFile.setText("", false, false);
                    this.testType.setText("", false, false);
                }
                boolean noVerdict = true;
                TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery)((TestLogViewer)this.formPage.getEditor()).getTestLogVerdictTraversal();
                if (query.getCount(4) != 0) {
                    noVerdict = false;
                }
                if (noVerdict) {
                    this.verdictText.setText(UiPluginResourceBundle.LogOverview_NoVerdict);
                } else {
                    this.verdictText.setText(executionResult.getVerdict().getLabel());
                }
                this.startText.setText(EventUtil.getTime(EventUtil.getStartTimeStamp(executionResult)));
                this.stopText.setText(EventUtil.getTime(EventUtil.getStopTimeStamp(executionResult)));
                TPFDeployment deployment = executionResult.getDeployment();
                if (deployment != null && test instanceof TPFTestSuite) {
                    this.createDeploymentLinks(this.testComposite, deployment, (TPFTestSuite)test);
                }
            }
        } else {
            this.verdictText.setText(UiPluginResourceBundle.LogOverview_NoVerdict);
            this.startText.setText("");
            this.stopText.setText("");
        }
        if (doPack) {
            this.testLink.pack(true);
            this.testLink.redraw();
        }
        return true;
    }

    protected ImageHyperlink getTestLink() {
        return this.testLink;
    }

    public void linkActivated(HyperlinkEvent e) {
        Object data;
        TPFTest eObject = null;
        if (e.widget == this.testLink) {
            data = this.testLink.getData();
            if (data != null && data instanceof TPFExecutionResult) {
                eObject = ((TPFExecutionResult)data).getTest();
            }
        } else if (e.widget == this.deploymentLink) {
            data = this.deploymentLink.getData();
            if (data != null && data instanceof TPFDeployment) {
                eObject = (TPFDeployment)data;
            }
        } else if (e.widget == this.locationLink && (data = this.locationLink.getData()) != null && data instanceof CFGLocation) {
            eObject = (CFGLocation)data;
        }
        if (eObject != null) {
            IEditorPart editorPart = TestUIUtil.openEditor(eObject.eResource(), null, false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            if (e.widget == this.testLink) {
                manager.setMessage(this.testLink.getText());
            } else if (e.widget == this.deploymentLink) {
                manager.setMessage(this.deploymentLink.getText());
            } else if (e.widget == this.locationLink) {
                manager.setMessage(this.locationLink.getText());
            }
        }
    }

    public void linkExited(HyperlinkEvent e) {
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }
}

