/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralInfoSectionPart
extends AbstractFormPart
implements ModifyListener,
VerifyListener {
    private FormPage formPage;
    private Section section;
    private Text nameText;
    private Text descriptionText;
    private FormText fileText;

    public GeneralInfoSectionPart(FormPage page, Composite parent) {
        this.formPage = page;
        this.initialize(page.getManagedForm());
        this.createSection(page.getManagedForm(), parent);
    }

    protected void createSection(IManagedForm managedForm, Composite parent) {
        this.section = FormsUtil.createSection(managedForm, parent, UiPluginResourceBundle.EDT_GENERAL_INFO, UiPluginResourceBundle.LogOverview_OverviewDescription);
        Composite client = (Composite)this.section.getClient();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(client, UiPluginResourceBundle.LBL_NAME);
        this.nameText = toolkit.createText(client, "", 65536);
        this.nameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.nameText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.W_NAME;
            }
        });
        toolkit.createLabel(client, UiPluginResourceBundle.LBL_DESC);
        this.descriptionText = toolkit.createText(client, "", 66114);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.descriptionText.getLineHeight();
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.W_DESCRIPTION;
            }
        });
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite fileComposite = toolkit.createComposite(client);
        fileComposite.setLayoutData((Object)new GridData(768));
        fileComposite.setLayout((Layout)gridLayout);
        toolkit.createLabel(fileComposite, UiPluginResourceBundle.L_FILE);
        this.fileText = toolkit.createFormText(fileComposite, false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        toolkit.paintBordersFor(client);
        managedForm.addPart((IFormPart)this);
    }

    public Section getSection() {
        return this.section;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof CMNNamedElement) {
            CMNNamedElement namedElement = (CMNNamedElement)input;
            this.nameText.removeVerifyListener((VerifyListener)this);
            this.nameText.removeModifyListener((ModifyListener)this);
            this.nameText.setText(namedElement.getName());
            this.nameText.addModifyListener((ModifyListener)this);
            this.nameText.addVerifyListener((VerifyListener)this);
            this.descriptionText.removeVerifyListener((VerifyListener)this);
            this.descriptionText.removeModifyListener((ModifyListener)this);
            if (namedElement.getDescription() != null) {
                this.descriptionText.setText(namedElement.getDescription());
            }
            this.descriptionText.addModifyListener((ModifyListener)this);
            this.descriptionText.addVerifyListener((VerifyListener)this);
            this.fileText.setText(EMFUtil.getFilePath((EObject)namedElement), false, false);
            this.fileText.getParent().layout(true);
            return true;
        }
        return false;
    }

    public void verifyText(VerifyEvent verifyEvent) {
        verifyEvent.doit = !((BaseFormEditor)this.formPage.getEditor()).isReadOnly();
    }

    public void modifyText(ModifyEvent e) {
        CMNNamedElement editorObject = (CMNNamedElement)this.formPage.getManagedForm().getInput();
        if (e.widget == this.nameText) {
            String name = this.nameText.getText();
            if (editorObject != null) {
                editorObject.setName(name);
            }
            ((BaseFormEditor)this.formPage.getEditor()).setEditorTitle(name);
        } else if (e.widget == this.descriptionText) {
            String description = this.descriptionText.getText();
            if (editorObject != null) {
                editorObject.setDescription(description);
            }
        } else {
            return;
        }
        this.markDirty();
    }

    public void refresh() {
        super.refresh();
        this.setFormInput(this.formPage.getManagedForm().getInput());
    }
}

