/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.actions.CollapseTreeAction;
import org.eclipse.hyades.test.ui.forms.actions.ExpandTreeAction;
import org.eclipse.hyades.test.ui.forms.actions.TestLogSearchAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictFirstAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictLastAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictNavigationAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictNextAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictPreviousAction;
import org.eclipse.hyades.test.ui.forms.actions.VerdictTypesPullDownAction;
import org.eclipse.hyades.test.ui.forms.base.ExecutionEventDetailsProvider;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.extensions.IEventAction;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.hyades.test.ui.forms.util.TestLogEventsLazyPathContentProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Partition;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class LogEventsBlock
extends MasterDetailsBlock
implements ISelectionChangedListener,
SelectionListener,
IMenuListener {
    private FormPage formPage;
    private IManagedForm mForm;
    private SectionPart eventsSectionPart;
    private TreeViewer viewer;
    private ExecutionHistoryExtensionsManager.EventAction[] extensionActions;
    private Button[] extensionButtons;
    private ITestLogVerdictTraversal verdictCollection;
    private VerdictTypesPullDownAction verdictTypesAction;
    private VerdictNavigationAction firstVerdict;
    private VerdictNavigationAction prevVerdict;
    private VerdictNavigationAction nextVerdict;
    private VerdictNavigationAction lastVerdict;
    private CollapseTreeAction collapseAction;
    private ExpandTreeAction expandAction;
    private TestLogSearchAction testLogSearchAction;
    public static final int DETAILS_PAGE_CACHE_SIZE = 20;

    public LogEventsBlock(FormPage page) {
        this.formPage = page;
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        this.mForm = managedForm;
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = FormsUtil.createSection(managedForm, parent, UiPluginResourceBundle.W_EVENTS, "");
        Composite client = (Composite)section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        client.setLayout((Layout)layout);
        Tree tree = toolkit.createTree(client, 0x10010004);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 100;
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new TestLogEventsLazyPathContentProvider((EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TPFExecutionResult result = (TPFExecutionResult)((TestLogViewer)this.formPage.getEditor()).getEditorObject();
        this.eventsSectionPart = new SectionPart(section){

            public boolean setFormInput(Object input) {
                if (input instanceof TPFExecutionResult) {
                    LogEventsBlock.this.viewer.setInput((Object)((TPFExecutionResult)input).getExecutionHistory());
                }
                return true;
            }
        };
        managedForm.addPart((IFormPart)this.eventsSectionPart);
        this.createActions(result);
        this.createContextMenu();
        this.createExtensionActionButtons(toolkit, client);
        toolkit.paintBordersFor(client);
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object expandedObject = event.getElement();
                if (expandedObject instanceof Partition) {
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            Object[] expandedElements = LogEventsBlock.this.viewer.getExpandedElements();
                            int counter = 0;
                            while (counter < expandedElements.length) {
                                if (expandedElements[counter] instanceof Partition && expandedElements[counter] != expandedObject) {
                                    LogEventsBlock.this.viewer.collapseToLevel(expandedElements[counter], 1);
                                }
                                ++counter;
                            }
                        }
                    });
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (selectedObject instanceof Partition) {
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            List children = ((Partition)selectedObject).getChildren();
                            if (children.size() > 0) {
                                if (LogEventsBlock.this.viewer.getExpandedState(selectedObject)) {
                                    LogEventsBlock.this.viewer.setSelection((ISelection)new StructuredSelection(children.get(0)), true);
                                } else {
                                    LogEventsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)((EObject)children.get(0)).eContainer()), true);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected void createActions(TPFExecutionResult result) {
        this.verdictCollection = ((TestLogViewer)this.formPage.getEditor()).getTestLogVerdictTraversal();
        this.verdictTypesAction = new VerdictTypesPullDownAction(this.verdictCollection, (StructuredViewer)this.viewer);
        this.firstVerdict = new VerdictFirstAction(this.verdictTypesAction, this.verdictCollection, (StructuredViewer)this.viewer);
        this.prevVerdict = new VerdictPreviousAction(this.verdictTypesAction, this.verdictCollection, (StructuredViewer)this.viewer);
        this.nextVerdict = new VerdictNextAction(this.verdictTypesAction, this.verdictCollection, (StructuredViewer)this.viewer);
        this.lastVerdict = new VerdictLastAction(this.verdictTypesAction, this.verdictCollection, (StructuredViewer)this.viewer);
        this.testLogSearchAction = new TestLogSearchAction();
        this.collapseAction = new CollapseTreeAction(UiPluginResourceBundle.TestLogViewer_Collapse, this.viewer);
        this.expandAction = new ExpandTreeAction(UiPluginResourceBundle.TestLogViewer_Expand, this.viewer);
        this.collapseAction.setExpandAction(this.expandAction);
        this.expandAction.setCollapseAction(this.collapseAction);
        this.createExtensionActions(result);
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#testLogViewerEventsContextMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
    }

    protected void addContextMenuActions(IMenuManager menuManager) {
        menuManager.add((IAction)this.testLogSearchAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.collapseAction);
        menuManager.add((IAction)this.expandAction);
        menuManager.add((IContributionItem)new Separator());
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void addEventsSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void removeEventsSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.remove((Object)listener);
        }
    }

    protected void createExtensionActions(TPFExecutionResult result) {
        String testType = result.getType();
        testType = testType == null ? "allTestTypes" : testType;
        this.extensionActions = ExecutionHistoryExtensionsManager.getInstance().getEventActions(testType);
    }

    protected void createExtensionActionButtons(FormToolkit toolkit, Composite parent) {
        if (this.extensionActions == null) {
            this.extensionButtons = new Button[0];
            return;
        }
        Composite buttonComposite = toolkit.createComposite(parent);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        buttonComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 0;
        while (i < this.extensionActions.length) {
            if (this.extensionActions[i].isActionButton()) {
                IEventAction action = this.extensionActions[i].getAction();
                Button actionButton = toolkit.createButton(buttonComposite, this.extensionActions[i].getActionText(), 8);
                actionButton.setData((Object)action);
                actionButton.addSelectionListener((SelectionListener)this);
                buttons.add(actionButton);
                actionButton.setEnabled(action.isEnabled());
                gd = new GridData(768);
                gd.verticalAlignment = 128;
                actionButton.setLayoutData((Object)gd);
            } else {
                this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.extensionActions[i].getAction());
            }
            ++i;
        }
        this.extensionButtons = buttons.toArray(new Button[buttons.size()]);
        toolkit.paintBordersFor(buttonComposite);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.getToolBarManager().add((IAction)this.firstVerdict);
        form.getToolBarManager().add((IAction)this.prevVerdict);
        form.getToolBarManager().add((IAction)this.verdictTypesAction);
        form.getToolBarManager().add((IAction)this.nextVerdict);
        form.getToolBarManager().add((IAction)this.lastVerdict);
        form.getToolBarManager().add((IContributionItem)new Separator());
        form.getToolBarManager().add((IAction)this.testLogSearchAction);
        form.getToolBarManager().add((IContributionItem)new Separator());
        form.getToolBarManager().add((IAction)this.collapseAction);
        form.getToolBarManager().add((IAction)this.expandAction);
        form.getToolBarManager().add((IContributionItem)new Separator());
        this.createOrientationToolBarActions(form);
    }

    private void createOrientationToolBarActions(final ScrolledForm form) {
        Action haction = new Action(null, 8){

            public void run() {
                LogEventsBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText(UiPluginResourceBundle.Editor_horizontal_orientation);
        haction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "th_horizontal.gif"));
        Action vaction = new Action(null, 8){

            public void run() {
                LogEventsBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText(UiPluginResourceBundle.Editor_vertical_orientation);
        vaction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "th_vertical.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageLimit(20);
        detailsPart.setPageProvider((IDetailsPageProvider)new ExecutionEventDetailsProvider(this.formPage));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.mForm.fireSelectionChanged((IFormPart)this.eventsSectionPart, selection);
        int i = 0;
        while (i < this.extensionButtons.length) {
            IEventAction action = (IEventAction)this.extensionButtons[i].getData();
            if (action != null) {
                action.selectionChanged(event);
                this.extensionButtons[i].setEnabled(action.isEnabled());
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object action;
        if (e.widget instanceof Button && (action = e.widget.getData()) instanceof IAction) {
            ((IAction)action).run();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.extensionActions != null) {
            int i = 0;
            while (i < this.extensionActions.length) {
                if (this.extensionActions[i].isActionContextMenu()) {
                    this.extensionActions[i].getAction().menuAboutToShow(manager);
                }
                ++i;
            }
        }
        this.addContextMenuActions(manager);
    }
}

