/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;

public class TestLogVerdictTraversalQuery
implements ITestLogVerdictTraversal {
    private TPFExecutionResult result = null;
    private QueryResult[] verdictQueries = null;
    private int[] verdictCursors = null;

    public TestLogVerdictTraversalQuery(TPFExecutionResult result) {
        this.init(result);
    }

    public void init(TPFExecutionResult result) {
        this.result = result;
        this.verdictQueries = new QueryResult[5];
        this.verdictQueries[1] = this.createVerdictQueryResult(result, TPFVerdict.PASS_LITERAL);
        this.verdictQueries[2] = this.createVerdictQueryResult(result, TPFVerdict.FAIL_LITERAL);
        this.verdictQueries[3] = this.createVerdictQueryResult(result, TPFVerdict.ERROR_LITERAL);
        this.verdictQueries[0] = this.createVerdictQueryResult(result, TPFVerdict.INCONCLUSIVE_LITERAL);
        this.verdictQueries[4] = this.createVerdictQueryResult(result, null);
        this.verdictCursors = new int[5];
        this.resetCursors();
    }

    private QueryResult createVerdictQueryResult(TPFExecutionResult result, TPFVerdict verdict) {
        SimpleSearchQuery verdictQuery = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        verdictQuery.getSources().add((Object)EcoreUtil.getURI((EObject)result).toString());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionResult_ExecutionHistory());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Children());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_InvokedExecutionResult());
        SimpleOperand Operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand.setType(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent());
        verdictQuery.getOutputElements().add((Object)Operand);
        LogicalExpression whereExpression = this.createORExpression();
        if (verdict != null) {
            BinaryExpression verdictTypeFilter = this.createTPFVerdictFilter(verdict);
            whereExpression.getArguments().add((Object)verdictTypeFilter);
        }
        verdictQuery.setWhereExpression((WhereExpression)whereExpression);
        QueryResult queryResult = null;
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)result.eResource().getURI().toString()));
        if (hyadesResourceExtension != null) {
            ArrayList notLoadedTypes = new ArrayList();
            ResourceSet resourceSet = result.eResource().getResourceSet();
            queryResult = hyadesResourceExtension.executeQuery((Query)verdictQuery, resourceSet, notLoadedTypes);
        }
        return queryResult;
    }

    protected BinaryExpression createTPFVerdictFilter(TPFVerdict verdict) {
        return this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict(), Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent_Verdict().getEAttributeType(), verdict);
    }

    protected BinaryExpression createBinaryExpression(EAttribute feature, EDataType valueType, Object value) {
        BinaryExpression expression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)feature);
        expression.setLeftOperand((Operand)operand);
        operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setValueType(valueType);
        operand.setValue(value);
        expression.getRightOperands().add((Object)operand);
        expression.setOperator(RelationalOperators.LIKE_LITERAL);
        return expression;
    }

    protected LogicalExpression createORExpression() {
        LogicalExpression or = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        or.setOperator(LogicalOperators.OR_LITERAL);
        return or;
    }

    public boolean contains(int verdictType) {
        return this.getCount(verdictType) > 0;
    }

    public TPFExecutionResult getExecutionResult() {
        return this.result;
    }

    public TPFVerdictEvent getFirst(int verdictType) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            this.verdictCursors[verdictType] = 0;
            return (TPFVerdictEvent)resultSet.get(this.verdictCursors[verdictType]);
        }
        return null;
    }

    public TPFVerdictEvent getLast(int verdictType) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            this.verdictCursors[verdictType] = resultSet.size() - 1;
            return (TPFVerdictEvent)resultSet.get(this.verdictCursors[verdictType]);
        }
        return null;
    }

    public TPFVerdictEvent getNext(int verdictType, Object current) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            if (current != null) {
                int currentIndex = resultSet.indexOf(current);
                if (currentIndex != -1) {
                    if (currentIndex == resultSet.size() - 1) {
                        currentIndex = 0;
                    }
                    this.verdictCursors[verdictType] = ++currentIndex;
                    return (TPFVerdictEvent)resultSet.get(currentIndex);
                }
            } else {
                if (this.verdictCursors[verdictType] == resultSet.size() - 1) {
                    this.verdictCursors[verdictType] = 0;
                } else {
                    int n = verdictType;
                    this.verdictCursors[n] = this.verdictCursors[n] + 1;
                }
                return (TPFVerdictEvent)resultSet.get(this.verdictCursors[verdictType]);
            }
        }
        return null;
    }

    public TPFVerdictEvent getPrevious(int verdictType, Object current) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            if (current != null) {
                int currentIndex = resultSet.indexOf(current);
                if (currentIndex != -1) {
                    if (currentIndex == 0) {
                        currentIndex = resultSet.size() - 1;
                    }
                    this.verdictCursors[verdictType] = --currentIndex;
                    return (TPFVerdictEvent)resultSet.get(currentIndex);
                }
            } else {
                if (this.verdictCursors[verdictType] == -1 || this.verdictCursors[verdictType] == 0) {
                    this.verdictCursors[verdictType] = resultSet.size() - 1;
                } else {
                    int n = verdictType;
                    this.verdictCursors[n] = this.verdictCursors[n] - 1;
                }
                return (TPFVerdictEvent)resultSet.get(this.verdictCursors[verdictType]);
            }
        }
        return null;
    }

    public boolean hasPrevious(int verdictType, Object current) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            if (current != null) {
                int currentIndex = resultSet.indexOf(current);
                return currentIndex != -1 && currentIndex != 0;
            }
            return this.verdictCursors[verdictType] != -1 && this.verdictCursors[verdictType] != 0;
        }
        return false;
    }

    public boolean hasNext(int verdictType, Object current) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            if (current != null) {
                int currentIndex = resultSet.indexOf(current);
                return currentIndex != -1 && currentIndex != resultSet.size() - 1;
            }
            return this.verdictCursors[verdictType] != resultSet.size() - 1;
        }
        return false;
    }

    public int getCount(int verdictType) {
        List resultSet;
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty() && !(resultSet = (List)((ResultEntry)result.get(0)).getValue()).isEmpty()) {
            return resultSet.size();
        }
        return 0;
    }

    public List getQueryResults(int verdictType) {
        EList result = this.verdictQueries[verdictType].getResultEntries();
        if (!result.isEmpty()) {
            return (List)((ResultEntry)result.get(0)).getValue();
        }
        return new ArrayList();
    }

    public void resetCursors() {
        int i = 0;
        while (i < this.verdictCursors.length) {
            this.verdictCursors[i] = -1;
            ++i;
        }
    }
}

