/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.CallBackValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.base.SystemStyleProcessor;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.DefaultVerdictCategoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IVerdictCategoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.VerdictCategory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Section;

public class VerdictSummaryChart
extends Canvas
implements PaintListener,
ICallBackNotifier,
IActionRenderer,
ISelectionProvider {
    private IDeviceRenderer dr = null;
    private RunTimeContext runtimeContext;
    private Chart cm = null;
    private GeneratedChartState chartState = null;
    private VerdictCategory[] verdictCategories;
    private ListenerList selectionListeners = new ListenerList();
    private IStructuredSelection currentSelection;
    private Section chartSection;

    public VerdictSummaryChart(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dr = ps.getDevice("dv.SWT");
            this.dr.setProperty("device.component", (Object)this);
        }
        catch (ChartException pex) {
            UiPlugin.logError(pex);
        }
        this.runtimeContext = new RunTimeContext();
        this.runtimeContext.setActionRenderer((IActionRenderer)this);
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                    }
                }
            }
        });
    }

    public void setChartSection(Section section) {
        this.chartSection = section;
    }

    public boolean setInput(TPFExecutionResult input) {
        String testType = input.getType();
        VerdictCategory[] categories = null;
        IVerdictCategoryProvider provider = ExecutionHistoryExtensionsManager.getInstance().getVerdictProvider(testType);
        if (provider != null) {
            if (provider instanceof DefaultVerdictCategoryProvider) {
                categories = ((DefaultVerdictCategoryProvider)provider).getVerdictCategories(input);
            } else {
                EList verLists = input.getVerdictLists();
                if (verLists == null || verLists.isEmpty() || verLists.size() == 1) {
                    ((FormText)this.chartSection.getDescriptionControl()).setText(UiPluginResourceBundle.LogOverview_NoVerdictInLog, false, false);
                    return false;
                }
                TPFVerdictList list2 = null;
                for (TPFVerdictList list2 : verLists) {
                    if ("allTypes".equals(list2.getType())) break;
                    list2 = null;
                }
                if (list2 == null) {
                    return false;
                }
                EList allVerdicts = list2.getVerdictEvents();
                categories = provider.getVerdictCategories((List)allVerdicts);
            }
        }
        if (categories == null) {
            provider = new DefaultVerdictCategoryProvider();
            categories = ((DefaultVerdictCategoryProvider)provider).getVerdictCategories(input);
        }
        this.cm = this.createPieChart(categories);
        if (this.cm == null) {
            return false;
        }
        this.cm.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        this.setSelection((ISelection)new StructuredSelection((Object)provider.getDefaultCategory(categories)));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setInput(TPFExecutionResult input, TestLogVerdictTraversalQuery verdictTraversal) {
        String testType = input.getType();
        VerdictCategory[] categories = null;
        IVerdictCategoryProvider provider = ExecutionHistoryExtensionsManager.getInstance().getVerdictProvider(testType);
        try {
            if (provider != null) {
                int verdictCount = verdictTraversal.getCount(4);
                if (verdictCount < 2) {
                    ((FormText)this.chartSection.getDescriptionControl()).setText(UiPluginResourceBundle.LogOverview_NoVerdictInLog, false, false);
                    return false;
                }
                try {
                    categories = provider.getVerdictCategories(verdictTraversal);
                }
                catch (RuntimeException runtimeException) {}
            }
            if (categories == null) {
                provider = new DefaultVerdictCategoryProvider();
                categories = ((DefaultVerdictCategoryProvider)provider).getVerdictCategories(verdictTraversal);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        this.cm = this.createPieChart(categories);
        if (this.cm == null) {
            return false;
        }
        this.cm.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        this.setSelection((ISelection)new StructuredSelection((Object)provider.getDefaultCategory(categories)));
        return true;
    }

    public final void paintControl(PaintEvent pe) {
        if (this.cm == null) {
            return;
        }
        this.dr.setProperty("device.output.context", (Object)pe.gc);
        Composite co = (Composite)pe.getSource();
        Rectangle re = co.getClientArea();
        Bounds bo = BoundsImpl.create((double)re.x, (double)re.y, (double)re.width, (double)re.height);
        bo.scale(72.0 / (double)this.dr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.chartState = gr.build(this.dr.getDisplayServer(), this.cm, bo, null, this.runtimeContext, (IStyleProcessor)new SystemStyleProcessor());
        }
        catch (ChartException ce) {
            ce.printStackTrace();
        }
        try {
            gr.render(this.dr, this.chartState);
        }
        catch (ChartException ce) {
            UiPlugin.logError(ce);
        }
    }

    private final Chart createPieChart(VerdictCategory[] vCategories) {
        if (vCategories != null && vCategories.length > 0) {
            ArrayList<VerdictCategory> verdictCategoriesList = new ArrayList<VerdictCategory>();
            int counter = 0;
            while (counter < vCategories.length) {
                if (vCategories[counter].getNumVerdicts() != 0) {
                    verdictCategoriesList.add(vCategories[counter]);
                }
                ++counter;
            }
            this.verdictCategories = verdictCategoriesList.toArray(new VerdictCategory[verdictCategoriesList.size()]);
            ChartWithoutAxes pie = ChartWithoutAxesImpl.create();
            pie.getBlock().setBackground(null);
            Plot p = pie.getPlot();
            p.getClientArea().setBackground(null);
            p.getClientArea().getOutline().setVisible(false);
            p.getOutline().setVisible(false);
            Legend lg = pie.getLegend();
            lg.setItemType(LegendItemType.CATEGORIES_LITERAL);
            lg.getClientArea().getOutline().setVisible(true);
            lg.getTitle().setVisible(false);
            lg.getClientArea().getInsets().set(6.0, 4.0, 4.0, 4.0);
            pie.getTitle().setVisible(false);
            int length = this.verdictCategories.length;
            String[] texts = new String[length];
            double[] values = new double[length];
            ArrayList<ColorDefinition> fills = new ArrayList<ColorDefinition>();
            double totalSize = 0.0;
            int i = 0;
            while (i < length) {
                totalSize += (double)this.verdictCategories[i].getNumVerdicts();
                ++i;
            }
            int i2 = 0;
            while (i2 < length) {
                texts[i2] = this.verdictCategories[i2].getText();
                RGB color = this.verdictCategories[i2].getColor();
                fills.add(ColorDefinitionImpl.create((int)color.red, (int)color.green, (int)color.blue));
                double size = this.verdictCategories[i2].getNumVerdicts();
                values[i2] = size / totalSize * 100.0;
                ++i2;
            }
            SeriesDefinition sd = SeriesDefinitionImpl.create();
            pie.getSeriesDefinitions().add((Object)sd);
            sd.getSeriesPalette().getEntries().clear();
            sd.getSeriesPalette().getEntries().addAll(fills);
            Series seCategory = SeriesImpl.create();
            TextDataSet categoryValues = TextDataSetImpl.create((Object)texts);
            seCategory.setDataSet((DataSet)categoryValues);
            sd.getSeries().add((Object)seCategory);
            PieSeries sePie = (PieSeries)PieSeriesImpl.create();
            NumberDataSet seriesOneValues = NumberDataSetImpl.create((Object)values);
            sePie.setDataSet((DataSet)seriesOneValues);
            sePie.setSeriesIdentifier((Object)"");
            Action tooltipAction = ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)500, null));
            Trigger tooltipTrigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)tooltipAction);
            sePie.getTriggers().add((Object)tooltipTrigger);
            Action action = ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)VerdictSummaryChart.class.getName()));
            Trigger tg = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)action);
            sePie.getTriggers().add((Object)tg);
            SeriesDefinition sdVerdicts = SeriesDefinitionImpl.create();
            sdVerdicts.getQuery().setDefinition("Verdict Types");
            sd.getSeriesDefinitions().add((Object)sdVerdicts);
            sdVerdicts.getSeries().add((Object)sePie);
            DataPointComponent dpc = DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0.0'%'"));
            sePie.getDataPoint().getComponents().clear();
            sePie.getDataPoint().getComponents().add((Object)dpc);
            sePie.setExplosion(0);
            return pie;
        }
        return null;
    }

    public void callback(Object event, Object source, CallBackValue value) {
        String text;
        DataPointHints data = null;
        if (source instanceof StructureSource) {
            if (((StructureSource)source).getSource() instanceof DataPointHints) {
                data = (DataPointHints)((StructureSource)source).getSource();
            }
        } else if (source instanceof DataPointHints) {
            data = (DataPointHints)source;
        }
        if (data != null && (text = data.getBaseDisplayValue()) != null) {
            int i = 0;
            while (i < this.verdictCategories.length) {
                if (text.equals(this.verdictCategories[i].getText())) {
                    this.fireSelectionChangedEvent((IStructuredSelection)new StructuredSelection((Object)this.verdictCategories[i]));
                }
                ++i;
            }
        }
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.chartState.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public Object getContext(Object key) {
        return null;
    }

    public Object putContext(Object key, Object value) {
        return null;
    }

    public Object removeContext(Object key) {
        return null;
    }

    public void processAction(Action action, StructureSource source) {
        if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType()) && StructureType.SERIES_DATA_POINT.equals(source.getType())) {
            String text = ((DataPointHints)source.getSource()).getBaseDisplayValue().trim();
            int counter = 0;
            while (counter < this.verdictCategories.length) {
                if (text.equals(this.verdictCategories[counter].getText().trim())) {
                    ((TooltipValue)action.getValue()).setText(NLS.bind((String)UiPluginResourceBundle.LogOverview_VerdictSummaryToolTip, (Object)text, (Object)String.valueOf(this.verdictCategories[counter].getNumVerdicts())));
                    break;
                }
                ++counter;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fireSelectionChangedEvent((IStructuredSelection)selection);
        }
    }

    protected void fireSelectionChangedEvent(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (this.currentSelection != null && this.currentSelection.getFirstElement().equals(selection.getFirstElement())) {
            return;
        }
        this.currentSelection = selection;
        Object[] listeners = this.selectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
            ++i;
        }
    }
}

