/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.editor.page;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.forms.actions.VerdictNavigationAction;
import org.eclipse.hyades.test.ui.forms.base.LogEventsBlock;
import org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LogEventsPage
extends FormPage
implements ISelectionProvider {
    private ScrolledForm form;
    public static final String PAGE_ID = "org.eclipse.tptp.test.ui.logviewer.events";
    private LogEventsBlock block = new LogEventsBlock(this);

    public LogEventsPage(FormEditor editor) {
        super(editor, PAGE_ID, UiPluginResourceBundle.W_EVENTS);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.form.setText(UiPluginResourceBundle.W_TEST_LOG);
        this.block.createContent(managedForm);
        managedForm.setInput((Object)((BaseFormEditor)this.getEditor()).getEditorObject());
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectionChangedEvent ev = new SelectionChangedEvent((ISelectionProvider)LogEventsPage.this, event.getSelection());
                ((TestLogViewer)LogEventsPage.this.getEditor()).fireSelectionChanged(ev);
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.block.addEventsSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.block.removeEventsSelectionChangedListener(listener);
    }

    public boolean selectReveal(Object object) {
        TreeViewer viewer;
        if (object instanceof TPFExecutionHistory) {
            object = ((TPFExecutionHistory)object).getExecutionResult();
        }
        if (object instanceof TPFExecutionResult && ((TPFExecutionResult)object).eContainer() == null) {
            return false;
        }
        if (this.getEditor().getActivePageInstance() != this) {
            this.getEditor().setActivePage(PAGE_ID);
        }
        if ((viewer = this.block.getTreeViewer()) != null) {
            viewer.reveal(object);
            viewer.setSelection((ISelection)new StructuredSelection(object));
            viewer.getTree().forceFocus();
            return true;
        }
        return false;
    }

    public ISelection getSelection() {
        return this.block.getTreeViewer().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.block.getTreeViewer().setSelection(selection);
    }

    public void lazySelectVerdictEvent(TPFVerdictEvent event) {
        if (event != null) {
            VerdictNavigationAction.revealEvent(event, this.block.getTreeViewer());
        }
    }
}

