/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IVerdictCategoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.VerdictCategory;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.swt.graphics.RGB;

public class DefaultVerdictCategoryProvider
implements IVerdictCategoryProvider {
    public static final RGB COLOR_PASS = TestUIConstants.COLOR_PASS;
    public static final RGB COLOR_FAIL = TestUIConstants.COLOR_FAIL;
    public static final RGB COLOR_ERROR = TestUIConstants.COLOR_ERROR;
    public static final RGB COLOR_INCONCLUSIVE = TestUIConstants.COLOR_INCONCLUSIVE;

    public VerdictCategory[] getVerdictCategories(List allVerdictEvents) {
        if (allVerdictEvents == null || allVerdictEvents.size() == 0) {
            return null;
        }
        return this.getVerdictCategories(((TPFExecutionEvent)allVerdictEvents.get(0)).getExecutionHistory().getExecutionResult());
    }

    public VerdictCategory[] getVerdictCategories(TPFExecutionResult executionResult) {
        EList lists = executionResult.getVerdictLists();
        if (lists == null || lists.isEmpty()) {
            return null;
        }
        ArrayList<VerdictCategory> categories = new ArrayList<VerdictCategory>();
        TPFVerdictList defCategory2 = null;
        for (TPFVerdictList defCategory2 : lists) {
            EList events;
            if (defCategory2 == null || (events = defCategory2.getVerdictEvents()) == null || events.isEmpty()) continue;
            if (TPFVerdict.ERROR_LITERAL.getName().equals(defCategory2.getType())) {
                categories.add(new VerdictCategory((List)events, TPFVerdict.ERROR_LITERAL.getLabel(), TestUIConstants.COLOR_ERROR, TestUIImages.INSTANCE.getImage("eveverdicterror_obj.gif")));
                continue;
            }
            if (TPFVerdict.FAIL_LITERAL.getName().equals(defCategory2.getType())) {
                categories.add(new VerdictCategory((List)events, TPFVerdict.FAIL_LITERAL.getLabel(), TestUIConstants.COLOR_FAIL, TestUIImages.INSTANCE.getImage("eveverdictfail_obj.gif")));
                continue;
            }
            if (TPFVerdict.INCONCLUSIVE_LITERAL.getName().equals(defCategory2.getType())) {
                categories.add(new VerdictCategory((List)events, TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), TestUIConstants.COLOR_INCONCLUSIVE, TestUIImages.INSTANCE.getImage("eveverdictinc_obj.gif")));
                continue;
            }
            if (!TPFVerdict.PASS_LITERAL.getName().equals(defCategory2.getType())) continue;
            categories.add(new VerdictCategory((List)events, TPFVerdict.PASS_LITERAL.getLabel(), TestUIConstants.COLOR_PASS, TestUIImages.INSTANCE.getImage("eveverdictpass_obj.gif")));
        }
        return categories.toArray(new VerdictCategory[categories.size()]);
    }

    public VerdictCategory getDefaultCategory(VerdictCategory[] categories) {
        if (categories == null) {
            return null;
        }
        VerdictCategory errorList = null;
        VerdictCategory failList = null;
        VerdictCategory inconclusiveList = null;
        VerdictCategory passList = null;
        int i = 0;
        while (i < categories.length) {
            VerdictCategory defCategory = categories[i];
            if (defCategory != null && defCategory.getVerdicts() != null) {
                if (TPFVerdict.ERROR_LITERAL.getName().equals(defCategory.getText())) {
                    errorList = defCategory;
                } else if (TPFVerdict.FAIL_LITERAL.getName().equals(defCategory.getText())) {
                    failList = defCategory;
                } else if (TPFVerdict.INCONCLUSIVE_LITERAL.getName().equals(defCategory.getText())) {
                    inconclusiveList = defCategory;
                } else if (TPFVerdict.PASS_LITERAL.getName().equals(defCategory.getText())) {
                    passList = defCategory;
                }
            }
            ++i;
        }
        if (errorList != null && errorList.getNumVerdicts() > 0) {
            return errorList;
        }
        if (failList != null && failList.getNumVerdicts() > 0) {
            return failList;
        }
        if (inconclusiveList != null && inconclusiveList.getNumVerdicts() > 0) {
            return inconclusiveList;
        }
        if (passList != null && passList.getNumVerdicts() > 0) {
            return passList;
        }
        return null;
    }

    public VerdictCategory[] getVerdictCategories(ITestLogVerdictTraversal traversal) {
        VerdictCategory[] categories = new VerdictCategory[4];
        if (traversal instanceof TestLogVerdictTraversalQuery) {
            TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery)traversal;
            categories[0] = new VerdictCategory(query.getQueryResults(3), TPFVerdict.ERROR_LITERAL.getLabel(), TestUIConstants.COLOR_ERROR, TestUIImages.INSTANCE.getImage("eveverdicterror_obj.gif"));
            categories[1] = new VerdictCategory(query.getQueryResults(2), TPFVerdict.FAIL_LITERAL.getLabel(), TestUIConstants.COLOR_FAIL, TestUIImages.INSTANCE.getImage("eveverdictfail_obj.gif"));
            categories[2] = new VerdictCategory(query.getQueryResults(0), TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), TestUIConstants.COLOR_INCONCLUSIVE, TestUIImages.INSTANCE.getImage("eveverdictinc_obj.gif"));
            categories[3] = new VerdictCategory(query.getQueryResults(1), TPFVerdict.PASS_LITERAL.getLabel(), TestUIConstants.COLOR_PASS, TestUIImages.INSTANCE.getImage("eveverdictpass_obj.gif"));
            return categories;
        }
        throw new UnsupportedOperationException();
    }
}

