/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExecutionEventSearchProvider
implements ITestLogSearchProvider,
SelectionListener {
    private ISearchPageContainer pageContainer;
    private boolean searchText = true;
    private Button text;
    private boolean searchTime;
    private Button time;
    private boolean searchAttachment;
    private Button attachment;
    private boolean searchPropName;
    private Button propName;
    private boolean searchPropValue;
    private Button propValue;

    public void createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(770));
        comp.setLayout((Layout)new GridLayout(3, false));
        Label searchIn = new Label(comp, 0);
        searchIn.setText(UiPluginResourceBundle.TestLogSearch_SearchInFields);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        searchIn.setLayoutData((Object)gd);
        this.text = new Button(comp, 32);
        this.text.setText(UiPluginResourceBundle.TestLogSearch_Text);
        this.text.addSelectionListener((SelectionListener)this);
        this.text.setSelection(this.searchText);
        this.time = new Button(comp, 32);
        this.time.setText(UiPluginResourceBundle.TestLogSearch_Time);
        this.time.addSelectionListener((SelectionListener)this);
        this.attachment = new Button(comp, 32);
        this.attachment.setText(UiPluginResourceBundle.TestLogSearch_AttachmentFileName);
        this.attachment.addSelectionListener((SelectionListener)this);
        this.propName = new Button(comp, 32);
        this.propName.setText(UiPluginResourceBundle.TestLogSearch_PropertyName);
        this.propName.addSelectionListener((SelectionListener)this);
        this.propValue = new Button(comp, 32);
        this.propValue.setText(UiPluginResourceBundle.TestLogSearch_PropertyValue);
        this.propValue.addSelectionListener((SelectionListener)this);
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    public ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
        SimpleSearchQuery query = this.createQuery(rootElement);
        this.setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent());
        LogicalExpression or = this.createORExpression();
        boolean caseSensitive = Boolean.TRUE.equals(options.get("caseSensitive"));
        if (this.searchText) {
            BinaryExpression textSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Text(), text);
            textSearch.setCaseInsensitive(!caseSensitive);
            or.getArguments().add((Object)textSearch);
        }
        if (this.searchTime) {
            BinaryExpression timeSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Timestamp(), text);
            timeSearch.setCaseInsensitive(!caseSensitive);
            or.getArguments().add((Object)timeSearch);
        }
        if (this.searchAttachment) {
            query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Annotations());
            BinaryExpression attachmentSearch = this.createBinaryExpression(CommonPackage.eINSTANCE.getCMNAnnotation_URI(), text);
            attachmentSearch.setCaseInsensitive(!caseSensitive);
            or.getArguments().add((Object)attachmentSearch);
        }
        if (this.searchPropName) {
            query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Properties());
            BinaryExpression propNameSearch = this.createBinaryExpression(CommonPackage.eINSTANCE.getCMNExtendedProperty_Name(), text);
            propNameSearch.setCaseInsensitive(!caseSensitive);
            or.getArguments().add((Object)propNameSearch);
        }
        if (this.searchPropValue) {
            query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Properties());
            BinaryExpression propValueSearch = this.createBinaryExpression(CommonPackage.eINSTANCE.getCMNExtendedProperty_Value(), text);
            propValueSearch.setCaseInsensitive(!caseSensitive);
            or.getArguments().add((Object)propValueSearch);
        }
        if (or.getArguments().size() > 0) {
            query.setWhereExpression((WhereExpression)or);
        }
        return query;
    }

    protected SimpleSearchQuery createQuery(EObject rootElement) {
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        query.setDistinct(true);
        query.getSources().add((Object)EcoreUtil.getURI((EObject)rootElement).toString());
        query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionResult_ExecutionHistory());
        query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents());
        query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Children());
        query.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_InvokedExecutionResult());
        return query;
    }

    protected void setQueryOutputType(SimpleSearchQuery query, EClass type) {
        SimpleOperand outputType = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        outputType.setType(type);
        if (query.getOutputElements().size() > 0) {
            query.getOutputElements().clear();
        }
        query.getOutputElements().add((Object)outputType);
    }

    protected LogicalExpression createORExpression() {
        LogicalExpression or = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        or.setOperator(LogicalOperators.OR_LITERAL);
        return or;
    }

    protected LogicalExpression createANDExpression() {
        LogicalExpression and = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        and.setOperator(LogicalOperators.AND_LITERAL);
        return and;
    }

    protected void combineExecutionEventAndElementExpressions(SimpleSearchQuery query, LogicalExpression executionEventORExpression, LogicalExpression elementORExpression) {
        if (executionEventORExpression != null && !executionEventORExpression.getArguments().isEmpty() && elementORExpression != null && !elementORExpression.getArguments().isEmpty()) {
            LogicalExpression and = this.createANDExpression();
            and.getArguments().add((Object)executionEventORExpression);
            and.getArguments().add((Object)elementORExpression);
            query.setWhereExpression((WhereExpression)and);
        } else if (elementORExpression != null && !elementORExpression.getArguments().isEmpty()) {
            query.setWhereExpression((WhereExpression)elementORExpression);
        } else if (executionEventORExpression != null && !executionEventORExpression.getArguments().isEmpty()) {
            query.setWhereExpression((WhereExpression)executionEventORExpression);
        } else {
            query.setWhereExpression((WhereExpression)this.createORExpression());
        }
    }

    protected BinaryExpression createBinaryExpression(EAttribute feature, String value) {
        BinaryExpression expression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)feature);
        expression.setLeftOperand((Operand)operand);
        operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setValueType(EcorePackage.eINSTANCE.getEString());
        operand.setValue((Object)value);
        expression.getRightOperands().add((Object)operand);
        expression.setOperator(RelationalOperators.LIKE_LITERAL);
        return expression;
    }

    protected BinaryExpression createBinaryExpression(EAttribute feature, EDataType valueType, Object value) {
        BinaryExpression expression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)feature);
        expression.setLeftOperand((Operand)operand);
        operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setValueType(valueType);
        operand.setValue(value);
        expression.getRightOperands().add((Object)operand);
        expression.setOperator(RelationalOperators.LIKE_LITERAL);
        return expression;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.text) {
            this.searchText = this.text.getSelection();
        } else if (e.widget == this.time) {
            this.searchTime = this.time.getSelection();
        } else if (e.widget == this.attachment) {
            this.searchAttachment = this.attachment.getSelection();
        } else if (e.widget == this.propName) {
            this.searchPropName = this.propName.getSelection();
        } else if (e.widget == this.propValue) {
            this.searchPropValue = this.propValue.getSelection();
        }
    }
}

