/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.DefaultVerdictCategoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.VerdictCategory;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;

public class TPTPVerdictCategoryProvider
extends DefaultVerdictCategoryProvider {
    public VerdictCategory[] getVerdictCategories(TPFExecutionResult executionResult) {
        VerdictCategory[] vc;
        EList execEvents = executionResult.getExecutionHistory().getExecutionEvents();
        TPFVerdictEvent verdict = null;
        if (execEvents != null) {
            int i = execEvents.size() - 1;
            while (i >= 0) {
                if (execEvents.get(i) instanceof TPFVerdictEvent) {
                    verdict = (TPFVerdictEvent)execEvents.get(i);
                }
                --i;
            }
        }
        if ((vc = super.getVerdictCategories(executionResult)) != null && verdict != null) {
            int i = 0;
            while (i < vc.length) {
                if (vc[i].getText().equals(verdict.getVerdict().getLabel())) {
                    List verdicts = vc[i].getVerdicts();
                    verdicts.remove(verdict);
                    break;
                }
                ++i;
            }
        }
        return vc;
    }

    public VerdictCategory[] getVerdictCategories(ITestLogVerdictTraversal traversal) {
        VerdictCategory[] categories = new VerdictCategory[4];
        if (traversal instanceof TestLogVerdictTraversalQuery) {
            TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery)traversal;
            TPFVerdictEvent verdict = query.getLast(4);
            List verdictList = query.getQueryResults(verdict.getVerdict().getValue());
            int indexOfIgnoredVerdict = verdictList.size() - 1;
            ArrayList<Integer> ignoreList = new ArrayList<Integer>();
            ignoreList.add(new Integer(indexOfIgnoredVerdict));
            categories[0] = new VerdictCategory(query.getQueryResults(3), TPFVerdict.ERROR_LITERAL.getLabel(), TestUIConstants.COLOR_ERROR, TestUIImages.INSTANCE.getImage("eveverdicterror_obj.gif"), verdict.getVerdict().getValue() == 3 ? ignoreList : null);
            categories[1] = new VerdictCategory(query.getQueryResults(2), TPFVerdict.FAIL_LITERAL.getLabel(), TestUIConstants.COLOR_FAIL, TestUIImages.INSTANCE.getImage("eveverdictfail_obj.gif"), verdict.getVerdict().getValue() == 2 ? ignoreList : null);
            categories[2] = new VerdictCategory(query.getQueryResults(0), TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), TestUIConstants.COLOR_INCONCLUSIVE, TestUIImages.INSTANCE.getImage("eveverdictinc_obj.gif"), verdict.getVerdict().getValue() == 0 ? ignoreList : null);
            categories[3] = new VerdictCategory(query.getQueryResults(1), TPFVerdict.PASS_LITERAL.getLabel(), TestUIConstants.COLOR_PASS, TestUIImages.INSTANCE.getImage("eveverdictpass_obj.gif"), verdict.getVerdict().getValue() == 1 ? ignoreList : null);
            return categories;
        }
        throw new UnsupportedOperationException();
    }
}

