/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.util;

import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FormsUtil {
    public static Section createSection(IManagedForm managedForm, Composite parent, String title, String description) {
        Layout layout = parent.getLayout();
        if (layout == null || !(layout instanceof GridLayout)) {
            GridLayout gl = new GridLayout();
            gl.numColumns = 1;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.marginTop = 0;
            gl.horizontalSpacing = 5;
            gl.verticalSpacing = 5;
            parent.setLayout((Layout)gl);
        }
        FormToolkit toolkit = managedForm.getToolkit();
        final ScrolledForm form = managedForm.getForm();
        Section section = toolkit.createSection(parent, 258);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        section.setText(title);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        section.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        section.marginHeight = 3;
        section.marginWidth = 3;
        section.clientVerticalSpacing = 5;
        if (description != null && description.trim().length() > 0) {
            FormText descriptionControl = toolkit.createFormText((Composite)section, false);
            descriptionControl.setText(description, false, false);
            section.setDescriptionControl((Control)descriptionControl);
        }
        Composite client = toolkit.createComposite((Composite)section, 0);
        client.setLayout((Layout)new GridLayout());
        section.setClient((Control)client);
        return section;
    }
}

