/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.forms.util.EObjectTreeContentProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Partition;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

public class TestLogEventsLazyPathContentProvider
extends EObjectTreeContentProvider
implements ILazyTreePathContentProvider {
    private List parts = new ArrayList();
    private static final int MAX_ITEMS = 30000;

    protected Object getRegisteredParentChild(Object parent) {
        if (parent instanceof Partition) {
            return ((Partition)parent).getChildren();
        }
        if (parent instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if (executionResult.getExecutionHistory() != null) {
                return executionResult.getExecutionHistory().getExecutionEvents();
            }
            return null;
        }
        if (parent instanceof TPFExecutionEvent) {
            if (parent instanceof TPFInvocationEvent) {
                return ((TPFInvocationEvent)parent).getInvokedExecutionResult();
            }
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
            if (executionEvent.getChildren() != null && !executionEvent.getChildren().isEmpty()) {
                return executionEvent.getChildren();
            }
        }
        return null;
    }

    public TestLogEventsLazyPathContentProvider(EStructuralFeature eStructuralFeature) {
        super(eStructuralFeature);
    }

    public TreePath[] getParents(Object element) {
        return null;
    }

    public void updateElement(TreePath parentPath, int index) {
        Object child = null;
        Object parent = this.getElement(parentPath);
        if (parent instanceof Partition) {
            child = ((Partition)parent).getChild(index);
        } else if (parent instanceof TPFExecutionHistory) {
            TPFExecutionHistory eventLog = (TPFExecutionHistory)parent;
            int partitionSize = TestLogEventsLazyPathContentProvider.computePartitionSize(eventLog.getExecutionEvents().size());
            child = partitionSize > 1 ? this.createPartition(eventLog.getExecutionEvents(), partitionSize, index) : (TPFExecutionEvent)eventLog.getExecutionEvents().get(index);
        } else if (parent instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if (executionResult.getExecutionHistory() != null) {
                int partitionSize = TestLogEventsLazyPathContentProvider.computePartitionSize(executionResult.getExecutionHistory().getExecutionEvents().size());
                child = partitionSize > 1 ? this.createPartition(executionResult.getExecutionHistory().getExecutionEvents(), partitionSize, index) : executionResult.getExecutionHistory().getExecutionEvents().get(index);
            }
        } else if (parent instanceof TPFExecutionEvent) {
            if (parent instanceof TPFInvocationEvent) {
                TPFInvocationEvent invocationEvent = (TPFInvocationEvent)parent;
                int partitionSize1 = TestLogEventsLazyPathContentProvider.computePartitionSize(invocationEvent.getChildren().size());
                child = partitionSize1 > 1 ? this.createPartition(invocationEvent.getChildren(), partitionSize1, index) : invocationEvent.getInvokedExecutionResult();
            } else {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
                if (executionEvent.getChildren() != null && !executionEvent.getChildren().isEmpty()) {
                    int partitionSize = TestLogEventsLazyPathContentProvider.computePartitionSize(executionEvent.getChildren().size());
                    child = partitionSize > 1 ? this.createPartition(executionEvent.getChildren(), partitionSize, index) : (TPFExecutionEvent)executionEvent.getChildren().get(index);
                }
            }
        }
        this.updateTreeViewer(parentPath, index, child);
    }

    private void updateTreeViewer(TreePath parentPath, int index, Object child) {
        if (child != null) {
            TreeViewer treeViewer = (TreeViewer)this.getViewer();
            if (index == 0) {
                Partition loadingPartition = new Partition(-1, -1, null);
                treeViewer.replace((Object)parentPath, index, (Object)loadingPartition);
            }
            int count = 0;
            Object child1 = this.getRegisteredParentChild(child);
            if (child1 != null) {
                if (child1 instanceof Collection) {
                    count = ((Collection)child1).size();
                    if (count > 30000) {
                        count = this.computeNumberOfParitions(((Collection)child1).size());
                    }
                } else {
                    count = 1;
                }
            }
            int count_in_display = count;
            treeViewer.replace((Object)parentPath, index, child);
            treeViewer.setChildCount(child, count_in_display);
        }
    }

    public Partition createPartition(EList list, int partitionSize, int index) {
        int offset = 0 + partitionSize * index;
        int length = list.size();
        int numPartitions = length / partitionSize;
        int remainder = length % partitionSize;
        if (remainder > 0) {
            ++numPartitions;
        }
        if (index <= numPartitions - 1) {
            Partition part = new Partition(offset, partitionSize, list);
            if (index == numPartitions - 1) {
                part = new Partition(offset, length - offset, list);
            }
            this.parts.add(part);
            return (Partition)this.parts.get(index);
        }
        return null;
    }

    public static int computePartitionSize(int valueQuantity) {
        int partitionSize = 1;
        try {
            int length = valueQuantity;
            int partitionDepth = 0;
            int preferredSize = 30000;
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0) {
                if (remainder == 0 && length == 1) break;
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            int i = 0;
            while (i < partitionDepth) {
                partitionSize *= preferredSize;
                ++i;
            }
        }
        catch (Exception exception) {}
        return partitionSize;
    }

    protected int computeNumberOfParitions(int childrenQuantity) {
        int length = childrenQuantity;
        try {
            int preferredSize = 30000;
            int remainder = length % preferredSize;
            length /= preferredSize;
            if (remainder > 0) {
                ++length;
            }
        }
        catch (Exception exception) {}
        return length;
    }

    public void updateChildCount(TreePath treePath, int currentChildCount) {
        Object element = this.getElement(treePath);
        int count = currentChildCount;
        if (element instanceof Partition) {
            count = ((Partition)element).getSize();
        } else if (element instanceof TPFExecutionHistory) {
            count = ((TPFExecutionHistory)element).getExecutionEvents().size();
            if (count > 30000) {
                count = this.computeNumberOfParitions(((TPFExecutionHistory)element).getExecutionEvents().size());
            }
        } else if (element instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            if (executionResult.getExecutionHistory() != null && (count = executionResult.getExecutionHistory().getExecutionEvents().size()) > 30000) {
                count = this.computeNumberOfParitions(((TPFExecutionHistory)element).getExecutionEvents().size());
            }
        } else if (element instanceof TPFExecutionEvent && !(element instanceof TPFInvocationEvent)) {
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
            if (executionEvent.getChildren() != null && !executionEvent.getChildren().isEmpty()) {
                count = executionEvent.getChildren().size();
            }
            if (count > 30000) {
                count = this.computeNumberOfParitions(executionEvent.getChildren().size());
            }
        }
        if (count != currentChildCount) {
            ((TreeViewer)this.getViewer()).setChildCount((Object)treePath, count);
        }
    }

    public void updateHasChildren(TreePath path) {
        Object element = this.getElement(path);
        TreeViewer viewer = (TreeViewer)this.getViewer();
        if (element instanceof Partition) {
            viewer.setHasChildren((Object)path, true);
        } else if (element instanceof TPFExecutionHistory) {
            if (((TPFExecutionHistory)element).getExecutionEvents().size() > 30000) {
                viewer.setChildCount((Object)path, ((TPFExecutionHistory)element).getExecutionEvents().size() / TestLogEventsLazyPathContentProvider.computePartitionSize(((TPFExecutionHistory)element).getExecutionEvents().size()));
            } else {
                viewer.setChildCount((Object)path, ((TPFExecutionHistory)element).getExecutionEvents().size());
            }
        } else if (element instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            if (executionResult.getExecutionHistory() != null) {
                if (executionResult.getExecutionHistory().getExecutionEvents().size() > 30000) {
                    viewer.setChildCount((Object)path, executionResult.getExecutionHistory().getExecutionEvents().size() / TestLogEventsLazyPathContentProvider.computePartitionSize(executionResult.getExecutionHistory().getExecutionEvents().size()));
                } else {
                    viewer.setChildCount((Object)path, executionResult.getExecutionHistory().getExecutionEvents().size());
                }
            }
        } else if (element instanceof TPFExecutionEvent) {
            if (element instanceof TPFInvocationEvent) {
                viewer.setHasChildren((Object)path, false);
            } else {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
                if (executionEvent.getChildren().size() > 30000) {
                    viewer.setChildCount((Object)path, executionEvent.getChildren().size() / TestLogEventsLazyPathContentProvider.computePartitionSize(executionEvent.getChildren().size()));
                } else {
                    viewer.setHasChildren((Object)path, executionEvent.getChildren() != null && executionEvent.getChildren().size() > 0);
                }
            }
        }
    }

    protected Object getElement(TreePath path) {
        if (path.getSegmentCount() > 0) {
            return path.getLastSegment();
        }
        return this.getViewer().getInput();
    }
}

