/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.util;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;

public class TestLogVerdictCollection
implements ITestLogVerdictTraversal {
    public static final int VERDICT_TYPE_ALL = 4;
    private TPFExecutionResult execResult;
    private Hashtable verdictLists;

    public TestLogVerdictCollection(TPFExecutionResult result) {
        this.execResult = result;
    }

    public boolean contains(int verdictType) {
        return this.getVerdictLists().get(new Integer(verdictType)) != null;
    }

    public boolean hasPrevious(int verdictType, Object current) {
        return this.getPrevious(verdictType, current) != null;
    }

    public boolean hasNext(int verdictType, Object current) {
        return this.getNext(verdictType, current) != null;
    }

    public TPFVerdictEvent getFirst(int verdictType) {
        List verdicts = (List)this.getVerdictLists().get(new Integer(verdictType));
        if (verdicts != null) {
            return (TPFVerdictEvent)verdicts.get(0);
        }
        return null;
    }

    public TPFVerdictEvent getLast(int verdictType) {
        List verdicts = (List)this.getVerdictLists().get(new Integer(verdictType));
        if (verdicts != null) {
            return (TPFVerdictEvent)verdicts.get(verdicts.size() - 1);
        }
        return null;
    }

    public TPFVerdictEvent getNext(int verdictType, Object current) {
        if (current == null) {
            return this.getFirst(verdictType);
        }
        if (current instanceof TPFVerdictEvent) {
            return this.getNextVerdict(verdictType, (TPFVerdictEvent)current);
        }
        return this.getNextVerdict(verdictType, current);
    }

    public TPFVerdictEvent getPrevious(int verdictType, Object current) {
        if (current == null) {
            return this.getLast(verdictType);
        }
        if (current instanceof TPFVerdictEvent) {
            return this.getPreviousVerdict(verdictType, (TPFVerdictEvent)current);
        }
        return this.getPreviousVerdict(verdictType, current);
    }

    protected TPFVerdictEvent getPreviousVerdict(int verdictType, TPFVerdictEvent current) {
        if (verdictType == 4 || current.getVerdict().getValue() == verdictType) {
            int index;
            List verdicts = (List)this.getVerdictLists().get(new Integer(verdictType));
            if (verdicts != null && (index = verdicts.indexOf(current)) > 0) {
                return (TPFVerdictEvent)verdicts.get(index - 1);
            }
        } else {
            int index;
            List verdicts = (List)this.getVerdictLists().get(new Integer(4));
            if (verdicts != null && (index = verdicts.indexOf(current)) > 0) {
                int i = index - 1;
                while (i > -1) {
                    TPFVerdictEvent event = (TPFVerdictEvent)verdicts.get(i);
                    if (event.getVerdict().getValue() == verdictType) {
                        return event;
                    }
                    --i;
                }
            }
        }
        return null;
    }

    protected TPFVerdictEvent getPreviousVerdict(int verdictType, Object current) {
        TPFVerdictEvent verdict = null;
        Object parent = this.getParent(current);
        while (parent != null) {
            int index = this.getChildIndex(parent, current);
            verdict = this.searchPreviousVerdictInChildren(verdictType, parent, index);
            if (verdict != null) {
                return verdict;
            }
            current = parent;
            parent = this.getParent(current);
        }
        return null;
    }

    protected TPFVerdictEvent searchPreviousVerdictInChildren(int verdictType, Object parent, int index) {
        Object[] children = this.getChildren(parent);
        index = index == -1 ? children.length : index;
        int i = index - 1;
        while (i > -1) {
            TPFVerdictEvent verdict;
            if (children[i] instanceof TPFVerdictEvent) {
                if (verdictType == 4) {
                    return (TPFVerdictEvent)children[i];
                }
                if (((TPFVerdictEvent)children[i]).getVerdict().getValue() == verdictType) {
                    return (TPFVerdictEvent)children[i];
                }
            }
            if ((verdict = this.searchPreviousVerdictInChildren(verdictType, children[i], -1)) != null) {
                return verdict;
            }
            --i;
        }
        return null;
    }

    protected TPFVerdictEvent getNextVerdict(int verdictType, TPFVerdictEvent current) {
        if (verdictType == 4 || current.getVerdict().getValue() == verdictType) {
            int index;
            List verdicts = (List)this.getVerdictLists().get(new Integer(verdictType));
            if (verdicts != null && (index = verdicts.indexOf(current)) + 1 < verdicts.size()) {
                return (TPFVerdictEvent)verdicts.get(index + 1);
            }
        } else {
            int index;
            List verdicts = (List)this.getVerdictLists().get(new Integer(4));
            if (verdicts != null && (index = verdicts.indexOf(current)) + 1 < verdicts.size()) {
                int i = index + 1;
                while (i < verdicts.size()) {
                    TPFVerdictEvent event = (TPFVerdictEvent)verdicts.get(i);
                    if (event.getVerdict().getValue() == verdictType) {
                        return event;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    protected TPFVerdictEvent getNextVerdict(int verdictType, Object current) {
        TPFVerdictEvent verdict = this.searchNextVerdictInChildren(verdictType, current, -1);
        if (verdict != null) {
            return verdict;
        }
        Object parent = this.getParent(current);
        while (parent != null) {
            int index = this.getChildIndex(parent, current);
            verdict = this.searchNextVerdictInChildren(verdictType, parent, index);
            if (verdict != null) {
                return verdict;
            }
            current = parent;
            parent = this.getParent(current);
        }
        return null;
    }

    protected int getChildIndex(Object parent, Object child) {
        Object[] children = this.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected TPFVerdictEvent searchNextVerdictInChildren(int verdictType, Object parent, int index) {
        Object[] children = this.getChildren(parent);
        int i = index + 1;
        while (i < children.length) {
            TPFVerdictEvent verdict;
            if (children[i] instanceof TPFVerdictEvent) {
                if (verdictType == 4) {
                    return (TPFVerdictEvent)children[i];
                }
                if (((TPFVerdictEvent)children[i]).getVerdict().getValue() == verdictType) {
                    return (TPFVerdictEvent)children[i];
                }
            }
            if ((verdict = this.searchNextVerdictInChildren(verdictType, children[i], -1)) != null) {
                return verdict;
            }
            ++i;
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TPFExecutionHistory) {
            return ((TPFExecutionHistory)parent).getExecutionEvents().toArray();
        }
        if (parent instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if (executionResult.getExecutionHistory() != null) {
                return executionResult.getExecutionHistory().getExecutionEvents().toArray();
            }
        } else if (parent instanceof TPFExecutionEvent) {
            if (parent instanceof TPFInvocationEvent) {
                TPFInvocationEvent invocationEvent = (TPFInvocationEvent)parent;
                return new Object[]{invocationEvent.getInvokedExecutionResult()};
            }
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
            if (executionEvent.getChildren() != null && !executionEvent.getChildren().isEmpty()) {
                return executionEvent.getChildren().toArray();
            }
        }
        return new Object[0];
    }

    protected Object getParent(Object element) {
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            if (executionResult.getInvocationExecutionEvent() != null) {
                return executionResult.getInvocationExecutionEvent();
            }
        } else if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
            if (executionEvent.eContainer() instanceof TPFExecutionHistory) {
                TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
                TPFExecutionResult exres = exhis.getExecutionResult();
                if (exres.eContainer() == null) {
                    return exhis;
                }
                return exhis.getExecutionResult();
            }
            return executionEvent.eContainer();
        }
        return null;
    }

    public TPFExecutionResult getExecutionResult() {
        return this.execResult;
    }

    protected synchronized void collectVerdicts(TPFExecutionResult result) {
        this.verdictLists = new Hashtable();
        EList lists = result.getVerdictLists();
        TPFVerdictList verdictList2 = null;
        EList verdictEvents = null;
        for (TPFVerdictList verdictList2 : lists) {
            verdictEvents = verdictList2.getVerdictEvents();
            if (verdictEvents == null || verdictEvents.isEmpty()) continue;
            if ("allTypes".equals(verdictList2.getType())) {
                this.verdictLists.put(new Integer(4), verdictEvents);
                continue;
            }
            int type = ((TPFVerdictEvent)verdictEvents.get(0)).getVerdict().getValue();
            this.verdictLists.put(new Integer(type), verdictEvents);
        }
    }

    protected Hashtable getVerdictLists() {
        if (this.verdictLists == null) {
            this.verdictLists = new Hashtable();
            this.collectVerdicts(this.execResult);
        }
        return this.verdictLists;
    }
}

