/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.internal.action.FailAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class GetNextFailAction
extends FailAction {
    public GetNextFailAction() {
        super(UiPluginResourceBundle.LBL_NEXT_ERROR);
        this.setToolTipText(UiPluginResourceBundle.TOOLTIP_NEXT_ERROR);
    }

    public void dispose() {
        super.dispose();
    }

    public void run() {
        StructuredSelection newSelection;
        this.setActionPerformed(false);
        EObject objectSelection = (EObject)this.getStructuredSelection().getFirstElement();
        EObject parent = (EObject)this.getEcp().getParent(objectSelection);
        int childIndex = -1;
        if (parent instanceof TPFExecutionHistory) {
            parent = ((TPFExecutionHistory)parent).getExecutionResult();
        }
        childIndex = this.getChildIndex(parent, objectSelection);
        Object nextFail = this.checkAllChildren(objectSelection);
        if (nextFail != null) {
            newSelection = new StructuredSelection(nextFail);
            this.getStructuredViewer().setSelection((ISelection)newSelection, true);
        } else {
            nextFail = this.getVerdictEvent(parent, childIndex);
            if (nextFail != null) {
                newSelection = new StructuredSelection(nextFail);
                this.getStructuredViewer().setSelection((ISelection)newSelection, true);
            }
        }
        if (nextFail == null) {
            while (!(parent instanceof TPFExecutionResult)) {
                parent = (EObject)this.getEcp().getParent(parent);
                if (parent != null) continue;
                return;
            }
            TPFExecutionResult er = (TPFExecutionResult)parent;
            if (!this.hasFail(er)) {
                return;
            }
            nextFail = this.getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0), -1);
            StructuredSelection newSelection2 = new StructuredSelection(nextFail);
            this.getStructuredViewer().setSelection((ISelection)newSelection2, true);
        }
        this.setActionPerformed(true);
    }

    protected Object getVerdictEvent(Object parent, int childIndex) {
        Object fail;
        Object[] children = this.getEcp().getChildren(parent);
        int i = childIndex + 1;
        while (i < children.length) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent && (((TPFVerdictEvent)child).getVerdict().getValue() == 2 || ((TPFVerdictEvent)child).getVerdict().getValue() == 3)) {
                return child;
            }
            Object returnObject = this.checkAllChildren(child);
            if (returnObject != null) {
                return returnObject;
            }
            ++i;
        }
        EObject currentParent = (EObject)this.getEcp().getParent(parent);
        if (currentParent == null) {
            return null;
        }
        if (currentParent instanceof TPFExecutionHistory) {
            currentParent = ((TPFExecutionHistory)currentParent).getExecutionResult();
        }
        if ((fail = this.getVerdictEvent(currentParent, childIndex = this.getChildIndex(currentParent, parent))) != null) {
            return fail;
        }
        return null;
    }

    public Object checkAllChildren(Object parent) {
        Object[] children = this.getEcp().getChildren(parent);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent && (((TPFVerdictEvent)child).getVerdict().getValue() == 2 || ((TPFVerdictEvent)child).getVerdict().getValue() == 3)) {
                return child;
            }
            Object returnObject = this.checkAllChildren(child);
            if (returnObject != null) {
                return returnObject;
            }
            ++i;
        }
        return null;
    }

    public boolean hasFail(TPFExecutionResult er) {
        return this.getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0), -1) != null;
    }
}

