/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.component;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProxyNodeContentProvider
implements ITreeContentProvider {
    private int filter = 4;
    private String[] fileExtensions = null;
    public static final int FILTER_FOLDERS = 2;
    public static final int SHOW_ALL = 4;

    public ProxyNodeContentProvider(String[] fileExtensions) {
        if (fileExtensions == null || fileExtensions.length == 0) {
            throw new IllegalArgumentException();
        }
        this.fileExtensions = fileExtensions;
    }

    public void setFilter(int filter) {
        this.filter = filter;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            if (this.filter == 2) {
                ArrayList<Object> elements = new ArrayList<Object>();
                IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
                int counter = 0;
                while (counter < projects.length) {
                    if (projects[counter].isAccessible()) {
                        Object[] children = this.getChildren(projects[counter]);
                        int index = 0;
                        while (index < children.length) {
                            elements.add(children[index]);
                            ++index;
                        }
                    }
                    ++counter;
                }
                return elements.toArray();
            }
            ArrayList<IProject> elements = new ArrayList<IProject>();
            IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
            int counter = 0;
            while (counter < projects.length) {
                if (projects[counter].isAccessible() && !TestNavigator.getFiltersManager().filter(projects[counter])) {
                    elements.add(projects[counter]);
                }
                ++counter;
            }
            return elements.toArray();
        }
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        IResource resource;
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IProxyNode && this.filter == 4 && (resource = ((IProxyNode)element).getUnderlyingResource()) != null) {
            return resource.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            if (parentElement instanceof IProject && !((IProject)parentElement).isOpen()) {
                return new Object[0];
            }
            try {
                ArrayList<Object> children = new ArrayList<Object>();
                IResource[] resources = ((IContainer)parentElement).members();
                int counter = 0;
                while (counter < resources.length) {
                    int index;
                    if (resources[counter].getType() != 1) {
                        if (this.filter == 2) {
                            Object[] childResources = this.getChildren(resources[counter]);
                            index = 0;
                            while (index < childResources.length) {
                                if (!children.contains(childResources[index])) {
                                    children.add(childResources[index]);
                                }
                                ++index;
                            }
                        } else if (!children.contains(resources[counter]) && !TestNavigator.getFiltersManager().filter(resources[counter])) {
                            children.add(resources[counter]);
                        }
                    } else {
                        IFile file = (IFile)resources[counter];
                        index = 0;
                        while (index < this.fileExtensions.length) {
                            String extension = file.getFileExtension();
                            if (extension != null && extension.trim().equals(this.fileExtensions[index].trim())) {
                                IProxyNode proxyNode = FileProxyNodeCache.getInstance().getProxy(file);
                                if (proxyNode == null || children.contains(proxyNode) || TestNavigator.getFiltersManager().filter(proxyNode)) break;
                                children.add(proxyNode);
                                break;
                            }
                            ++index;
                        }
                    }
                    ++counter;
                }
                return children.toArray();
            }
            catch (CoreException c) {
                UiPlugin.logError(c);
            }
        } else if (parentElement instanceof IProxyNode) {
            return ((IProxyNode)parentElement).getChildren();
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

