/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProxyNodeLabelProvider
extends LabelProvider {
    private Map imageMap = new HashMap();

    public Image getImage(Object element) {
        if (element != null) {
            IWorkbenchAdapter adapter;
            if (element instanceof IProxyNode) {
                return ((IProxyNode)element).getImage();
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor imageDescriptor = adapter.getImageDescriptor(element);
                Image image = (Image)this.imageMap.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.imageMap.put(imageDescriptor, image);
                }
                return image;
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element != null) {
            IWorkbenchAdapter adapter;
            if (element instanceof IProxyNode) {
                if (element instanceof CMNNamedElementProxyNode) {
                    return ((CMNNamedElementProxyNode)element).getName();
                }
                return ((IProxyNode)element).getUnderlyingResource().getName();
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }
        return null;
    }

    public void dispose() {
        if (this.imageMap != null) {
            Iterator imageMapIterator = this.imageMap.values().iterator();
            while (imageMapIterator.hasNext()) {
                ((Image)imageMapIterator.next()).dispose();
            }
            this.imageMap.clear();
        }
        super.dispose();
    }
}

