/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeContentProvider;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeLabelProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ProxyNodeSelectionViewer {
    private TreeViewer assetViewer = null;
    private Button filterButton = null;
    private ProxyNodeContentProvider contentProvider = null;
    private List selectedProxyNodes = null;

    public ProxyNodeSelectionViewer(Composite parent, Object rootObject, String[] fileExtensions, int style) {
        this.createContents(parent, rootObject, fileExtensions, style);
    }

    public void setSelection() {
        ISelection selection = this.assetViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.selectedProxyNodes = new ArrayList();
            for (Object selectedElement : (IStructuredSelection)selection) {
                if (!(selectedElement instanceof IProxyNode)) continue;
                this.selectedProxyNodes.add((IProxyNode)selectedElement);
            }
        }
    }

    public Button getFilterButton() {
        return this.filterButton;
    }

    public TreeViewer getViewer() {
        return this.assetViewer;
    }

    public IProxyNode[] getSelectedProxyNodes() {
        if (this.selectedProxyNodes == null) {
            return new IProxyNode[0];
        }
        return this.selectedProxyNodes.toArray(new IProxyNode[this.selectedProxyNodes.size()]);
    }

    private void createContents(Composite parent, Object rootObject, String[] fileExtensions, int style) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        Tree tree = new Tree(composite, style);
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new ProxyNodeContentProvider(fileExtensions);
        this.contentProvider.setFilter(2);
        this.assetViewer = new TreeViewer(tree);
        this.assetViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.assetViewer.setLabelProvider((IBaseLabelProvider)new ProxyNodeLabelProvider());
        this.assetViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        });
        this.assetViewer.setInput(rootObject);
        this.assetViewer.expandToLevel(2);
        ((Tree)this.assetViewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyNodeSelectionViewer.this.setSelection();
            }
        });
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(UiPluginResourceBundle.SHOW_FOLDERS);
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProxyNodeSelectionViewer.this.filterButton.getSelection()) {
                    ProxyNodeSelectionViewer.this.contentProvider.setFilter(4);
                } else {
                    ProxyNodeSelectionViewer.this.contentProvider.setFilter(2);
                }
                ISelection selection = ProxyNodeSelectionViewer.this.assetViewer.getSelection();
                ProxyNodeSelectionViewer.this.assetViewer.refresh();
                if (!selection.isEmpty()) {
                    ProxyNodeSelectionViewer.this.assetViewer.setSelection(selection, true);
                }
            }
        });
    }
}

