/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.util.EObjectEditorInput;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;

public abstract class BaseEditorPart
extends HyadesEditorPart
implements INavigationLocationProvider {
    private ResourceSet resourceSet;
    private Class editorObjectClass;

    public BaseEditorPart(Class editoObjectClass) {
        this.editorObjectClass = editoObjectClass;
    }

    public void dispose() {
        if (this.resourceSet != null) {
            EMFUtil.removeAdapters((Iterator)this.resourceSet.getAllContents());
            this.resourceSet.eAdapters().clear();
            for (Resource resource : this.getResourceSet().getResources()) {
                if (!(resource instanceof FacadeResourceImpl)) continue;
                ((FacadeResourceImpl)resource).cleanup();
            }
            this.resourceSet.getResources().clear();
            this.resourceSet = null;
        }
        super.dispose();
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected IAssociationDescriptor identifyEditorDescriptor(IEditorInput input) throws PartInitException {
        this.initResourceSet();
        IAssociationDescriptor editorDescriptor = null;
        EObject eObject = null;
        if (input instanceof EObjectEditorInput) {
            eObject = this.getEObjectContent(((EObjectEditorInput)input).getEObject());
        } else if (input instanceof RCPFileEditorInput) {
            eObject = this.getFileContent(((RCPFileEditorInput)input).getIOFile());
        } else if (input instanceof IFileEditorInput) {
            eObject = this.getFileContent(((IFileEditorInput)input).getFile());
        } else if (input instanceof ILocationProvider) {
            ILocationProvider javaFileEditorInput = (ILocationProvider)input;
            eObject = this.getFileContent(javaFileEditorInput.getPath((Object)javaFileEditorInput).toFile());
        } else if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                FacadeResourceImpl res = new FacadeResourceImpl();
                res.setUseZip(true);
                res.setEncoding("UTF-8");
                InputStream inputStream = storage.getContents();
                try {
                    res.load(inputStream, EMFUtil.RESOURCE_OPTIONS);
                }
                finally {
                    inputStream.close();
                }
                EList content = res.getContents();
                if (content.size() == 1 && this.editorObjectClass.isInstance(content.get(0))) {
                    eObject = (EObject)content.get(0);
                    this.resourceSet.getResources().add((Object)res);
                }
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
        }
        if (eObject == null) {
            return null;
        }
        this.setEditorObject(eObject);
        editorDescriptor = this.identifyEditorDescriptor(eObject);
        return editorDescriptor;
    }

    protected abstract IAssociationDescriptor identifyEditorDescriptor(EObject var1);

    protected EObject getFileContent(IFile file) {
        EObject[] eObjects = EMFUtil.load((ResourceSet)this.resourceSet, (IFile)file);
        if (eObjects.length == 1 && this.editorObjectClass.isInstance(eObjects[0])) {
            return eObjects[0];
        }
        return null;
    }

    private void initResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        AdapterImpl adapterImpl = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Resource)) break;
                        ((Resource)msg.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        for (Object element : collection) {
                            if (!(element instanceof Resource)) continue;
                            ((Resource)element).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.resourceSet.eAdapters().add((Object)adapterImpl);
    }

    protected EObject getEObjectContent(EObject eObject) {
        if (this.editorObjectClass.isInstance(eObject)) {
            this.resourceSet.getResources().add((Object)eObject.eResource());
            return eObject;
        }
        return null;
    }

    protected EObject getFileContent(File file) {
        EObject[] eObjects = EMFUtil.load((ResourceSet)this.resourceSet, (URI)URI.createFileURI((String)file.getAbsolutePath()));
        if (eObjects.length == 1 && this.editorObjectClass.isInstance(eObjects[0])) {
            return eObjects[0];
        }
        return null;
    }

    protected EObject getFileContent(IPath path) {
        EObject[] eObjects = EMFUtil.load((ResourceSet)this.resourceSet, (String)path.toOSString());
        if (eObjects.length == 1 && this.editorObjectClass.isInstance(eObjects[0])) {
            return eObjects[0];
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        if (!(selection = this.adjustSelection(selection)).isEmpty()) {
            super.setSelection(selection);
        }
    }

    public ISelection adjustSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            int maxi = objects.length;
            while (i < maxi) {
                EObject adjusted = null;
                if (objects[i] instanceof EObject) {
                    adjusted = EMFUtil.getEObject((ResourceSet)this.getResourceSet(), (EObject)((EObject)objects[i]), (boolean)false);
                } else if (objects[i] instanceof Resource) {
                    adjusted = this.getResourceSet().getResource(((Resource)objects[i]).getURI(), false);
                }
                if (adjusted == null) {
                    return StructuredSelection.EMPTY;
                }
                objects[i] = adjusted;
                ++i;
            }
            selection = new StructuredSelection(objects);
        }
        return selection;
    }

    protected Class getEditorObjectClass() {
        return this.editorObjectClass;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        if (this.getEditorExtension() instanceof INavigationLocationProvider) {
            return ((INavigationLocationProvider)this.getEditorExtension()).createEmptyNavigationLocation();
        }
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        if (this.getEditorExtension() instanceof INavigationLocationProvider) {
            return ((INavigationLocationProvider)this.getEditorExtension()).createNavigationLocation();
        }
        return null;
    }
}

