/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.util.ResourceCache;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.editor.BaseEditorPart;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

public class ExecutionEditorPart
extends BaseEditorPart {
    private ResourceSet sharedResourceSet;
    private Adapter thisAdapter;
    private URI cachedURI;

    public ExecutionEditorPart() {
        super(TPFExecutionResult.class);
    }

    public String getFileExtension() {
        return "execution";
    }

    protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject) {
        IAssociationMapping editorAssociationMapping = TestUIExtension.getExecutionMappingRegistry().getAssociationMapping("editorExtensions");
        return editorAssociationMapping.getDefaultAssociationDescriptor();
    }

    public void dispose() {
        if (this.sharedResourceSet != null) {
            EMFUtil.removeAdapters((Iterator)this.sharedResourceSet.getAllContents(), (Adapter)this.thisAdapter);
            this.sharedResourceSet.eAdapters().remove((Object)this.thisAdapter);
            this.sharedResourceSet = null;
            ResourceCache.getInstance().releaseSharedResource(this.cachedURI);
        }
        super.dispose();
    }

    protected ResourceSet getResourceSet() {
        return this.sharedResourceSet;
    }

    protected EObject getFileContent(IFile file) {
        this.cachedURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource resource = ResourceCache.getInstance().getSharedResource(this.cachedURI);
        if (resource.getContents().size() != 1 || !this.getEditorObjectClass().isInstance(resource.getContents().get(0))) {
            return null;
        }
        this.sharedResourceSet = resource.getResourceSet();
        this.thisAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: {
                        if (!(msg.getNewValue() instanceof Resource)) break;
                        ((Resource)msg.getNewValue()).setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        for (Object element : collection) {
                            if (!(element instanceof Resource)) continue;
                            ((Resource)element).setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        };
        this.sharedResourceSet.eAdapters().add((Object)this.thisAdapter);
        return (EObject)resource.getContents().get(0);
    }
}

