/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.PropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConfigurableObjectEditorExtension
extends BaseEditorExtension
implements IExtensibleEditorExtension {
    IConfigurationElement[] propertyGroupExtensions;
    private Hashtable extensionPagesMap = new Hashtable();
    protected static final int PAGE_OVERVIEW = 0;
    private ConfigurableObjectOverviewForm overviewForm;
    private WidgetFactory widgetFactory;

    public ConfigurableObjectEditorExtension() {
        this.propertyGroupExtensions = this.collectPropertyGroupExtensions();
    }

    protected IConfigurationElement[] collectPropertyGroupExtensions() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".configurableObjectExtension");
        if (extPoint != null) {
            return extPoint.getConfigurationElements();
        }
        return new IConfigurationElement[0];
    }

    public IConfigurationElement[] getPropertyGroupExtensions() {
        return this.propertyGroupExtensions;
    }

    public void dispose() {
        this.overviewForm.dispose();
        Enumeration elements = this.extensionPagesMap.elements();
        while (elements.hasMoreElements()) {
            ((EditorForm)elements.nextElement()).dispose();
        }
        this.extensionPagesMap.clear();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
        }
        super.dispose();
    }

    public EObject getEditorObject() {
        return (EObject)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        this.widgetFactory = new WidgetFactory();
        this.overviewForm = this.createOverviewPage(this.widgetFactory);
        this.getHyadesEditorPart().addPage(this.overviewForm.createControl());
        this.getHyadesEditorPart().setPageText(0, UiPluginResourceBundle.W_OVERVIEW);
        this.overviewForm.updateTitle();
        this.createOtherStaticPages(this.widgetFactory);
        this.createPropertyGroupPages(this.widgetFactory);
    }

    protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory) {
        return new ConfigurableObjectOverviewForm(this, widgetFactory);
    }

    protected void createOtherStaticPages(WidgetFactory widgetFactory) {
    }

    protected void createPropertyGroupPages(WidgetFactory widgetFacotory) {
        EObject editorObject = this.getEditorObject();
        EList propertyGroups = null;
        if (editorObject instanceof CFGConfigurableObject) {
            propertyGroups = ((CFGConfigurableObject)editorObject).getPropertyGroups();
        }
        if (propertyGroups == null || propertyGroups.isEmpty()) {
            return;
        }
        Iterator it = propertyGroups.iterator();
        CFGPropertyGroup propGroup = null;
        String propGroupID = null;
        boolean extensionFound = false;
        while (it.hasNext()) {
            propGroup = (CFGPropertyGroup)it.next();
            if (propGroup.getProperties().isEmpty()) continue;
            propGroupID = propGroup.getPropertyGroupID();
            int i = 0;
            while (i < this.propertyGroupExtensions.length) {
                if (this.propertyGroupExtensions[i].getAttribute("propertyGroupID").equals(propGroupID)) {
                    this.addExtensionPage(this.propertyGroupExtensions[i]);
                    extensionFound = true;
                    break;
                }
                ++i;
            }
            if (extensionFound) continue;
            PropertyGroupForm defaultForm = new PropertyGroupForm();
            defaultForm.init(propGroup, this, this.widgetFactory);
            int index = this.getHyadesEditorPart().addPage(defaultForm.createControl());
            this.getHyadesEditorPart().setPageText(index, propGroup.getName());
            this.extensionPagesMap.put(new Integer(index), defaultForm);
            this.overviewForm.addSection(defaultForm, index);
        }
    }

    protected ConfigurableObjectOverviewForm getOverviewForm() {
        return this.overviewForm;
    }

    public void refreshContent(Object data) {
        this.overviewForm.load();
        this.overviewForm.updateTitle();
    }

    public IStructuredSelection getSelection() {
        int index = this.getHyadesEditorPart().getActivePage();
        if (index == 0) {
            return new StructuredSelection((Object)this.getEditorObject());
        }
        if (this.extensionPagesMap.containsKey(new Integer(index))) {
            return ((IPropertyGroupForm)this.extensionPagesMap.get(new Integer(index))).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(IStructuredSelection structuredSelection) {
        EObject selectionPropertyEContainer;
        Object object = structuredSelection.getFirstElement();
        if (object instanceof CFGComparableProperty && (selectionPropertyEContainer = ((CFGComparableProperty)object).eContainer()) instanceof CFGPropertyGroup) {
            String selectionPropertyGroupId = ((CFGPropertyGroup)selectionPropertyEContainer).getPropertyGroupID();
            Iterator pageIndexes = this.extensionPagesMap.keySet().iterator();
            while (pageIndexes.hasNext()) {
                int pageIndex = (Integer)pageIndexes.next();
                IPropertyGroupForm propertyGroupForm = (IPropertyGroupForm)this.extensionPagesMap.get(new Integer(pageIndex));
                if (!propertyGroupForm.getPropertyGroup().getPropertyGroupID().equals(selectionPropertyGroupId)) continue;
                if (pageIndex >= this.getHyadesEditorPart().getPageCount()) break;
                this.getHyadesEditorPart().setActivePage(pageIndex);
                propertyGroupForm.selectReveal((ISelection)structuredSelection);
                break;
            }
        }
    }

    public boolean pageActivated(int index) {
        if (index == 0) {
            return this.overviewForm.activated();
        }
        if (this.extensionPagesMap.containsKey(new Integer(index))) {
            return ((EditorForm)this.extensionPagesMap.get(new Integer(index))).activated();
        }
        return false;
    }

    public int addExtensionPage(IConfigurationElement extensionElement) {
        String propertyGroupID = extensionElement.getAttribute("propertyGroupID");
        Enumeration keys = this.extensionPagesMap.keys();
        IPropertyGroupForm page = null;
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            page = (IPropertyGroupForm)this.extensionPagesMap.get(key);
            if (!page.getPropertyGroup().getPropertyGroupID().equals(propertyGroupID)) continue;
            return key;
        }
        IPropertyGroupForm formExt = null;
        try {
            formExt = (IPropertyGroupForm)extensionElement.createExecutableExtension("class");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (formExt instanceof IPropertyGroupForm) {
            formExt.init(this.getCFGPropertyGroup(extensionElement), this, this.widgetFactory);
        }
        formExt.setExtension(extensionElement);
        int index = this.getHyadesEditorPart().addPage(formExt.createControl());
        this.getHyadesEditorPart().setPageText(index, extensionElement.getAttribute("name"));
        this.extensionPagesMap.put(new Integer(index), formExt);
        this.overviewForm.addSection(formExt, index);
        return index;
    }

    private CFGPropertyGroup getCFGPropertyGroup(IConfigurationElement extensionElement) {
        EObject editorObject = this.getEditorObject();
        EList propertyGroups = null;
        if (editorObject instanceof CFGConfigurableObject) {
            propertyGroups = ((CFGConfigurableObject)editorObject).getPropertyGroups();
        }
        if (propertyGroups == null) {
            return null;
        }
        CFGPropertyGroup propertyGroup2 = null;
        String propertyGroupID = extensionElement.getAttribute("propertyGroupID");
        for (CFGPropertyGroup propertyGroup2 : propertyGroups) {
            if (propertyGroupID.equals(propertyGroup2.getPropertyGroupID())) break;
            propertyGroup2 = null;
        }
        if (propertyGroup2 == null) {
            String name = extensionElement.getAttribute("name");
            String description = extensionElement.getAttribute("description");
            propertyGroup2 = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propertyGroup2.setPropertyGroupID(propertyGroupID);
            propertyGroup2.setName(name);
            propertyGroup2.setDescription(description);
            ((CFGConfigurableObject)editorObject).getPropertyGroups().add((Object)propertyGroup2);
        }
        return propertyGroup2;
    }
}

