/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.RegisteredExtensionsSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ConfigurableObjectOverviewForm
extends EditorForm {
    private FormSection generalInfoSection;
    private RegisteredExtensionsSection propertyGroupsSection;
    private Hashtable propGroupSectionsMap = new Hashtable();
    private Composite leftColumnContainer;
    private Composite rightColumnContainer;

    public ConfigurableObjectOverviewForm(ConfigurableObjectEditorExtension editorExtension, WidgetFactory widgetFactory) {
        super(editorExtension, widgetFactory);
    }

    public void dispose() {
        if (this.generalInfoSection != null) {
            this.generalInfoSection.dispose();
            this.generalInfoSection = null;
        }
        Enumeration elements = this.propGroupSectionsMap.elements();
        while (elements.hasMoreElements()) {
            NamedElementsSection section = (NamedElementsSection)((Object)elements.nextElement());
            if (section == null) continue;
            section.dispose();
            Object var2_2 = null;
        }
        this.propGroupSectionsMap.clear();
        this.propGroupSectionsMap = null;
        super.dispose();
    }

    protected Composite getLeftColumnContainer() {
        return this.leftColumnContainer;
    }

    protected Composite getRightColumnContainer() {
        return this.rightColumnContainer;
    }

    protected FormSection getGeneralInfoSection() {
        return this.generalInfoSection;
    }

    protected void setGeneralInfoSection(FormSection section) {
        this.generalInfoSection = section;
    }

    protected EObject getDataObject() {
        return ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getEditorObject();
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        this.leftColumnContainer = this.createColumn(parent);
        this.rightColumnContainer = this.createColumn(parent);
        this.createGeneralInfoSection(this.leftColumnContainer);
        IConfigurationElement[] propertyGroupExtensions = ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getPropertyGroupExtensions();
        if (propertyGroupExtensions != null && propertyGroupExtensions.length > 0) {
            this.createPropertyGroupExtensionsSection(this.leftColumnContainer);
        }
    }

    protected void createGeneralInfoSection(Composite parent) {
        this.generalInfoSection = new GeneralInfoSection(this, true);
        ((GeneralInfoSection)this.generalInfoSection).setEditable(true);
        this.registerSection(this.generalInfoSection);
        Control control = this.generalInfoSection.createControl(parent, this.getWidgetFactory());
        GridData gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        this.setGeneralInfoSectionHelp(control);
    }

    protected void setGeneralInfoSectionHelp(Control control) {
    }

    protected RegisteredExtensionsSection createPropertyGroupExtensionsSection(Composite parent) {
        IConfigurationElement[] propertyGroupExtensions = ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getPropertyGroupExtensions();
        if (propertyGroupExtensions == null) {
            return null;
        }
        this.propertyGroupsSection = new RegisteredExtensionsSection((ConfigurableObjectEditorExtension)this.getBaseEditorExtension(), propertyGroupExtensions);
        this.registerSection(this.propertyGroupsSection);
        this.propertyGroupsSection.setHeaderText(UiPluginResourceBundle.EDT_REGISTERED_PROP_GROUPS);
        this.propertyGroupsSection.setDescription(UiPluginResourceBundle.EDT_REG_PROP_GRP_DSC);
        Control control = this.propertyGroupsSection.createControl(parent, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(770));
        return this.propertyGroupsSection;
    }

    protected RegisteredExtensionsSection getPropertyGroupsSection() {
        return this.propertyGroupsSection;
    }

    public void addSection(IPropertyGroupForm propGroupExtensionForm, int pageIndex) {
        NamedElementsSection section = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), pageIndex);
        this.registerSection(section);
        section.createControl(this.rightColumnContainer, this.getWidgetFactory(), propGroupExtensionForm.getName(), propGroupExtensionForm.getDescription());
        CFGPropertyGroup propertyGroup = propGroupExtensionForm.getPropertyGroup();
        this.propGroupSectionsMap.put(propertyGroup, section);
        section.initialize((EObject)propertyGroup, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), null, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                CFGCategory type;
                if (element instanceof CFGComparableProperty && (type = ((CFGComparableProperty)element).getType()) != null) {
                    return type.getDisplayName();
                }
                return ((CMNNamedElement)element).getName();
            }
        });
    }

    public void load() {
        ((GeneralInfoSection)this.generalInfoSection).setInput(this.getDataObject());
    }

    public void updateTitle() {
        String title = ((IWorkbenchAdapter)((IAdaptable)this.getDataObject()).getAdapter(IWorkbenchAdapter.class)).getLabel((Object)this.getDataObject());
        if (title != null) {
            ((IHyadesEditorPartExtended)this.getBaseEditorExtension().getHyadesEditorPart()).setEditorTitle(title);
        }
    }

    public boolean activated() {
        return true;
    }
}

