/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ExecutionEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.CommonEventSection;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionEventDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionResultDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class EventForm
extends EditorForm
implements ISelectionChangedListener {
    private EObjectTreeSection eventSection;
    private CommonEventSection commonEventSection;
    private DetailSection eventDetailSection;
    private DetailSection executionResultDetailSection;
    private StyledText defaultText;
    private PageBook rightColumnPageBook;
    private boolean firstActivation = true;

    public EventForm(ExecutionEditorExtension executionEditorExtension, WidgetFactory widgetFactory) {
        super(executionEditorExtension, widgetFactory);
        this.setHeadingText(UiPluginResourceBundle.W_EXECUTION);
    }

    public void dispose() {
        this.eventSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.eventSection.dispose();
        this.commonEventSection.dispose();
        this.eventDetailSection.dispose();
        super.dispose();
    }

    protected TPFExecutionResult getExecution() {
        return ((ExecutionEditorExtension)this.getBaseEditorExtension()).getExecution();
    }

    protected void createEditorFormContents(Composite parent) {
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".exed0002");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        this.eventSection = new EventSection(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents(), null);
        this.eventSection.setTreeStryle(65540);
        this.registerSection(this.eventSection);
        this.eventSection.setHeaderText(UiPluginResourceBundle.W_EVENTS);
        Control control = this.eventSection.createControl(leftColumn, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.rightColumnPageBook = new PageBook(rightColumn, 0);
        this.rightColumnPageBook.setLayoutData((Object)GridDataUtil.createFill());
        this.rightColumnPageBook.setBackground(this.getWidgetFactory().getBackgroundColor());
        this.rightColumnPageBook.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        this.rightColumnPageBook.setMenu(parent.getMenu());
        Composite defaultControl = this.getWidgetFactory().createComposite((Composite)this.rightColumnPageBook);
        defaultControl.setLayout((Layout)new GridLayout());
        defaultControl.setLayoutData((Object)GridDataUtil.createFill());
        this.getWidgetFactory().createLabel(defaultControl, "");
        this.defaultText = this.getWidgetFactory().createStyledText(defaultControl, 65540);
        this.defaultText.setLayoutData((Object)GridDataUtil.createFill());
        this.defaultText.setEnabled(false);
        this.getWidgetFactory().paintBordersFor(defaultControl);
        Composite eventComposite = this.getWidgetFactory().createComposite((Composite)this.rightColumnPageBook);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        eventComposite.setLayout((Layout)gridLayout);
        eventComposite.setLayoutData((Object)GridDataUtil.createFill());
        this.commonEventSection = new CommonEventSection(this);
        this.commonEventSection.setHeaderText(UiPluginResourceBundle.TTL_CMN_PROPS);
        this.registerSection(this.commonEventSection);
        control = this.commonEventSection.createControl(eventComposite, this.getWidgetFactory());
        GridData gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        this.eventDetailSection = new DetailSection(this);
        this.eventDetailSection.setDetailPageProvider(new ExecutionEventDetailPageProvider());
        this.eventDetailSection.setHeaderText(UiPluginResourceBundle.TTL_DTL_PROPS);
        this.registerSection(this.eventDetailSection);
        control = this.eventDetailSection.createControl(eventComposite, this.getWidgetFactory());
        gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        this.executionResultDetailSection = new DetailSection(this);
        this.executionResultDetailSection.setDetailPageProvider(new ExecutionResultDetailPageProvider());
        this.executionResultDetailSection.setHeaderText(UiPluginResourceBundle.W_SUMMARY);
        this.registerSection(this.executionResultDetailSection);
        control = this.executionResultDetailSection.createControl((Composite)this.rightColumnPageBook, this.getWidgetFactory());
        gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        this.rightColumnPageBook.showPage((Control)eventComposite);
        ((GridData)this.rightColumnPageBook.getLayoutData()).heightHint = eventComposite.computeSize((int)-1, (int)-1, (boolean)true).y;
    }

    public void revealSelect(Object element) {
        if (this.eventSection != null) {
            StructuredSelection selection = null;
            this.eventSection.getTreeViewer().reveal(element);
            selection = new StructuredSelection(element);
            this.eventSection.getTreeViewer().setSelection((ISelection)selection);
        }
    }

    public void load() {
        this.updateDefaultText();
        this.eventSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.setInputPreservingExpandedElements();
        this.eventSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void setInputPreservingExpandedElements() {
        Object[] expandedElements = this.eventSection.getTreeViewer().getExpandedElements();
        int i = 0;
        int maxi = expandedElements.length;
        while (i < maxi) {
            if (expandedElements[i] instanceof EObject) {
                expandedElements[i] = EcoreUtil.getURI((EObject)((EObject)expandedElements[i]));
            }
            ++i;
        }
        this.eventSection.setInput(this.getExecution().getExecutionHistory());
        i = 0;
        maxi = expandedElements.length;
        while (i < maxi) {
            if (expandedElements[i] instanceof URI) {
                expandedElements[i] = this.getExecution().eResource().getResourceSet().getEObject((URI)expandedElements[i], false);
            }
            ++i;
        }
        try {
            this.eventSection.getTreeViewer().setExpandedElements(expandedElements);
        }
        catch (Exception exception) {}
    }

    protected void updateDefaultText() {
        String text = null;
        text = this.getExecution() == null || this.getExecution().getExecutionHistory() == null || this.getExecution().getExecutionHistory().getExecutionEvents().isEmpty() ? UiPluginResourceBundle.MSG_NO_EVE : UiPluginResourceBundle.MSG_NO_EVE_SEL;
        this.defaultText.setText(text);
    }

    public void selectReveal(ISelection selection) {
        this.eventSection.selectReveal(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.eventSection.getTreeViewer()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.getSelection();
            if (structuredSelection.size() == 1) {
                Object selection = structuredSelection.getFirstElement();
                if (selection instanceof TPFExecutionEvent) {
                    this.commonEventSection.setInput(selection);
                    if (this.eventDetailSection != null) {
                        this.eventDetailSection.setInput(selection);
                    }
                    this.rightColumnPageBook.showPage(this.rightColumnPageBook.getChildren()[1]);
                    return;
                }
                if (selection instanceof TPFExecutionResult) {
                    this.executionResultDetailSection.setInput(selection);
                    this.rightColumnPageBook.showPage(this.rightColumnPageBook.getChildren()[2]);
                    return;
                }
            }
            this.updateDefaultText();
            this.rightColumnPageBook.showPage(this.rightColumnPageBook.getChildren()[0]);
        }
    }

    public ISelection getSelection() {
        return this.eventSection.getTreeViewer().getSelection();
    }

    public boolean activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.eventSection.setFocus();
        }
        return super.activated();
    }

    public void updateTitle() {
    }
}

