/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.InvocationEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.LoopEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.MessageEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.TimedEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.TypedEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.VerdictEventDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;

public class ExecutionEventDetailPageProvider
implements DetailSection.IDetailPageProvider {
    private HashMap classToDefaultPageMap = new HashMap();
    private HashMap typeToPageMap = new HashMap();
    private List typesWithNoExtension = new ArrayList();

    public ExecutionEventDetailPageProvider() {
        this.buildDefaultPageMap();
    }

    private void buildDefaultPageMap() {
        this.classToDefaultPageMap.put(TPFTypedEvent.class, new TypedEventDetailPage());
        this.classToDefaultPageMap.put(TPFMessageEvent.class, new MessageEventDetailPage());
        this.classToDefaultPageMap.put(TPFInvocationEvent.class, new InvocationEventDetailPage());
        this.classToDefaultPageMap.put(TPFVerdictEvent.class, new VerdictEventDetailPage());
        this.classToDefaultPageMap.put(TPFLoopEvent.class, new LoopEventDetailPage());
        this.classToDefaultPageMap.put(TPFTimedEvent.class, new TimedEventDetailPage());
        this.classToDefaultPageMap.put(TPFWaitEvent.class, new TimedEventDetailPage());
    }

    private IDetailPage getExtensionPage(String eventType) {
        if (this.typesWithNoExtension.contains(eventType)) {
            return null;
        }
        IDetailPage page = (IDetailPage)this.typeToPageMap.get(eventType);
        if (page == null) {
            IDetailPageFactory provider = ExecutionHistoryExtensionsManager.getInstance().getEventDetailPageFactory(eventType);
            if (provider != null) {
                page = provider.createExecutionEventDetailPage(eventType);
            }
            if (page == null) {
                this.typesWithNoExtension.add(eventType);
            } else {
                this.typeToPageMap.put(eventType, page);
            }
        }
        return page;
    }

    public IDetailPage getDetailPage(Object element) {
        IDetailPage page = null;
        if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent event = (TPFExecutionEvent)element;
            String type = event.getEventType();
            if (type != null && !"".equals(type)) {
                page = this.getExtensionPage(type);
            }
            if (page == null) {
                for (Map.Entry entry : this.classToDefaultPageMap.entrySet()) {
                    if (!((Class)entry.getKey()).isAssignableFrom(element.getClass())) continue;
                    page = (IDetailPage)entry.getValue();
                    break;
                }
            }
        }
        return page;
    }

    public void dispose() {
        for (IDetailPage page : this.classToDefaultPageMap.values()) {
            page.dispose();
        }
        for (IDetailPage page : this.typeToPageMap.values()) {
            page.dispose();
        }
    }
}

