/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ExecutionEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionResultDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionForm
extends EditorForm {
    private ExecutionSection executionSection;
    private DetailSection detailSection;

    protected TPFVerdictEvent getFirstFailEvent(TPFExecutionResult result) {
        return this.getFirstFailEvent((List)result.getExecutionHistory().getExecutionEvents());
    }

    protected TPFVerdictEvent getFirstFailEvent(List executionEvents) {
        for (TPFExecutionEvent event : executionEvents) {
            TPFVerdictEvent vEvent;
            TPFInvocationEvent iEvent;
            TPFExecutionResult result;
            Object firstFail = event instanceof TPFInvocationEvent ? ((result = (iEvent = (TPFInvocationEvent)event).getInvokedExecutionResult()) != null && (result.getVerdict() == TPFVerdict.FAIL_LITERAL || result.getVerdict() == TPFVerdict.ERROR_LITERAL) ? this.getFirstFailEvent(result) : null) : (event instanceof TPFVerdictEvent ? ((vEvent = (TPFVerdictEvent)event).getVerdict() == TPFVerdict.FAIL_LITERAL || vEvent.getVerdict() == TPFVerdict.ERROR_LITERAL ? vEvent : null) : this.getFirstFailEvent((List)event.getChildren()));
            if (firstFail == null) continue;
            return firstFail;
        }
        return null;
    }

    public ExecutionForm(ExecutionEditorExtension executionEditorExtension, WidgetFactory widgetFactory) {
        super(executionEditorExtension, widgetFactory);
        this.setHeadingText(UiPluginResourceBundle.W_EXECUTION);
    }

    public void dispose() {
        this.executionSection.dispose();
        this.executionSection = null;
        this.detailSection.dispose();
        super.dispose();
    }

    public TPFExecutionResult getExecution() {
        return ((ExecutionEditorExtension)this.getBaseEditorExtension()).getExecution();
    }

    public Control createControl() {
        Control control = super.createControl();
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".exed0001");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        Control control = this.createGenericInformation(leftColumn);
        control.setLayoutData((Object)new GridData(1810));
        this.detailSection = new DetailSection(this);
        this.detailSection.setDetailPageProvider(new ExecutionResultDetailPageProvider());
        this.detailSection.setHeaderText(UiPluginResourceBundle.W_SUMMARY);
        this.registerSection(this.detailSection);
        control = this.detailSection.createControl(rightColumn, this.getWidgetFactory());
        GridData gridData = new GridData(1810);
        control.setLayoutData((Object)gridData);
    }

    protected Control createGenericInformation(Composite parent) {
        this.executionSection = new ExecutionSection(this);
        this.registerSection(this.executionSection);
        this.executionSection.setHeaderText(UiPluginResourceBundle.EDT_GENERAL_INFO);
        this.executionSection.setDescription(UiPluginResourceBundle.EDT_GENERAL_DSC);
        return this.executionSection.createControl(parent, this.getWidgetFactory());
    }

    public void load() {
        this.executionSection.setInput(this.getExecution());
        this.detailSection.setInput(this.getExecution());
    }

    public void updateTitle() {
        String title = ((IWorkbenchAdapter)this.getExecution().getAdapter(IWorkbenchAdapter.class)).getLabel((Object)this.getExecution());
        if (title != null) {
            ((IHyadesEditorPartExtended)this.getBaseEditorExtension().getHyadesEditorPart()).setEditorTitle(title);
        }
    }

    public boolean activated() {
        return true;
    }

    private class ExecutionSection
    extends NamedElementSection
    implements IHyperlinkListener {
        private StyledText fileText;
        private SelectableFormLabel gotoFirstErrorLink;
        private TPFVerdictEvent firstFailEvent;

        public ExecutionSection(EditorForm editorForm) {
            super(editorForm);
        }

        protected void addSouthControls(Composite parent, WidgetFactory widgetFactory) {
            Composite detailComposite = ExecutionForm.this.getWidgetFactory().createComposite(parent);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            detailComposite.setLayout((Layout)gridLayout);
            detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            ExecutionForm.this.getWidgetFactory().createLabel(detailComposite, UiPluginResourceBundle.L_FILE);
            this.fileText = ExecutionForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
            this.fileText.setEnabled(false);
            this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.fileText, String.valueOf(UiPlugin.getID()) + ".depf0002");
            this.gotoFirstErrorLink = widgetFactory.createSelectableLabel(parent, "");
            widgetFactory.turnIntoHyperlink((Control)this.gotoFirstErrorLink, this);
        }

        public void linkActivated(Control linkLabel) {
            if (this.firstFailEvent == null) {
                this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().setActivePage(1);
            } else {
                this.getEditorForm().getBaseEditorExtension().setSelection((IStructuredSelection)new StructuredSelection((Object)this.firstFailEvent));
            }
        }

        public void linkEntered(Control linkLabel) {
        }

        public void linkExited(Control linkLabel) {
        }

        public void setInput(Object object) {
            super.setInput(object);
            TPFExecutionResult execResult = ExecutionForm.this.getExecution();
            if (execResult.eResource() != null) {
                this.fileText.setText(EMFUtil.getFilePath((EObject)ExecutionForm.this.getExecution()));
            } else {
                this.fileText.setText("<not saved>");
            }
            TPFVerdictEvent event = ExecutionForm.this.getFirstFailEvent(execResult);
            this.setFirstFailEvent(event);
        }

        public void setFirstFailEvent(TPFVerdictEvent event) {
            this.firstFailEvent = event;
            if (this.firstFailEvent == null) {
                this.gotoFirstErrorLink.setText(UiPluginResourceBundle.ExecutionForm_goToEventsPageLink);
                this.gotoFirstErrorLink.setToolTipText(UiPluginResourceBundle.ExecutionForm_goToEventsPageTooltip);
            } else {
                this.gotoFirstErrorLink.setText(UiPluginResourceBundle.ExecutionForm_goToFirstFailLink);
                this.gotoFirstErrorLink.setToolTipText(UiPluginResourceBundle.ExecutionForm_goToFirstFailTooltip);
            }
        }
    }
}

