/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionResultDetailPage
extends AbstractDetailPage
implements IHyperlinkListener {
    private SelectableFormLabel testLink;
    private Label imageLabel;
    private StyledText typeText;
    private StyledText fileText;
    private StyledText hostnameText;
    private StyledText verdictText;
    private StyledText startText;
    private StyledText stopText;
    private Composite mainComposite;
    private TPFExecutionResult executionResult;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.executionResult = null;
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context) {
        this.context = context;
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        this.mainComposite = widgetFactory.createComposite(parent);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)GridDataUtil.createFill());
        this.createTestLink(this.mainComposite);
        widgetFactory.createLabel(this.mainComposite, "").setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(this.mainComposite, UiPluginResourceBundle.LBL_VERD);
        this.verdictText = widgetFactory.createStyledText(this.mainComposite, 65540);
        this.verdictText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.verdictText.setEditable(false);
        widgetFactory.createLabel(this.mainComposite, UiPluginResourceBundle.LBL_START);
        this.startText = widgetFactory.createStyledText(this.mainComposite, 65540);
        this.startText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.startText.setEditable(false);
        widgetFactory.createLabel(this.mainComposite, UiPluginResourceBundle.LBL_STOP);
        this.stopText = widgetFactory.createStyledText(this.mainComposite, 65540);
        this.stopText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.stopText.setEditable(false);
        widgetFactory.paintBordersFor(this.mainComposite);
        return this.mainComposite;
    }

    protected void createTestLink(Composite parent) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite linkComposite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        linkComposite.setLayout((Layout)gridLayout);
        linkComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.imageLabel = widgetFactory.createLabel(linkComposite, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        this.testLink = widgetFactory.createSelectableLabel(linkComposite, "");
        this.testLink.setText(UiPluginResourceBundle.NO_TST_TO_INV);
        this.testLink.setToolTipText(UiPluginResourceBundle.TIP_EXE_TEST);
        widgetFactory.turnIntoHyperlink((Control)this.testLink, this);
        Composite detailComposite = widgetFactory.createComposite(parent);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        detailComposite.setLayout((Layout)gridLayout);
        detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.L_TYPE);
        this.typeText = widgetFactory.createStyledText(detailComposite, 65540);
        this.typeText.setEnabled(false);
        this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.L_FILE);
        this.fileText = widgetFactory.createStyledText(detailComposite, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.LBL_HOST_NME);
        this.hostnameText = widgetFactory.createStyledText(detailComposite, 65540);
        this.hostnameText.setText("localhost");
        this.hostnameText.setEnabled(false);
        this.hostnameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    protected void createDeploymentLinks(TPFDeployment deployment, TPFTestSuite test) {
        if (deployment == null || test == null) {
            return;
        }
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        widgetFactory.createLabel(this.mainComposite, "").setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Composite linkComposite = widgetFactory.createComposite(this.mainComposite);
        linkComposite.setLayout((Layout)new GridLayout(2, false));
        linkComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.createLink(linkComposite, deployment, TestUIImages.INSTANCE.getImage("deployment_obj.gif"), deployment.getName(), UiPluginResourceBundle.TIP_DEPLOYMENT_USED);
        CFGLocation location = ConfigurationUtil.searchLocationWithTestAsset((CFGClass)test, (TPFDeployment)deployment);
        if (location != null) {
            this.createLink(linkComposite, location, TestUIImages.INSTANCE.getImage("location_obj.gif"), location.getName(), UiPluginResourceBundle.TIP_LOCATION_USED);
            if (location instanceof CMNNodeType) {
                this.hostnameText.setText(((CMNNodeType)location).getHostname());
            }
        }
    }

    protected void createLink(Composite linkComposite, Object linkData, Image linkImage, String linkText, String linkTooltip) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        if (linkImage != null) {
            Label image = widgetFactory.createLabel(linkComposite, "");
            image.setImage(linkImage);
        }
        SelectableFormLabel link = widgetFactory.createSelectableLabel(linkComposite, linkText);
        link.setToolTipText(linkTooltip);
        widgetFactory.turnIntoHyperlink((Control)link, this);
        link.setData(linkData);
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.executionResult = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean doPack = false;
        boolean testIsSet = false;
        if (object instanceof TPFExecutionResult) {
            this.executionResult = (TPFExecutionResult)object;
            TPFTest test = this.executionResult.getTest();
            doPack = true;
            if (test != null) {
                String value;
                IWorkbenchAdapter workbenchAdapter;
                testIsSet = true;
                ImageDescriptor imageDescriptor = null;
                if (test instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)test.getAdapter(IWorkbenchAdapter.class)) != null) {
                    imageDescriptor = workbenchAdapter.getImageDescriptor((Object)test);
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (test.getName() != null) {
                    this.testLink.setText(test.getName());
                } else {
                    this.testLink.setText(UiPluginResourceBundle.W_TEST);
                }
                this.testLink.setData(test);
                TPFTestSuite testSuite = null;
                testSuite = test instanceof TPFTestSuite ? (TPFTestSuite)test : ((TPFTestCase)test).getTestSuite();
                if (testSuite != null && (value = testSuite.getType()) != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)testSuite));
                if (this.executionResult.getVerdict() != null) {
                    this.verdictText.setText(this.executionResult.getVerdict().getLabel());
                } else {
                    this.verdictText.setText("");
                }
                this.startText.setText(EventUtil.getTime(EventUtil.getStartTimeStamp(this.executionResult)));
                this.stopText.setText(EventUtil.getTime(EventUtil.getStopTimeStamp(this.executionResult)));
                TPFDeployment deployment = this.executionResult.getDeployment();
                if (deployment != null && test instanceof TPFTestSuite) {
                    this.createDeploymentLinks(deployment, (TPFTestSuite)test);
                }
            }
        } else {
            this.verdictText.setText("");
            this.startText.setText("");
            this.stopText.setText("");
        }
        if (!testIsSet) {
            doPack = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(UiPluginResourceBundle.NO_TST_TO_INV);
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
        }
        if (doPack) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
    }

    public Object getInput() {
        return this.executionResult;
    }

    public void linkActivated(Control linkLabel) {
        Object data = linkLabel.getData();
        if (data != null) {
            EObject eObject = (EObject)data;
            IEditorPart editorPart = TestUIUtil.openEditor(eObject.eResource(), null, false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);
        }
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }
}

